/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.cfg;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Trap;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.AssignStmt;
import soot.jimple.FieldRef;
import soot.jimple.InvokeExpr;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.VirtualInvokeExpr;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.toolkits.callgraph.Edge;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.JimpleBasedInterproceduralCFG;
import soot.toolkits.exceptions.ThrowableSet;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.graph.ExceptionalUnitGraph;
import soot.toolkits.graph.MHGDominatorsFinder;
import soot.toolkits.graph.MHGPostDominatorsFinder;

public class InfoflowCFG
implements IInfoflowCFG {
    protected static final int MAX_SIDE_EFFECT_ANALYSIS_DEPTH = 25;
    protected static final int MAX_STATIC_USE_ANALYSIS_DEPTH = 50;
    protected final Map<SootMethod, Map<SootField, StaticFieldUse>> staticFieldUses = new ConcurrentHashMap<SootMethod, Map<SootField, StaticFieldUse>>();
    protected final Map<SootMethod, Boolean> methodSideEffects = new ConcurrentHashMap<SootMethod, Boolean>();
    protected final BiDiInterproceduralCFG<Unit, SootMethod> delegate;
    protected final LoadingCache<Unit, IInfoflowCFG.UnitContainer> unitsToDominator = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<Unit, IInfoflowCFG.UnitContainer>(){

        public IInfoflowCFG.UnitContainer load(Unit unit) throws Exception {
            SootMethod method = InfoflowCFG.this.getMethodOf(unit);
            DirectedGraph graph = InfoflowCFG.this.delegate.getOrCreateUnitGraph((Object)method);
            MHGDominatorsFinder dominatorFinder = new MHGDominatorsFinder(graph);
            Unit dom = (Unit)dominatorFinder.getImmediateDominator((Object)unit);
            if (dom == null) {
                return new IInfoflowCFG.UnitContainer(method);
            }
            return new IInfoflowCFG.UnitContainer(dom);
        }
    });
    protected final LoadingCache<Unit, IInfoflowCFG.UnitContainer> unitToPostdominator = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<Unit, IInfoflowCFG.UnitContainer>(){

        public IInfoflowCFG.UnitContainer load(Unit unit) throws Exception {
            SootMethod method = InfoflowCFG.this.getMethodOf(unit);
            DirectedGraph graph = InfoflowCFG.this.delegate.getOrCreateUnitGraph((Object)method);
            MHGPostDominatorsFinder postdominatorFinder = new MHGPostDominatorsFinder(graph);
            Unit postdom = (Unit)postdominatorFinder.getImmediateDominator((Object)unit);
            if (postdom == null) {
                return new IInfoflowCFG.UnitContainer(method);
            }
            return new IInfoflowCFG.UnitContainer(postdom);
        }
    });
    protected final LoadingCache<SootMethod, Local[]> methodToUsedLocals = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, Local[]>(){

        public Local[] load(SootMethod method) throws Exception {
            if (!method.isConcrete() || !method.hasActiveBody()) {
                return new Local[0];
            }
            ArrayList<Local> lcs = new ArrayList<Local>(method.getParameterCount() + (method.isStatic() ? 0 : 1));
            for (Unit u : method.getActiveBody().getUnits()) {
                block1: for (ValueBox vb : u.getUseBoxes()) {
                    for (int i = 0; i < method.getParameterCount(); ++i) {
                        if (method.getActiveBody().getParameterLocal(i) != vb.getValue()) continue;
                        lcs.add((Local)vb.getValue());
                        continue block1;
                    }
                }
            }
            if (!method.isStatic()) {
                lcs.add(method.getActiveBody().getThisLocal());
            }
            return lcs.toArray(new Local[lcs.size()]);
        }
    });
    protected final LoadingCache<SootMethod, Local[]> methodToWrittenLocals = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootMethod, Local[]>(){

        public Local[] load(SootMethod method) throws Exception {
            if (!method.isConcrete() || !method.hasActiveBody()) {
                return new Local[0];
            }
            ArrayList<Local> lcs = new ArrayList<Local>(method.getActiveBody().getLocalCount());
            for (Unit u : method.getActiveBody().getUnits()) {
                AssignStmt assignStmt;
                if (!(u instanceof AssignStmt) || !((assignStmt = (AssignStmt)u).getLeftOp() instanceof Local)) continue;
                lcs.add((Local)assignStmt.getLeftOp());
            }
            return lcs.toArray(new Local[lcs.size()]);
        }
    });

    public InfoflowCFG() {
        this((BiDiInterproceduralCFG<Unit, SootMethod>)new JimpleBasedInterproceduralCFG(true, true));
    }

    public InfoflowCFG(BiDiInterproceduralCFG<Unit, SootMethod> delegate) {
        this.delegate = delegate;
    }

    @Override
    public IInfoflowCFG.UnitContainer getPostdominatorOf(Unit u) {
        return (IInfoflowCFG.UnitContainer)this.unitToPostdominator.getUnchecked((Object)u);
    }

    @Override
    public IInfoflowCFG.UnitContainer getDominatorOf(Unit u) {
        return (IInfoflowCFG.UnitContainer)this.unitsToDominator.getUnchecked((Object)u);
    }

    public SootMethod getMethodOf(Unit u) {
        if (u == null) {
            throw new RuntimeException("Cannot get the method that contains a null unit");
        }
        return (SootMethod)this.delegate.getMethodOf((Object)u);
    }

    public List<Unit> getSuccsOf(Unit u) {
        return this.delegate.getSuccsOf((Object)u);
    }

    public boolean isExitStmt(Unit u) {
        return this.delegate.isExitStmt((Object)u);
    }

    public boolean isStartPoint(Unit u) {
        return this.delegate.isStartPoint((Object)u);
    }

    public boolean isFallThroughSuccessor(Unit u, Unit succ) {
        return this.delegate.isFallThroughSuccessor((Object)u, (Object)succ);
    }

    public boolean isBranchTarget(Unit u, Unit succ) {
        return this.delegate.isBranchTarget((Object)u, (Object)succ);
    }

    public Collection<Unit> getStartPointsOf(SootMethod m) {
        return this.delegate.getStartPointsOf((Object)m);
    }

    public boolean isCallStmt(Unit u) {
        return this.delegate.isCallStmt((Object)u);
    }

    public Set<Unit> allNonCallStartNodes() {
        return this.delegate.allNonCallStartNodes();
    }

    public Collection<SootMethod> getCalleesOfCallAt(Unit u) {
        return this.delegate.getCalleesOfCallAt((Object)u);
    }

    public Collection<Unit> getCallersOf(SootMethod m) {
        return this.delegate.getCallersOf((Object)m);
    }

    public Collection<Unit> getReturnSitesOfCallAt(Unit u) {
        return this.delegate.getReturnSitesOfCallAt((Object)u);
    }

    public Set<Unit> getCallsFromWithin(SootMethod m) {
        return this.delegate.getCallsFromWithin((Object)m);
    }

    public List<Unit> getPredsOf(Unit u) {
        return this.delegate.getPredsOf((Object)u);
    }

    public Collection<Unit> getEndPointsOf(SootMethod m) {
        return this.delegate.getEndPointsOf((Object)m);
    }

    public List<Unit> getPredsOfCallAt(Unit u) {
        return this.delegate.getPredsOf((Object)u);
    }

    public Set<Unit> allNonCallEndNodes() {
        return this.delegate.allNonCallEndNodes();
    }

    public DirectedGraph<Unit> getOrCreateUnitGraph(SootMethod m) {
        return this.delegate.getOrCreateUnitGraph((Object)m);
    }

    public List<Value> getParameterRefs(SootMethod m) {
        return this.delegate.getParameterRefs((Object)m);
    }

    public boolean isReturnSite(Unit n) {
        return this.delegate.isReturnSite((Object)n);
    }

    @Override
    public boolean isStaticFieldRead(SootMethod method, SootField variable) {
        StaticFieldUse use = this.checkStaticFieldUsed(method, variable);
        return use == StaticFieldUse.Read || use == StaticFieldUse.ReadWrite || use == StaticFieldUse.Unknown;
    }

    @Override
    public boolean isStaticFieldUsed(SootMethod method, SootField variable) {
        StaticFieldUse use = this.checkStaticFieldUsed(method, variable);
        return use == StaticFieldUse.Write || use == StaticFieldUse.ReadWrite || use == StaticFieldUse.Unknown;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected StaticFieldUse checkStaticFieldUsed(SootMethod smethod, SootField variable) {
        SootMethod method;
        if (!smethod.isConcrete() || !smethod.hasActiveBody()) {
            return StaticFieldUse.Unused;
        }
        ArrayList<SootMethod> workList = new ArrayList<SootMethod>(50);
        workList.add(smethod);
        SootMethod tempUses = new HashMap();
        int processedMethods = 0;
        while (!workList.isEmpty()) {
            StaticFieldUse b;
            method = (SootMethod)workList.remove(workList.size() - 1);
            ++processedMethods;
            if (!method.hasActiveBody()) continue;
            if (processedMethods > 50) {
                return StaticFieldUse.Unknown;
            }
            boolean hasInvocation = false;
            boolean reads = false;
            boolean writes = false;
            Map<SootField, StaticFieldUse> entry = this.staticFieldUses.get(method);
            if (entry != null && (b = entry.get(variable)) != null && b != StaticFieldUse.Unknown) {
                tempUses.put(method, b);
                continue;
            }
            StaticFieldUse oldUse = (StaticFieldUse)((Object)tempUses.get(method));
            for (Unit u : method.getActiveBody().getUnits()) {
                if (u instanceof AssignStmt) {
                    SootField sf;
                    AssignStmt assign = (AssignStmt)u;
                    if (assign.getLeftOp() instanceof StaticFieldRef) {
                        sf = ((StaticFieldRef)assign.getLeftOp()).getField();
                        this.registerStaticVariableUse(method, sf, StaticFieldUse.Write);
                        if (variable.equals(sf)) {
                            writes = true;
                        }
                    }
                    if (assign.getRightOp() instanceof StaticFieldRef) {
                        sf = ((StaticFieldRef)assign.getRightOp()).getField();
                        this.registerStaticVariableUse(method, sf, StaticFieldUse.Read);
                        if (variable.equals(sf)) {
                            reads = true;
                        }
                    }
                }
                if (!((Stmt)u).containsInvokeExpr()) continue;
                Iterator edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
                while (edgeIt.hasNext()) {
                    Edge e = (Edge)edgeIt.next();
                    SootMethod callee = e.getTgt().method();
                    if (!callee.isConcrete()) continue;
                    StaticFieldUse calleeUse = (StaticFieldUse)((Object)tempUses.get(callee));
                    if (calleeUse == null) {
                        if (!hasInvocation) {
                            workList.add(method);
                        }
                        workList.add(callee);
                        hasInvocation = true;
                        continue;
                    }
                    reads |= calleeUse == StaticFieldUse.Read || calleeUse == StaticFieldUse.ReadWrite;
                    writes |= calleeUse == StaticFieldUse.Write || calleeUse == StaticFieldUse.ReadWrite;
                }
            }
            StaticFieldUse fieldUse = StaticFieldUse.Unused;
            if (reads && writes) {
                fieldUse = StaticFieldUse.ReadWrite;
            } else if (reads) {
                fieldUse = StaticFieldUse.Read;
            } else if (writes) {
                fieldUse = StaticFieldUse.Write;
            }
            if (fieldUse == oldUse) continue;
            tempUses.put(method, fieldUse);
        }
        method = tempUses;
        synchronized (method) {
            for (Map.Entry tempEntry : tempUses.entrySet()) {
                this.registerStaticVariableUse((SootMethod)tempEntry.getKey(), variable, (StaticFieldUse)((Object)tempEntry.getValue()));
            }
        }
        StaticFieldUse outerUse = (StaticFieldUse)((Object)tempUses.get(smethod));
        return outerUse == null ? StaticFieldUse.Unknown : outerUse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void registerStaticVariableUse(SootMethod method, SootField variable, StaticFieldUse fieldUse) {
        StaticFieldUse newUse;
        StaticFieldUse oldUse;
        Map<SootField, StaticFieldUse> entry = this.staticFieldUses.get(method);
        Map<SootMethod, Map<SootField, StaticFieldUse>> map = this.staticFieldUses;
        synchronized (map) {
            if (entry == null) {
                entry = new ConcurrentHashMap<SootField, StaticFieldUse>();
                this.staticFieldUses.put(method, entry);
                entry.put(variable, fieldUse);
                return;
            }
            oldUse = entry.get(variable);
            if (oldUse == null) {
                entry.put(variable, fieldUse);
                return;
            }
        }
        switch (oldUse) {
            case Unknown: 
            case Unused: 
            case ReadWrite: {
                newUse = fieldUse;
                break;
            }
            case Read: {
                newUse = fieldUse == StaticFieldUse.Read ? oldUse : StaticFieldUse.ReadWrite;
                break;
            }
            case Write: {
                newUse = fieldUse == StaticFieldUse.Write ? oldUse : StaticFieldUse.ReadWrite;
                break;
            }
            default: {
                throw new RuntimeException("Invalid field use");
            }
        }
        entry.put(variable, newUse);
    }

    @Override
    public boolean hasSideEffects(SootMethod method) {
        return this.hasSideEffects(method, new HashSet<SootMethod>(), 0);
    }

    protected boolean hasSideEffects(SootMethod method, Set<SootMethod> runList, int depth) {
        if (!method.hasActiveBody()) {
            return false;
        }
        if (!runList.add(method)) {
            return false;
        }
        Boolean hasSideEffects = this.methodSideEffects.get(method);
        if (hasSideEffects != null) {
            return hasSideEffects;
        }
        if (depth > 25) {
            return true;
        }
        for (Unit u : method.getActiveBody().getUnits()) {
            AssignStmt assign;
            if (u instanceof AssignStmt && (assign = (AssignStmt)u).getLeftOp() instanceof FieldRef) {
                this.methodSideEffects.put(method, true);
                return true;
            }
            if (!((Stmt)u).containsInvokeExpr()) continue;
            Iterator edgeIt = Scene.v().getCallGraph().edgesOutOf(u);
            while (edgeIt.hasNext()) {
                Edge e = (Edge)edgeIt.next();
                if (!this.hasSideEffects(e.getTgt().method(), runList, depth++)) continue;
                return true;
            }
        }
        this.methodSideEffects.put(method, false);
        return false;
    }

    @Override
    public void notifyMethodChanged(SootMethod m) {
        if (this.delegate instanceof JimpleBasedInterproceduralCFG) {
            ((JimpleBasedInterproceduralCFG)this.delegate).initializeUnitToOwner(m);
        }
    }

    @Override
    public boolean methodReadsValue(SootMethod m, Value v) {
        Local[] reads = (Local[])this.methodToUsedLocals.getUnchecked((Object)m);
        if (reads != null) {
            for (Local l : reads) {
                if (l != v) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean methodWritesValue(SootMethod m, Value v) {
        Local[] writes = (Local[])this.methodToWrittenLocals.getUnchecked((Object)m);
        if (writes != null) {
            for (Local l : writes) {
                if (l != v) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isExceptionalEdgeBetween(Unit u1, Unit u2) {
        ThrowableSet ts;
        SootMethod m2;
        SootMethod m1 = this.getMethodOf(u1);
        if (m1 != (m2 = this.getMethodOf(u2))) {
            throw new RuntimeException("Exceptional edges are only supported inside the same method");
        }
        DirectedGraph<Unit> ug1 = this.getOrCreateUnitGraph(m1);
        if (!(ug1 instanceof ExceptionalUnitGraph)) {
            return false;
        }
        ExceptionalUnitGraph eug = (ExceptionalUnitGraph)ug1;
        if (!eug.getExceptionalSuccsOf(u1).contains(u2)) {
            return false;
        }
        Collection dests = eug.getExceptionDests(u1);
        if (dests != null && !dests.isEmpty() && (ts = Scene.v().getDefaultThrowAnalysis().mightThrow(u1)) != null) {
            boolean hasTraps = false;
            for (ExceptionalUnitGraph.ExceptionDest dest : dests) {
                Trap trap = dest.getTrap();
                if (trap == null) continue;
                hasTraps = true;
                if (ts.catchableAs(trap.getException().getType())) continue;
                return false;
            }
            if (!hasTraps) {
                return false;
            }
        }
        return true;
    }

    @Override
    public List<Unit> getConditionalBranchIntraprocedural(Unit callSite) {
        return null;
    }

    @Override
    public List<Unit> getConditionalBranchesInterprocedural(Unit unit) {
        return null;
    }

    public boolean isReachable(Unit u) {
        return this.delegate.isReachable((Object)u);
    }

    @Override
    public boolean isExecutorExecute(InvokeExpr ie, SootMethod dest) {
        if (ie == null || dest == null) {
            return false;
        }
        SootMethod ieMethod = ie.getMethod();
        if (!ieMethod.getName().equals("execute") && !ieMethod.getName().equals("doPrivileged")) {
            return false;
        }
        String ieSubSig = ieMethod.getSubSignature();
        String calleeSubSig = dest.getSubSignature();
        if (ieSubSig.equals("void execute(java.lang.Runnable)") && calleeSubSig.equals("void run()")) {
            return true;
        }
        if (dest.getName().equals("run") && dest.getParameterCount() == 0 && dest.getReturnType() instanceof RefType) {
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedAction)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedAction,java.security.AccessControlContext)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction)")) {
                return true;
            }
            if (ieSubSig.equals("java.lang.Object doPrivileged(java.security.PrivilegedExceptionAction,java.security.AccessControlContext)")) {
                return true;
            }
        }
        return false;
    }

    @Override
    public Collection<SootMethod> getOrdinaryCalleesOfCallAt(Unit u) {
        InvokeExpr iexpr = ((Stmt)u).getInvokeExpr();
        Collection<SootMethod> originalCallees = this.getCalleesOfCallAt(u);
        ArrayList<SootMethod> callees = new ArrayList<SootMethod>(originalCallees.size());
        for (SootMethod sm : originalCallees) {
            if (sm.isStaticInitializer() || this.isExecutorExecute(iexpr, sm)) continue;
            callees.add(sm);
        }
        return callees;
    }

    @Override
    public boolean isReflectiveCallSite(Unit u) {
        if (this.isCallStmt(u)) {
            InvokeExpr iexpr = ((Stmt)u).getInvokeExpr();
            return this.isReflectiveCallSite(iexpr);
        }
        return false;
    }

    @Override
    public boolean isReflectiveCallSite(InvokeExpr iexpr) {
        VirtualInvokeExpr viexpr;
        return iexpr instanceof VirtualInvokeExpr && (viexpr = (VirtualInvokeExpr)iexpr).getBase().getType() instanceof RefType && ((RefType)viexpr.getBase().getType()).getSootClass().getName().equals("java.lang.reflect.Method") && viexpr.getMethod().getName().equals("invoke");
    }

    @Override
    public void purge() {
        this.methodSideEffects.clear();
        this.staticFieldUses.clear();
        this.methodToUsedLocals.invalidateAll();
        this.methodToUsedLocals.cleanUp();
        this.methodToWrittenLocals.invalidateAll();
        this.methodToWrittenLocals.cleanUp();
        this.unitToPostdominator.invalidateAll();
        this.unitToPostdominator.cleanUp();
        this.unitsToDominator.invalidateAll();
        this.unitsToDominator.cleanUp();
    }

    public static enum StaticFieldUse {
        Unknown,
        Unused,
        Read,
        Write,
        ReadWrite;


        public StaticFieldUse merge(StaticFieldUse p) {
            if (this == Read && p == Write || this == Write && p == Read) {
                return ReadWrite;
            }
            if (this == ReadWrite || p == ReadWrite) {
                return ReadWrite;
            }
            if (p == this) {
                return this;
            }
            if (p == Unused) {
                return this;
            }
            if (this == Unused) {
                return p;
            }
            return Unknown;
        }
    }
}

