/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.fastSolver.flowInsensitive;

import com.google.common.cache.CacheBuilder;
import heros.DontSynchronize;
import heros.FlowFunction;
import heros.FlowFunctionCache;
import heros.FlowFunctions;
import heros.IFDSTabulationProblem;
import heros.SynchronizedBy;
import heros.solver.Pair;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.solver.AbstractIFDSSolver;
import soot.jimple.infoflow.solver.EndSummary;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.executors.SetPoolExecutor;
import soot.jimple.infoflow.solver.fastSolver.FastSolverLinkedNode;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class FlowInsensitiveSolver<N extends Unit, D extends FastSolverLinkedNode<D, N>, I extends BiDiInterproceduralCFG<Unit, SootMethod>>
extends AbstractIFDSSolver<N, D>
implements IMemoryBoundedSolver {
    public static CacheBuilder<Object, Object> DEFAULT_CACHE_BUILDER = CacheBuilder.newBuilder().concurrencyLevel(Runtime.getRuntime().availableProcessors()).initialCapacity(10000).softValues();
    protected static final Logger logger = LoggerFactory.getLogger(FlowInsensitiveSolver.class);
    public static final boolean DEBUG = logger.isDebugEnabled();
    protected InterruptableExecutor executor;
    @DontSynchronize(value="only used by single thread")
    protected int numThreads;
    @SynchronizedBy(value="thread safe data structure, consistent locking when used")
    protected MyConcurrentHashMap<PathEdge<SootMethod, D>, D> jumpFunctions = new MyConcurrentHashMap();
    @SynchronizedBy(value="thread safe data structure, only modified internally")
    protected final I icfg;
    @SynchronizedBy(value="consistent lock on 'incoming'")
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, Set<EndSummary<N, D>>> endSummary = new MyConcurrentHashMap();
    @SynchronizedBy(value="consistent lock on field")
    protected final MyConcurrentHashMap<Pair<SootMethod, D>, MyConcurrentHashMap<Unit, Map<D, D>>> incoming = new MyConcurrentHashMap();
    @DontSynchronize(value="stateless")
    protected final FlowFunctions<Unit, D, SootMethod> flowFunctions;
    @DontSynchronize(value="only used by single thread")
    protected final Map<Unit, Set<D>> initialSeeds;
    @DontSynchronize(value="benign races")
    public long propagationCount;
    @DontSynchronize(value="stateless")
    protected final D zeroValue;
    @DontSynchronize(value="readOnly")
    protected final FlowFunctionCache<Unit, D, SootMethod> ffCache;
    @DontSynchronize(value="readOnly")
    protected final boolean followReturnsPastSeeds;
    @DontSynchronize(value="readOnly")
    private int maxJoinPointAbstractions = -1;
    @DontSynchronize(value="readOnly")
    protected IMemoryManager<D, N> memoryManager = null;
    private boolean solverId = true;
    private Set<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification> notificationListeners = new HashSet<IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification>();
    private ISolverTerminationReason killFlag = null;
    private int maxCalleesPerCallSite = 10;
    private int maxAbstractionPathLength = 100;

    public FlowInsensitiveSolver(IFDSTabulationProblem<Unit, D, SootMethod, I> tabulationProblem) {
        this(tabulationProblem, DEFAULT_CACHE_BUILDER);
    }

    public FlowInsensitiveSolver(IFDSTabulationProblem<Unit, D, SootMethod, I> tabulationProblem, CacheBuilder flowFunctionCacheBuilder) {
        FlowFunctionCache<Unit, D, SootMethod> flowFunctions;
        if (logger.isDebugEnabled()) {
            flowFunctionCacheBuilder = flowFunctionCacheBuilder.recordStats();
        }
        this.zeroValue = (FastSolverLinkedNode)tabulationProblem.zeroValue();
        this.icfg = (BiDiInterproceduralCFG)tabulationProblem.interproceduralCFG();
        Object object = flowFunctions = tabulationProblem.autoAddZero() ? new FlowFunctionCache<Unit, D, SootMethod>(tabulationProblem.flowFunctions(), this.zeroValue) : tabulationProblem.flowFunctions();
        if (flowFunctionCacheBuilder != null) {
            this.ffCache = new FlowFunctionCache((FlowFunctions)flowFunctions, flowFunctionCacheBuilder);
            flowFunctions = this.ffCache;
        } else {
            this.ffCache = null;
        }
        this.flowFunctions = flowFunctions;
        this.initialSeeds = tabulationProblem.initialSeeds();
        this.followReturnsPastSeeds = tabulationProblem.followReturnsPastSeeds();
        this.numThreads = Math.max(1, tabulationProblem.numThreads());
        this.executor = this.getExecutor();
    }

    public void solve() {
        this.reset();
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverStarted(this);
        }
        this.submitInitialSeeds();
        this.awaitCompletionComputeValuesAndShutdown();
        for (IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener : this.notificationListeners) {
            listener.notifySolverTerminated(this);
        }
    }

    protected void submitInitialSeeds() {
        for (Map.Entry<Unit, Set<D>> seed : this.initialSeeds.entrySet()) {
            Unit startPoint = seed.getKey();
            SootMethod mp = (SootMethod)this.icfg.getMethodOf((Object)startPoint);
            for (FastSolverLinkedNode val : seed.getValue()) {
                if (this.icfg.isCallStmt((Object)startPoint)) {
                    this.processCall(this.zeroValue, startPoint, val);
                    continue;
                }
                if (this.icfg.isExitStmt((Object)startPoint)) {
                    this.processExit(this.zeroValue, startPoint, val);
                    continue;
                }
                this.processNormalFlow(this.zeroValue, startPoint, val, mp);
            }
            this.addFunction(new PathEdge(this.zeroValue, (Object)mp, this.zeroValue));
        }
    }

    protected void awaitCompletionComputeValuesAndShutdown() {
        this.runExecutorAndAwaitCompletion();
        if (logger.isDebugEnabled()) {
            this.printStats();
        }
        this.executor.shutdown();
        while (!this.executor.isTerminated()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
    }

    private void runExecutorAndAwaitCompletion() {
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        Throwable exception = this.executor.getException();
        if (exception != null) {
            throw new RuntimeException("There were exceptions during IFDS analysis. Exiting.", exception);
        }
    }

    protected boolean getSolverId() {
        return this.solverId;
    }

    protected void setSolverId(boolean solverId) {
        this.solverId = solverId;
    }

    protected void scheduleEdgeProcessing(PathEdge<SootMethod, D> edge) {
        if (this.killFlag != null || this.executor.isTerminating()) {
            return;
        }
        this.executor.execute(new PathEdgeProcessingTask(edge, this.getSolverId()));
        ++this.propagationCount;
    }

    private void processCall(D d1, Unit n, D d2) {
        Collection returnSiteNs = this.icfg.getReturnSitesOfCallAt((Object)n);
        Collection callees = this.icfg.getCalleesOfCallAt((Object)n);
        if (this.maxCalleesPerCallSite < 0 || callees.size() <= this.maxCalleesPerCallSite) {
            for (SootMethod sCalledProcN : callees) {
                FlowFunction function;
                Set<D> res;
                if (this.killFlag != null) {
                    return;
                }
                if (!sCalledProcN.isConcrete() || (res = this.computeCallFlowFunction(function = this.flowFunctions.getCallFlowFunction((Object)n, (Object)sCalledProcN), d1, d2)) == null || res.isEmpty()) continue;
                for (FastSolverLinkedNode d3 : res) {
                    if (this.memoryManager != null) {
                        d3 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d2, d3);
                    }
                    if (d3 == null) continue;
                    this.propagate(d3, sCalledProcN, d3, n, false);
                    if (!this.addIncoming(sCalledProcN, d3, n, d1, d2)) continue;
                    this.applyEndSummaryOnCall(d1, n, d2, returnSiteNs, sCalledProcN, d3);
                }
            }
        }
        for (Unit returnSiteN : returnSiteNs) {
            SootMethod retMeth = (SootMethod)this.icfg.getMethodOf((Object)returnSiteN);
            FlowFunction callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction((Object)n, (Object)returnSiteN);
            Set<D> res = this.computeCallToReturnFlowFunction(callToReturnFlowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d2, d3);
                }
                if (d3 == null) continue;
                this.propagate(d1, retMeth, d3, n, false);
            }
        }
    }

    protected void applyEndSummaryOnCall(D d1, Unit n, D d2, Collection<Unit> returnSiteNs, SootMethod sCalledProcN, D d3) {
        Set<EndSummary<N, D>> endSumm = this.endSummary(sCalledProcN, d3);
        if (endSumm != null && !endSumm.isEmpty()) {
            for (EndSummary<N, D> entry : endSumm) {
                Unit eP = (Unit)entry.eP;
                Object d4 = entry.d4;
                for (Unit retSiteN : returnSiteNs) {
                    SootMethod retMeth = (SootMethod)this.icfg.getMethodOf((Object)retSiteN);
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction((Object)n, (Object)sCalledProcN, (Object)eP, (Object)retSiteN);
                    Set<D> retFlowRes = this.computeReturnFlowFunction(retFunction, d3, d4, n, Collections.singleton(d1));
                    if (retFlowRes == null || retFlowRes.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : retFlowRes) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d4, d5);
                        }
                        FastSolverLinkedNode d5p = this.shortenPredecessors(d5, d2, d3, eP, n);
                        this.propagate(d1, retMeth, d5p, n, false, true);
                    }
                }
            }
        }
    }

    protected Set<D> computeCallFlowFunction(FlowFunction<D> callFlowFunction, D d1, D d2) {
        return callFlowFunction.computeTargets(d2);
    }

    protected Set<D> computeCallToReturnFlowFunction(FlowFunction<D> callToReturnFlowFunction, D d1, D d2) {
        return callToReturnFlowFunction.computeTargets(d2);
    }

    protected void processExit(D d1, Unit n, D d2) {
        SootMethod methodThatNeedsSummary = (SootMethod)this.icfg.getMethodOf((Object)n);
        if (!this.addEndSummary(methodThatNeedsSummary, d1, n, d2)) {
            return;
        }
        Map<Unit, Map<D, D>> inc = this.incoming(d1, methodThatNeedsSummary);
        if (inc != null && !inc.isEmpty()) {
            for (Map.Entry<Unit, Map<D, D>> entry : inc.entrySet()) {
                Unit c = entry.getKey();
                Set<D> callerSideDs = entry.getValue().keySet();
                for (Unit retSiteC : this.icfg.getReturnSitesOfCallAt((Object)c)) {
                    SootMethod returnMeth = (SootMethod)this.icfg.getMethodOf((Object)retSiteC);
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction((Object)c, (Object)methodThatNeedsSummary, (Object)n, (Object)retSiteC);
                    Set<D> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, callerSideDs);
                    for (Map.Entry<D, D> d1d2entry : entry.getValue().entrySet()) {
                        FastSolverLinkedNode d4 = (FastSolverLinkedNode)d1d2entry.getKey();
                        FastSolverLinkedNode predVal = (FastSolverLinkedNode)d1d2entry.getValue();
                        for (FastSolverLinkedNode d5 : targets) {
                            if (this.memoryManager != null) {
                                d5 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d2, d5);
                            }
                            if (d5 == null) continue;
                            FastSolverLinkedNode d5p = this.shortenPredecessors(d5, predVal, d1, n, c);
                            this.propagate(d4, returnMeth, d5p, c, false);
                        }
                    }
                }
            }
        }
        if (this.followReturnsPastSeeds && d1 == this.zeroValue && (inc == null || inc.isEmpty())) {
            Collection callers = this.icfg.getCallersOf((Object)methodThatNeedsSummary);
            for (Unit c : callers) {
                SootMethod callerMethod = (SootMethod)this.icfg.getMethodOf((Object)c);
                for (Unit retSiteC : this.icfg.getReturnSitesOfCallAt((Object)c)) {
                    FlowFunction retFunction = this.flowFunctions.getReturnFlowFunction((Object)c, (Object)methodThatNeedsSummary, (Object)n, (Object)retSiteC);
                    Set<D> targets = this.computeReturnFlowFunction(retFunction, d1, d2, c, Collections.singleton(this.zeroValue));
                    if (targets == null || targets.isEmpty()) continue;
                    for (FastSolverLinkedNode d5 : targets) {
                        if (this.memoryManager != null) {
                            d5 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d2, d5);
                        }
                        if (d5 == null) continue;
                        this.propagate(this.zeroValue, callerMethod, d5, c, true);
                    }
                }
            }
            if (callers.isEmpty()) {
                FlowFunction flowFunction = this.flowFunctions.getReturnFlowFunction(null, (Object)methodThatNeedsSummary, (Object)n, null);
                flowFunction.computeTargets(d2);
            }
        }
    }

    protected Set<D> computeReturnFlowFunction(FlowFunction<D> retFunction, D d1, D d2, Unit callSite, Collection<D> callerSideDs) {
        return retFunction.computeTargets(d2);
    }

    private void processNormalFlow(D d1, Unit n, D d2, SootMethod method) {
        for (Unit m : this.icfg.getSuccsOf((Object)n)) {
            FlowFunction flowFunction = this.flowFunctions.getNormalFlowFunction((Object)n, (Object)m);
            Set<D> res = this.computeNormalFlowFunction(flowFunction, d1, d2);
            if (res == null || res.isEmpty()) continue;
            for (FastSolverLinkedNode d3 : res) {
                if (this.memoryManager != null && d2 != d3) {
                    d3 = this.memoryManager.handleGeneratedMemoryObject((FastSolverLinkedNode)d2, d3);
                }
                if (d3 == null || d3 == d2) continue;
                this.propagate(d1, method, d3, null, false);
            }
        }
    }

    private void processMethod(PathEdge<SootMethod, D> edge) {
        FastSolverLinkedNode d1 = (FastSolverLinkedNode)edge.factAtSource();
        SootMethod target = (SootMethod)edge.getTarget();
        FastSolverLinkedNode d2 = (FastSolverLinkedNode)edge.factAtTarget();
        for (Unit u : target.getActiveBody().getUnits()) {
            if (this.icfg.isCallStmt((Object)u)) {
                this.processCall(d1, u, d2);
                continue;
            }
            if (this.icfg.isExitStmt((Object)u)) {
                this.processExit(d1, u, d2);
            }
            if (this.icfg.getSuccsOf((Object)u).isEmpty()) continue;
            this.processNormalFlow(d1, u, d2, target);
        }
    }

    protected Set<D> computeNormalFlowFunction(FlowFunction<D> flowFunction, D d1, D d2) {
        return flowFunction.computeTargets(d2);
    }

    protected void propagate(D sourceVal, SootMethod target, D targetVal, Unit relatedCallSite, boolean isUnbalancedReturn) {
        this.propagate(sourceVal, target, targetVal, relatedCallSite, isUnbalancedReturn, true);
    }

    protected void propagate(D sourceVal, SootMethod target, D targetVal, Unit relatedCallSite, boolean isUnbalancedReturn, boolean schedule) {
        if (this.memoryManager != null) {
            sourceVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(sourceVal);
            targetVal = (FastSolverLinkedNode)this.memoryManager.handleMemoryObject(targetVal);
            if (sourceVal == null || targetVal == null) {
                return;
            }
        }
        if (this.maxAbstractionPathLength >= 0 && targetVal.getPathLength() > this.maxAbstractionPathLength) {
            return;
        }
        PathEdge edge = new PathEdge(sourceVal, (Object)target, targetVal);
        D existingVal = this.addFunction(edge);
        if (existingVal != null) {
            boolean isEssential = this.memoryManager == null ? relatedCallSite != null && this.icfg.isCallStmt((Object)relatedCallSite) : this.memoryManager.isEssentialJoinPoint(targetVal, relatedCallSite);
            if (this.maxJoinPointAbstractions < 0 || existingVal.getNeighborCount() < this.maxJoinPointAbstractions || isEssential) {
                existingVal.addNeighbor(targetVal);
            }
        } else if (schedule) {
            this.scheduleEdgeProcessing(edge);
        }
    }

    public D addFunction(PathEdge<SootMethod, D> edge) {
        return (D)this.jumpFunctions.putIfAbsent(edge, (FastSolverLinkedNode)edge.factAtTarget());
    }

    protected Set<EndSummary<N, D>> endSummary(SootMethod m, D d3) {
        return (Set)this.endSummary.get(new Pair((Object)m, d3));
    }

    private boolean addEndSummary(SootMethod m, D d1, Unit eP, D d2) {
        if (d1 == this.zeroValue) {
            return true;
        }
        Set summaries = this.endSummary.computeIfAbsent(new Pair((Object)m, d1), x -> new ConcurrentHashSet());
        return summaries.add(new EndSummary<Unit, D>(eP, d2, d1));
    }

    protected Map<Unit, Map<D, D>> incoming(D d1, SootMethod m) {
        return (Map)this.incoming.get(new Pair((Object)m, d1));
    }

    protected boolean addIncoming(SootMethod m, D d3, Unit n, D d1, D d2) {
        MyConcurrentHashMap summaries = this.incoming.putIfAbsentElseGet(new Pair((Object)m, d3), new MyConcurrentHashMap());
        Map set = summaries.putIfAbsentElseGet(n, new ConcurrentHashMap());
        return set.put(d1, d2) == null;
    }

    protected InterruptableExecutor getExecutor() {
        return new SetPoolExecutor(1, this.numThreads, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>());
    }

    protected String getDebugName() {
        return "FAST IFDS SOLVER";
    }

    public void printStats() {
        if (logger.isDebugEnabled()) {
            if (this.ffCache != null) {
                this.ffCache.printStats();
            }
        } else {
            logger.info("No statistics were collected, as DEBUG is disabled.");
        }
    }

    public void setMaxJoinPointAbstractions(int maxJoinPointAbstractions) {
        this.maxJoinPointAbstractions = maxJoinPointAbstractions;
    }

    public void setMemoryManager(IMemoryManager<D, N> memoryManager) {
        this.memoryManager = memoryManager;
    }

    public IMemoryManager<D, N> getMemoryManager() {
        return this.memoryManager;
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
        this.killFlag = reason;
        this.executor.interrupt();
        this.executor.shutdown();
    }

    @Override
    public boolean isTerminated() {
        return this.killFlag != null || this.executor.isFinished();
    }

    @Override
    public boolean isKilled() {
        return this.killFlag != null;
    }

    @Override
    public void reset() {
        this.killFlag = null;
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
        this.notificationListeners.add(listener);
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return this.killFlag;
    }

    public void setMaxCalleesPerCallSite(int maxCalleesPerCallSite) {
        this.maxCalleesPerCallSite = maxCalleesPerCallSite;
    }

    public void setMaxAbstractionPathLength(int maxAbstractionPathLength) {
        this.maxAbstractionPathLength = maxAbstractionPathLength;
    }

    private class PathEdgeProcessingTask
    implements Runnable {
        private final PathEdge<SootMethod, D> edge;
        private final boolean solverId;

        public PathEdgeProcessingTask(PathEdge<SootMethod, D> edge, boolean solverId) {
            this.edge = edge;
            this.solverId = solverId;
        }

        @Override
        public void run() {
            FlowInsensitiveSolver.this.processMethod(this.edge);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.edge == null ? 0 : this.edge.hashCode());
            return result += this.solverId ? 1337 : 13;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PathEdgeProcessingTask other = (PathEdgeProcessingTask)obj;
            if (this.edge == null ? other.edge != null : !this.edge.equals(other.edge)) {
                return false;
            }
            return this.solverId == other.solverId;
        }

        public String toString() {
            return this.edge.toString();
        }
    }
}

