/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver;

import heros.solver.PathEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootMethod;
import soot.jimple.infoflow.solver.gcSolver.IGCReferenceProvider;
import soot.jimple.infoflow.solver.gcSolver.MethodLevelReferenceCountingGarbageCollector;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class ThreadedGarbageCollector<N, D>
extends MethodLevelReferenceCountingGarbageCollector<N, D> {
    protected static final Logger logger = LoggerFactory.getLogger(ThreadedGarbageCollector.class);
    private int sleepTimeSeconds = 1;
    private int maxPathEdgeCount = 0;
    private int maxMemoryConsumption = 0;
    private GCThread gcThread;

    public ThreadedGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions, IGCReferenceProvider<SootMethod> referenceProvider) {
        super(icfg, jumpFunctions, referenceProvider);
    }

    public ThreadedGarbageCollector(BiDiInterproceduralCFG<N, SootMethod> icfg, ConcurrentHashMultiMap<SootMethod, PathEdge<N, D>> jumpFunctions) {
        super(icfg, jumpFunctions);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.gcThread = new GCThread();
        this.gcThread.start();
    }

    @Override
    public void gc() {
    }

    @Override
    public void notifySolverTerminated() {
        this.gcImmediate();
        logger.info(String.format("GC removes %d abstractions", this.getGcedAbstractions()));
        logger.info(String.format("GC removes %d path edges", this.getGcedEdges()));
        logger.info(String.format("Remaining Path edges count is %d", this.getRemainingPathEdgeCount()));
        logger.info(String.format("Recorded Maximum Path edges count is %d", this.getMaxPathEdgeCount()));
        logger.info(String.format("Recorded Maximum memory consumption is %d", this.getMaxMemoryConsumption()));
        this.gcThread.finish();
    }

    public void setSleepTimeSeconds(int sleepTimeSeconds) {
        this.sleepTimeSeconds = sleepTimeSeconds;
    }

    private int getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (int)Math.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1000000.0);
    }

    public long getMaxPathEdgeCount() {
        return this.maxPathEdgeCount;
    }

    public int getMaxMemoryConsumption() {
        return this.maxMemoryConsumption;
    }

    @Override
    protected void onAfterRemoveEdges() {
        int pec = 0;
        for (Integer i : this.jumpFnCounter.values()) {
            pec += i.intValue();
        }
        this.maxPathEdgeCount = Math.max(this.maxPathEdgeCount, pec);
        this.maxMemoryConsumption = Math.max(this.maxMemoryConsumption, this.getUsedMemory());
    }

    private class GCThread
    extends Thread {
        private boolean finished = false;

        public GCThread() {
            this.setName("IFDS Garbage Collector");
        }

        @Override
        public void run() {
            while (!this.finished) {
                ThreadedGarbageCollector.this.gcImmediate();
                if (ThreadedGarbageCollector.this.sleepTimeSeconds <= 0) continue;
                try {
                    Thread.sleep(ThreadedGarbageCollector.this.sleepTimeSeconds * 1000);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }

        public void finish() {
            this.finished = true;
            this.interrupt();
        }
    }
}

