/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.gcSolver.fpc;

import heros.FlowFunction;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.EndSummary;
import soot.jimple.infoflow.solver.IFollowReturnsPastSeedsHandler;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.IncomingRecord;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.solver.gcSolver.fpc.IFDSSolver;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.ConcurrentHashMultiMap;

public class InfoflowSolver
extends IFDSSolver<Unit, Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>>
implements IInfoflowSolver {
    private IFollowReturnsPastSeedsHandler followReturnsPastSeedsHandler = null;
    private final AbstractInfoflowProblem problem;

    public InfoflowSolver(AbstractInfoflowProblem problem, InterruptableExecutor executor, int sleepTime) {
        super(problem, sleepTime);
        this.problem = problem;
        this.executor = executor;
        problem.setSolver(this);
    }

    @Override
    protected InterruptableExecutor getExecutor() {
        return this.executor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean processEdge(PathEdge<Unit, Abstraction> edge) {
        if (this.garbageCollector == null) {
            InfoflowSolver infoflowSolver = this;
            synchronized (infoflowSolver) {
                if (this.garbageCollector == null) {
                    this.garbageCollector = this.createGarbageCollector();
                }
            }
        }
        this.propagate((Abstraction)edge.factAtSource(), (Unit)edge.getTarget(), (Abstraction)edge.factAtTarget(), null, false, null);
        return true;
    }

    @Override
    public void injectContext(IInfoflowSolver otherSolver, SootMethod callee, Abstraction d3, Unit callSite, Abstraction d2, Abstraction d1) {
    }

    @Override
    public Set<IncomingRecord<Unit, Abstraction>> incoming(Abstraction d1, SootMethod m) {
        return this.solverPeerGroup.incoming(d1, m);
    }

    @Override
    public boolean addIncoming(SootMethod m, Abstraction d3, Unit n, Abstraction d1, Abstraction d2) {
        return this.solverPeerGroup.addIncoming(m, d3, n, d1, d2);
    }

    @Override
    public void applySummary(SootMethod callee, Abstraction d3, Unit callSite, Abstraction d2, Abstraction d1) {
        Collection returnSiteNs = this.icfg.getReturnSitesOfCallAt((Object)callSite);
        this.applyEndSummaryOnCall(d1, callSite, d2, returnSiteNs, callee, d3);
    }

    @Override
    protected Set<Abstraction> computeReturnFlowFunction(FlowFunction<Abstraction> retFunction, Abstraction d1, Abstraction d2, Unit callSite, Collection<Abstraction> callerSideDs) {
        if (retFunction instanceof SolverReturnFlowFunction) {
            return ((SolverReturnFlowFunction)retFunction).computeTargets(d2, d1, callerSideDs);
        }
        return retFunction.computeTargets((Object)d2);
    }

    @Override
    protected Set<Abstraction> computeNormalFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverNormalFlowFunction) {
            return ((SolverNormalFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets((Object)d2);
    }

    @Override
    protected Set<Abstraction> computeCallToReturnFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallToReturnFlowFunction) {
            return ((SolverCallToReturnFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets((Object)d2);
    }

    @Override
    protected Set<Abstraction> computeCallFlowFunction(FlowFunction<Abstraction> flowFunction, Abstraction d1, Abstraction d2) {
        if (flowFunction instanceof SolverCallFlowFunction) {
            return ((SolverCallFlowFunction)flowFunction).computeTargets(d1, d2);
        }
        return flowFunction.computeTargets((Object)d2);
    }

    @Override
    public void cleanup() {
        this.jumpFunctions = new ConcurrentHashMultiMap();
        this.incoming.clear();
        this.endSummary.clear();
        if (this.ffCache != null) {
            this.ffCache.invalidate();
        }
    }

    @Override
    public Set<EndSummary<Unit, Abstraction>> endSummary(SootMethod m, Abstraction d3) {
        return super.endSummary(m, d3);
    }

    @Override
    protected void processExit(PathEdge<Unit, Abstraction> edge) {
        super.processExit(edge);
        if (this.followReturnsPastSeeds && this.followReturnsPastSeedsHandler != null) {
            Abstraction d1 = (Abstraction)edge.factAtSource();
            Unit u = (Unit)edge.getTarget();
            Abstraction d2 = (Abstraction)edge.factAtTarget();
            SootMethod methodThatNeedsSummary = (SootMethod)this.icfg.getMethodOf((Object)u);
            Set<IncomingRecord<Unit, Abstraction>> inc = this.incoming(d1, methodThatNeedsSummary);
            if (inc == null || inc.isEmpty()) {
                this.followReturnsPastSeedsHandler.handleFollowReturnsPastSeeds(d1, u, d2);
            }
        }
    }

    @Override
    public void setFollowReturnsPastSeedsHandler(IFollowReturnsPastSeedsHandler handler) {
        this.followReturnsPastSeedsHandler = handler;
    }

    @Override
    public long getPropagationCount() {
        return this.propagationCount.sum();
    }

    @Override
    public AbstractInfoflowProblem getTabulationProblem() {
        return this.problem;
    }
}

