/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.definitions;

import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.jimple.Stmt;
import soot.jimple.infoflow.sourcesSinks.definitions.AbstractSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.IAccessPathBasedSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkType;

public class StatementSourceSinkDefinition
extends AbstractSourceSinkDefinition
implements IAccessPathBasedSourceSinkDefinition {
    protected final Stmt stmt;
    protected final Local local;
    protected Set<AccessPathTuple> accessPaths;

    public StatementSourceSinkDefinition(Stmt stmt, Local local, Set<AccessPathTuple> accessPaths) {
        if (accessPaths == null || accessPaths.isEmpty()) {
            throw new IllegalArgumentException("Access Paths must not be empty");
        }
        this.stmt = stmt;
        this.local = local;
        this.accessPaths = new HashSet<AccessPathTuple>(accessPaths);
    }

    public static StatementSourceSinkDefinition createBlankStatementSourceDefinition(Stmt stmt, Local local) {
        return new StatementSourceSinkDefinition(stmt, local, Collections.singleton(AccessPathTuple.getBlankSourceTuple()));
    }

    public static StatementSourceSinkDefinition createBlankStatementSinkDefinition(Stmt stmt, Local local) {
        return new StatementSourceSinkDefinition(stmt, local, Collections.singleton(AccessPathTuple.getBlankSinkTuple()));
    }

    @Override
    public StatementSourceSinkDefinition getSourceOnlyDefinition() {
        HashSet<AccessPathTuple> newSet = null;
        if (this.accessPaths != null) {
            newSet = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                SourceSinkType ssType = apt.getSourceSinkType();
                if (ssType == SourceSinkType.Source) {
                    newSet.add(apt);
                    continue;
                }
                if (ssType != SourceSinkType.Both) continue;
                newSet.add(new AccessPathTuple(apt.getBaseType(), apt.getFields(), apt.getFieldTypes(), SourceSinkType.Source));
            }
        }
        return this.buildNewDefinition(this.stmt, this.local, newSet);
    }

    @Override
    public StatementSourceSinkDefinition getSinkOnlyDefinition() {
        HashSet<AccessPathTuple> newSet = null;
        if (this.accessPaths != null) {
            newSet = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple apt : this.accessPaths) {
                SourceSinkType ssType = apt.getSourceSinkType();
                if (ssType == SourceSinkType.Sink) {
                    newSet.add(apt);
                    continue;
                }
                if (ssType != SourceSinkType.Both) continue;
                newSet.add(new AccessPathTuple(apt.getBaseType(), apt.getFields(), apt.getFieldTypes(), SourceSinkType.Sink));
            }
        }
        return this.buildNewDefinition(this.stmt, this.local, newSet);
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Local getLocal() {
        return this.local;
    }

    public Set<AccessPathTuple> getAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    public String toString() {
        return String.format("Local %s at %s", this.local, this.stmt);
    }

    @Override
    public Set<AccessPathTuple> getAllAccessPaths() {
        return this.accessPaths;
    }

    @Override
    public StatementSourceSinkDefinition filter(Collection<AccessPathTuple> toFilter) {
        HashSet<AccessPathTuple> filteredAPs = null;
        if (this.accessPaths != null && !this.accessPaths.isEmpty()) {
            filteredAPs = new HashSet<AccessPathTuple>(this.accessPaths.size());
            for (AccessPathTuple ap : this.accessPaths) {
                if (!toFilter.contains(ap)) continue;
                filteredAPs.add(ap);
            }
        }
        StatementSourceSinkDefinition def = this.buildNewDefinition(this.stmt, this.local, filteredAPs);
        def.setCategory(this.category);
        return def;
    }

    protected StatementSourceSinkDefinition buildNewDefinition(Stmt stmt, Local local, Set<AccessPathTuple> accessPaths) {
        StatementSourceSinkDefinition sssd = new StatementSourceSinkDefinition(stmt, local, accessPaths);
        sssd.category = this.category;
        return sssd;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accessPaths == null ? 0 : this.accessPaths.hashCode());
        result = 31 * result + (this.local == null ? 0 : this.local.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        StatementSourceSinkDefinition other = (StatementSourceSinkDefinition)obj;
        if (this.accessPaths == null ? other.accessPaths != null : !this.accessPaths.equals(other.accessPaths)) {
            return false;
        }
        if (this.local == null ? other.local != null : !this.local.equals((Object)other.local)) {
            return false;
        }
        return !(this.stmt == null ? other.stmt != null : !this.stmt.equals((Object)other.stmt));
    }
}

