/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import soot.Body;
import soot.RefType;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.jimple.InvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFragment;

public class SystemClassHandler {
    private static SystemClassHandler instance;
    private boolean excludeSystemComponents = true;

    public static SystemClassHandler v() {
        if (instance == null) {
            instance = new SystemClassHandler();
        }
        return instance;
    }

    public static void setInstance(SystemClassHandler instance) {
        SystemClassHandler.instance = instance;
    }

    public boolean isClassInSystemPackage(SootClass clazz) {
        return clazz != null && this.isClassInSystemPackage(clazz.getName());
    }

    public boolean isClassInSystemPackage(String className) {
        return (className.startsWith("android.") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("sun.") || className.startsWith("org.omg.") || className.startsWith("org.w3c.dom.") || className.startsWith("com.google.") || className.startsWith("com.android.")) && this.excludeSystemComponents;
    }

    public boolean isClassInSystemPackage(Type type) {
        if (type instanceof RefType) {
            return this.isClassInSystemPackage(((RefType)type).getSootClass().getName());
        }
        return false;
    }

    public boolean isTaintVisible(AccessPath taintedPath, SootMethod method) {
        if (taintedPath == null) {
            return true;
        }
        if (!taintedPath.isInstanceFieldRef()) {
            return true;
        }
        if (!this.isClassInSystemPackage(method.getDeclaringClass().getName())) {
            return true;
        }
        boolean hasSystemType = taintedPath.getBaseType() != null && this.isClassInSystemPackage(taintedPath.getBaseType());
        for (AccessPathFragment fragment : taintedPath.getFragments()) {
            boolean curFieldIsSystem;
            boolean bl = curFieldIsSystem = this.isClassInSystemPackage(fragment.getFieldType()) || this.isClassInSystemPackage((Type)fragment.getField().getDeclaringClass().getType());
            if (curFieldIsSystem) {
                hasSystemType = true;
                continue;
            }
            if (!hasSystemType) continue;
            return false;
        }
        return true;
    }

    public void setExcludeSystemComponents(boolean excludeSystemComponents) {
        this.excludeSystemComponents = excludeSystemComponents;
    }

    public boolean isStubImplementation(Body body) {
        StringConstant stubConst = StringConstant.v((String)"Stub!");
        for (Unit u : body.getUnits()) {
            InvokeExpr iexpr;
            SootMethod targetMethod;
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr() || !(targetMethod = (iexpr = stmt.getInvokeExpr()).getMethod()).isConstructor() || !targetMethod.getDeclaringClass().getName().equals("java.lang.RuntimeException") || iexpr.getArgCount() <= 0 || !iexpr.getArg(0).equals((Object)stubConst)) continue;
            return true;
        }
        return false;
    }
}

