package soot.jimple.infoflow.rifl;

/**
 * Constants for tag and attribute names in RIFL documents
 * 
 * @author Steven Arzt
 *
 */
class RIFLConstants {
	
	public static final String RIFL_SPEC_TAG = "riflspec";
	public static final String INTERFACE_SPEC_TAG = "interfacespec";
	
	public static final String SOURCE_TAG = "source";
	public static final String SINK_TAG = "sink";
	
	public static final String CATEGORY_TAG = "category";
	public static final String RETURN_VALUE_TAG = "returnvalue";
	public static final String FIELD_TAG = "field";
	public static final String PARAMETER_TAG = "parameter";
	
	public static final String DOMAINS_TAG = "domains";
	public static final String DOMAIN_TAG = "domain";
	
	public static final String DOMAIN_ASSIGNMENT_TAG = "domainassignment";
	public static final String ASSIGNABLE_TAG = "assignable";
	public static final String ASSIGN_TAG = "assign";
	
	public static final String FLOW_RELATION_TAG = "flowrelation";
	public static final String FLOW_TAG = "flow";
	
	public static final String CLASS_ATTRIBUTE = "class";
	public static final String METHOD_ATTRIBUTE = "method";
	public static final String PARAMETER_ATTRIBUTE = "parameter";
	public static final String FIELD_ATTRIBUTE = "field";
	
	public static final String NAME_ATTRIBUTE = "name";
	public static final String HANDLE_ATTRIBUTE = "handle";
	public static final String DOMAIN_ATTRIBUTE = "domain";
	
	public static final String FROM_ATTRIBUTE = "from";
	public static final String TO_ATTRIBUTE = "to";
	
}
