/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.ArrayType;
import soot.Body;
import soot.BooleanType;
import soot.ByteType;
import soot.CharType;
import soot.DoubleType;
import soot.FastHierarchy;
import soot.FloatType;
import soot.G;
import soot.IntType;
import soot.Local;
import soot.LongType;
import soot.MethodOrMethodContext;
import soot.MethodSource;
import soot.PackManager;
import soot.PointsToAnalysis;
import soot.RefType;
import soot.Scene;
import soot.ShortType;
import soot.SootClass;
import soot.SootMethod;
import soot.SootMethodRef;
import soot.Type;
import soot.Unit;
import soot.UnitPatchingChain;
import soot.Value;
import soot.javaToJimple.DefaultLocalGenerator;
import soot.jimple.AssignStmt;
import soot.jimple.DynamicInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.infoflow.IInfoflow;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.aliasing.BackwardsFlowSensitiveAliasStrategy;
import soot.jimple.infoflow.aliasing.IAliasingStrategy;
import soot.jimple.infoflow.aliasing.NullAliasStrategy;
import soot.jimple.infoflow.cfg.BiDirICFGFactory;
import soot.jimple.infoflow.cfg.DefaultBiDiICFGFactory;
import soot.jimple.infoflow.cfg.FlowDroidSinkStatement;
import soot.jimple.infoflow.cfg.FlowDroidSourceStatement;
import soot.jimple.infoflow.cfg.FlowDroidUserClass;
import soot.jimple.infoflow.cfg.LibraryClassPatcher;
import soot.jimple.infoflow.codeOptimization.DeadCodeEliminator;
import soot.jimple.infoflow.config.IInfoflowConfig;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.FlowDroidMemoryManager;
import soot.jimple.infoflow.data.pathBuilders.DefaultPathBuilderFactory;
import soot.jimple.infoflow.data.pathBuilders.IAbstractionPathBuilder;
import soot.jimple.infoflow.data.pathBuilders.IPathBuilderFactory;
import soot.jimple.infoflow.entryPointCreators.DefaultEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.IEntryPointCreator;
import soot.jimple.infoflow.entryPointCreators.SimulatedCodeElementTag;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.handlers.PostAnalysisHandler;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler;
import soot.jimple.infoflow.handlers.ResultsAvailableHandler2;
import soot.jimple.infoflow.handlers.SequentialTaintPropagationHandler;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.ipc.DefaultIPCManager;
import soot.jimple.infoflow.ipc.IIPCManager;
import soot.jimple.infoflow.memory.FlowDroidMemoryWatcher;
import soot.jimple.infoflow.memory.FlowDroidTimeoutWatcher;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.memory.reasons.AbortRequestedReason;
import soot.jimple.infoflow.memory.reasons.OutOfMemoryReason;
import soot.jimple.infoflow.memory.reasons.TimeoutReason;
import soot.jimple.infoflow.nativeCallHandler.BackwardNativeCallHandler;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.BackwardsAliasProblem;
import soot.jimple.infoflow.problems.BackwardsInfoflowProblem;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.IPropagationRuleManagerFactory;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.river.ConditionalFlowPostProcessor;
import soot.jimple.infoflow.river.ConditionalFlowSourceSinkManagerWrapper;
import soot.jimple.infoflow.river.EmptyUsageContextProvider;
import soot.jimple.infoflow.river.IConditionalFlowManager;
import soot.jimple.infoflow.river.IUsageContextProvider;
import soot.jimple.infoflow.river.SecondaryFlowGenerator;
import soot.jimple.infoflow.river.SecondaryFlowListener;
import soot.jimple.infoflow.solver.DefaultSolverPeerGroup;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.ISolverPeerGroup;
import soot.jimple.infoflow.solver.PredecessorShorteningMode;
import soot.jimple.infoflow.solver.cfg.BackwardsInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;
import soot.jimple.infoflow.solver.gcSolver.GCSolverPeerGroup;
import soot.jimple.infoflow.solver.memory.DefaultMemoryManagerFactory;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.solver.memory.IMemoryManagerFactory;
import soot.jimple.infoflow.solver.sparseSolver.SparseInfoflowSolver;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.DefaultSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.IOneSourceAtATimeManager;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.threading.DefaultExecutorFactory;
import soot.jimple.infoflow.threading.IExecutorFactory;
import soot.jimple.infoflow.util.SootMethodRepresentationParser;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.jimple.toolkits.pointer.DumbPointerAnalysis;
import soot.options.Options;
import soot.tagkit.Tag;
import soot.util.NumberedString;
import soot.util.queue.QueueReader;

public abstract class AbstractInfoflow
implements IInfoflow {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected InfoflowResults results = null;
    protected InfoflowManager manager;
    protected ISolverPeerGroup solverPeerGroup;
    protected IPathBuilderFactory pathBuilderFactory;
    protected InfoflowConfiguration config = new InfoflowConfiguration();
    protected ITaintPropagationWrapper taintWrapper;
    protected INativeCallHandler nativeCallHandler;
    protected IIPCManager ipcManager = new DefaultIPCManager(new ArrayList<String>());
    protected final BiDirICFGFactory icfgFactory;
    protected Collection<PreAnalysisHandler> preProcessors = new ArrayList<PreAnalysisHandler>();
    protected Collection<PostAnalysisHandler> postProcessors = new ArrayList<PostAnalysisHandler>();
    protected final File androidPath;
    protected final boolean forceAndroidJar;
    protected IInfoflowConfig sootConfig;
    protected FastHierarchy hierarchy;
    protected IMemoryManagerFactory memoryManagerFactory = new DefaultMemoryManagerFactory();
    protected IExecutorFactory executorFactory = new DefaultExecutorFactory();
    protected IPropagationRuleManagerFactory ruleManagerFactory = this.initializeRuleManagerFactory();
    protected IPropagationRuleManagerFactory reverseRuleManagerFactory = this.initializeReverseRuleManagerFactory();
    protected Set<Stmt> collectedSources;
    protected Set<Stmt> collectedSinks;
    protected SootMethod dummyMainMethod;
    protected Collection<SootMethod> additionalEntryPointMethods;
    protected boolean throwExceptions;
    protected Set<ResultsAvailableHandler> onResultsAvailable = new HashSet<ResultsAvailableHandler>();
    protected TaintPropagationHandler taintPropagationHandler = null;
    protected TaintPropagationHandler aliasPropagationHandler = null;
    protected TaintPropagationHandler reverseTaintPropagationHandler = null;
    protected TaintPropagationHandler reverseAliasPropagationHandler = null;
    protected IUsageContextProvider usageContextProvider = null;
    protected FlowDroidMemoryWatcher memoryWatcher = null;

    public AbstractInfoflow() {
        this(null, null, false);
    }

    public AbstractInfoflow(BiDirICFGFactory icfgFactory, File androidPath, boolean forceAndroidJar) {
        if (icfgFactory == null) {
            DefaultBiDiICFGFactory factory = new DefaultBiDiICFGFactory();
            factory.setIsAndroid(androidPath != null && androidPath.exists());
            this.icfgFactory = factory;
        } else {
            this.icfgFactory = icfgFactory;
        }
        this.androidPath = androidPath;
        this.forceAndroidJar = forceAndroidJar;
    }

    @Override
    public InfoflowConfiguration getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(InfoflowConfiguration config) {
        this.config = config;
    }

    @Override
    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    @Override
    public void setNativeCallHandler(INativeCallHandler handler) {
        this.nativeCallHandler = handler;
    }

    @Override
    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    @Override
    public void addPreprocessor(PreAnalysisHandler preprocessor) {
        this.preProcessors.add(preprocessor);
    }

    @Override
    public void addPostProcessor(PostAnalysisHandler postprocessor) {
        this.postProcessors.add(postprocessor);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, List<String> sources, List<String> sinks) {
        this.computeInfoflow(appPath, libPath, entryPointCreator, (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, Collection<String> entryPoints, Collection<String> sources, Collection<String> sinks) {
        this.computeInfoflow(appPath, libPath, new DefaultEntryPointCreator(entryPoints), (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    @Override
    public void computeInfoflow(String libPath, String appPath, String entryPoint, Collection<String> sources, Collection<String> sinks) {
        this.computeInfoflow(appPath, libPath, entryPoint, (ISourceSinkManager)new DefaultSourceSinkManager(sources, sinks));
    }

    private String appendClasspath(String appPath, String libPath) {
        Object s;
        Object object = s = appPath != null && !appPath.isEmpty() ? appPath : "";
        if (libPath != null && !libPath.isEmpty()) {
            if (!((String)s).isEmpty()) {
                s = (String)s + File.pathSeparator;
            }
            s = (String)s + libPath;
        }
        return s;
    }

    protected void initializeSoot(String appPath, String libPath, Collection<String> classes) {
        this.initializeSoot(appPath, libPath, classes, "");
    }

    protected void initializeSoot(String appPath, String libPath, Collection<String> classes, String extraSeed) {
        if (this.config.getSootIntegrationMode().needsToInitializeSoot()) {
            this.logger.info("Resetting Soot...");
            G.reset();
            Options.v().set_no_bodies_for_excluded(true);
            Options.v().set_allow_phantom_refs(true);
            if (this.config.getWriteOutputFiles()) {
                Options.v().set_output_format(1);
            } else {
                Options.v().set_output_format(12);
            }
            if (this.config.getCallgraphAlgorithm() == InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
                Options.v().set_soot_classpath(libPath);
                if (appPath != null) {
                    LinkedList processDirs = new LinkedList();
                    for (String ap : appPath.split(File.pathSeparator)) {
                        processDirs.add(ap);
                    }
                    Options.v().set_process_dir((List)processDirs);
                }
            } else {
                Options.v().set_soot_classpath(this.appendClasspath(appPath, libPath));
            }
            Options.v().setPhaseOption("jb.ulp", "off");
            this.setSourcePrec();
        }
        if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            switch (this.config.getCallgraphAlgorithm()) {
                case AutomaticSelection: {
                    if (extraSeed == null || extraSeed.isEmpty()) {
                        this.setSparkOptions();
                        break;
                    }
                    this.setChaOptions();
                    break;
                }
                case CHA: {
                    this.setChaOptions();
                    break;
                }
                case RTA: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    Options.v().setPhaseOption("cg.spark", "rta:true");
                    Options.v().setPhaseOption("cg.spark", "on-fly-cg:false");
                    Options.v().setPhaseOption("cg.spark", "string-constants:true");
                    break;
                }
                case VTA: {
                    Options.v().setPhaseOption("cg.spark", "on");
                    Options.v().setPhaseOption("cg.spark", "vta:true");
                    Options.v().setPhaseOption("cg.spark", "string-constants:true");
                    break;
                }
                case SPARK: {
                    this.setSparkOptions();
                    break;
                }
                case GEOM: {
                    this.setSparkOptions();
                    AbstractInfoflow.setGeomPtaSpecificOptions();
                    break;
                }
                case OnDemand: {
                    break;
                }
                default: {
                    throw new RuntimeException("Invalid callgraph algorithm");
                }
            }
            if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
                Options.v().set_whole_program(true);
                Options.v().setPhaseOption("cg", "trim-clinit:false");
                if (this.config.getEnableReflection()) {
                    Options.v().setPhaseOption("cg", "types-for-invoke:true");
                }
            }
        }
        if (this.config.getSootIntegrationMode().needsToInitializeSoot()) {
            if (this.sootConfig != null) {
                this.sootConfig.setSootOptions(Options.v(), this.config);
            }
            for (String className : classes) {
                Scene.v().addBasicClass(className, 3);
            }
            Scene.v().loadNecessaryClasses();
            this.logger.info("Basic class loading done.");
            boolean hasClasses = false;
            for (String className : classes) {
                SootClass c = Scene.v().forceResolve(className, 3);
                if (c == null) continue;
                c.setApplicationClass();
                if (c.isPhantomClass() || c.isPhantom()) continue;
                hasClasses = true;
            }
            if (!hasClasses) {
                this.logger.error("Only phantom classes loaded, skipping analysis...");
                return;
            }
        }
    }

    protected void setSourcePrec() {
        if (this.androidPath != null) {
            Options.v().set_src_prec(6);
            if (this.forceAndroidJar) {
                Options.v().set_force_android_jar(this.androidPath.getAbsolutePath());
            } else {
                Options.v().set_android_jars(this.androidPath.getAbsolutePath());
            }
        } else {
            Options.v().set_src_prec(4);
        }
    }

    private void setChaOptions() {
        Options.v().setPhaseOption("cg.cha", "on");
    }

    private void setSparkOptions() {
        Options.v().setPhaseOption("cg.spark", "on");
        Options.v().setPhaseOption("cg.spark", "string-constants:true");
    }

    public static void setGeomPtaSpecificOptions() {
        Options.v().setPhaseOption("cg.spark", "geom-pta:true");
        Options.v().setPhaseOption("cg.spark", "geom-encoding:Geom");
        Options.v().setPhaseOption("cg.spark", "geom-worklist:PQ");
    }

    @Override
    public void setSootConfig(IInfoflowConfig config) {
        this.sootConfig = config;
    }

    @Override
    public void setIPCManager(IIPCManager ipcManager) {
        this.ipcManager = ipcManager;
    }

    @Override
    public void setPathBuilderFactory(IPathBuilderFactory factory) {
        this.pathBuilderFactory = factory;
    }

    protected void constructCallgraph() {
        if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            if (this.ipcManager != null) {
                this.ipcManager.updateJimpleForICC();
            }
            if (this.config.isPatchInvokeDynamicInstructions()) {
                this.patchDynamicInvokeInstructions();
            }
            for (PreAnalysisHandler preAnalysisHandler : this.preProcessors) {
                preAnalysisHandler.onBeforeCallgraphConstruction();
            }
            LibraryClassPatcher patcher = this.getLibraryClassPatcher();
            patcher.patchLibraries();
            this.hierarchy = Scene.v().getOrMakeFastHierarchy();
            for (SootClass sc : Scene.v().getClasses()) {
                if (sc.resolvingLevel() != 0) continue;
                sc.setResolvingLevel(3);
                sc.setPhantomClass();
            }
            if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand && !Scene.v().hasCallGraph()) {
                PackManager.v().getPack("wjpp").apply();
                PackManager.v().getPack("cg").apply();
            }
        }
        this.hierarchy = Scene.v().getOrMakeFastHierarchy();
        if (this.config.getSootIntegrationMode().needsToBuildCallgraph()) {
            for (PreAnalysisHandler preAnalysisHandler : this.preProcessors) {
                preAnalysisHandler.onAfterCallgraphConstruction();
            }
        }
    }

    private void patchDynamicInvokeInstructions() {
        for (SootClass sc : Scene.v().getClasses()) {
            for (SootMethod sm : sc.getMethods()) {
                if (sm.hasActiveBody()) {
                    Body body = sm.getActiveBody();
                    AbstractInfoflow.patchDynamicInvokeInstructions(body);
                    continue;
                }
                if (sm.getSource() instanceof MethodSourceInjector || sm.getSource() == null) continue;
                sm.setSource((MethodSource)new MethodSourceInjector(sm.getSource()){

                    @Override
                    protected void onMethodSourceLoaded(SootMethod m, Body b) {
                        AbstractInfoflow.patchDynamicInvokeInstructions(b);
                    }
                });
            }
        }
    }

    protected static void patchDynamicInvokeInstructions(Body body) {
        Iterator unitIt = body.getUnits().snapshotIterator();
        while (unitIt.hasNext()) {
            InvokeExpr iexpr;
            Stmt stmt = (Stmt)unitIt.next();
            if (!stmt.containsInvokeExpr() || !((iexpr = stmt.getInvokeExpr()) instanceof DynamicInvokeExpr)) continue;
            DynamicInvokeExpr diexpr = (DynamicInvokeExpr)iexpr;
            SootMethodRef bsmRef = diexpr.getBootstrapMethodRef();
            List<Stmt> newStmts = null;
            switch (bsmRef.getDeclaringClass().getName()) {
                case "java.lang.invoke.StringConcatFactory": {
                    newStmts = AbstractInfoflow.patchStringConcatInstruction(stmt, diexpr, body);
                }
            }
            if (newStmts == null || newStmts.isEmpty()) continue;
            body.getUnits().insertAfter(newStmts, (Unit)stmt);
        }
    }

    private static List<Stmt> patchStringConcatInstruction(Stmt callSite, DynamicInvokeExpr diexpr, Body b) {
        String SIG_CONCAT_CONSTANTS = "java.lang.invoke.CallSite makeConcatWithConstants(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType,java.lang.String,java.lang.Object[])";
        String SIG_CONCAT = "java.lang.invoke.CallSite makeConcatWithConstants(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType)";
        Scene scene = Scene.v();
        Jimple jimple = Jimple.v();
        DefaultLocalGenerator lg = new DefaultLocalGenerator(b);
        RefType rtStringBuilder = RefType.v((String)"java.lang.StringBuilder");
        SootClass scStringBuilder = rtStringBuilder.getSootClass();
        SootMethodRef appendObjectRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(java.lang.Object)", false);
        SootMethodRef toStringRef = scene.makeMethodRef(scene.getObjectType().getSootClass(), "java.lang.String toString()", false);
        SootClass scArrays = Scene.v().getSootClass("java.util.Arrays");
        ArrayList<Stmt> newStmts = new ArrayList<Stmt>();
        NumberedString calleeSubSig = diexpr.getBootstrapMethodRef().getSubSignature();
        if (calleeSubSig.equals((Object)scene.getSubSigNumberer().findOrAdd("java.lang.invoke.CallSite makeConcatWithConstants(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType,java.lang.String,java.lang.Object[])")) || calleeSubSig.equals((Object)scene.getSubSigNumberer().findOrAdd("java.lang.invoke.CallSite makeConcatWithConstants(java.lang.invoke.MethodHandles$Lookup,java.lang.String,java.lang.invoke.MethodType)"))) {
            Local sb = lg.generateLocal((Type)rtStringBuilder);
            AssignStmt stmt = jimple.newAssignStmt((Value)sb, (Value)jimple.newNewExpr(rtStringBuilder));
            stmt.addTag((Tag)SimulatedCodeElementTag.TAG);
            newStmts.add((Stmt)stmt);
            stmt = jimple.newInvokeStmt((Value)jimple.newSpecialInvokeExpr(sb, scene.makeMethodRef(scStringBuilder, "void <init>(java.lang.String)", false)));
            stmt.addTag((Tag)SimulatedCodeElementTag.TAG);
            newStmts.add((Stmt)stmt);
            for (int i = 0; i < diexpr.getArgCount(); ++i) {
                SootMethodRef appendRef;
                Value arg = diexpr.getArg(i);
                Type argType = arg.getType();
                if (argType instanceof RefType) {
                    appendRef = appendObjectRef;
                } else if (argType instanceof ByteType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(byte)", false);
                } else if (argType instanceof BooleanType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(boolean)", false);
                } else if (argType instanceof CharType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(char)", false);
                } else if (argType instanceof ShortType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(short)", false);
                } else if (argType instanceof IntType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(int)", false);
                } else if (argType instanceof LongType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(long)", false);
                } else if (argType instanceof FloatType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(float)", false);
                } else if (argType instanceof DoubleType) {
                    appendRef = scene.makeMethodRef(scStringBuilder, "java.lang.StringBuilder append(double)", false);
                } else if (argType instanceof ArrayType) {
                    ArrayType at = (ArrayType)argType;
                    Type elementType = at.getElementType();
                    Local sarg = lg.generateLocal((Type)RefType.v((String)"java.lang.String"));
                    SootMethodRef elementToStringRef = null;
                    if (elementType instanceof RefType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(java.lang.Object[])", true);
                    } else if (elementType instanceof ByteType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(byte[])", true);
                    } else if (elementType instanceof BooleanType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(boolean[])", true);
                    } else if (elementType instanceof CharType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(char[])", true);
                    } else if (elementType instanceof ShortType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(short[])", true);
                    } else if (elementType instanceof IntType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(int[])", true);
                    } else if (elementType instanceof LongType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(long[])", true);
                    } else if (elementType instanceof FloatType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(float[])", true);
                    } else if (elementType instanceof DoubleType) {
                        elementToStringRef = scene.makeMethodRef(scArrays, "java.lang.String toString(double[])", true);
                    } else {
                        throw new RuntimeException(String.format("Invalid array element type %s for string concatenation in dynamic invocation", elementType.toString()));
                    }
                    AssignStmt toStringStmt = jimple.newAssignStmt((Value)sarg, (Value)jimple.newStaticInvokeExpr(elementToStringRef, Collections.singletonList(arg)));
                    toStringStmt.addTag((Tag)SimulatedCodeElementTag.TAG);
                    newStmts.add((Stmt)toStringStmt);
                    arg = sarg;
                    appendRef = scStringBuilder.getMethod("java.lang.StringBuilder append(java.lang.String)").makeRef();
                } else {
                    throw new RuntimeException(String.format("Invalid type %s for string concatenation in dynamic invocation", argType.toString()));
                }
                stmt = jimple.newInvokeStmt((Value)jimple.newVirtualInvokeExpr(sb, appendRef, Collections.singletonList(arg)));
                stmt.addTag((Tag)SimulatedCodeElementTag.TAG);
                newStmts.add((Stmt)stmt);
            }
            if (callSite instanceof AssignStmt) {
                AssignStmt assignStmt = (AssignStmt)callSite;
                stmt = jimple.newAssignStmt((Value)((Local)assignStmt.getLeftOp()), (Value)jimple.newVirtualInvokeExpr(sb, toStringRef));
                stmt.addTag((Tag)SimulatedCodeElementTag.TAG);
                newStmts.add((Stmt)stmt);
            }
        }
        return newStmts;
    }

    protected LibraryClassPatcher getLibraryClassPatcher() {
        return new LibraryClassPatcher();
    }

    @Override
    public void setMemoryManagerFactory(IMemoryManagerFactory factory) {
        this.memoryManagerFactory = factory;
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, IEntryPointCreator entryPointCreator, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("SourceSinkManager not specified");
            return;
        }
        if (this.config.getSootIntegrationMode() != InfoflowConfiguration.SootIntegrationMode.UseExistingInstance) {
            this.initializeSoot(appPath, libPath, entryPointCreator.getRequiredClasses());
        }
        this.dummyMainMethod = entryPointCreator.createDummyMain();
        this.additionalEntryPointMethods = entryPointCreator.getAdditionalMethods();
        Scene.v().setEntryPoints(Collections.singletonList(this.dummyMainMethod));
        this.runAnalysis(sourcesSinks, null);
    }

    @Override
    public void computeInfoflow(String appPath, String libPath, String entryPoint, ISourceSinkManager sourcesSinks) {
        if (sourcesSinks == null) {
            this.logger.error("No source/sink manager specified");
            return;
        }
        this.initializeSoot(appPath, libPath, SootMethodRepresentationParser.v().parseClassNames(Collections.singletonList(entryPoint), false).keySet(), entryPoint);
        if (!Scene.v().containsMethod(entryPoint)) {
            this.logger.error("Entry point not found: " + entryPoint);
            return;
        }
        SootMethod ep = Scene.v().getMethod(entryPoint);
        if (!ep.isConcrete()) {
            this.logger.debug("Skipping non-concrete method " + ep);
            return;
        }
        ep.retrieveActiveBody();
        this.dummyMainMethod = null;
        Scene.v().setEntryPoints(Collections.singletonList(ep));
        Options.v().set_main_class(ep.getDeclaringClass().getName());
        Set<String> seeds = Collections.emptySet();
        if (entryPoint != null && !entryPoint.isEmpty()) {
            seeds = Collections.singleton(entryPoint);
        }
        this.ipcManager.updateJimpleForICC();
        this.runAnalysis(sourcesSinks, seeds);
    }

    protected void runAnalysis(ISourceSinkManager sourcesSinks) {
        this.runAnalysis(sourcesSinks, null);
    }

    protected void runAnalysis(ISourceSinkManager sourcesSinks, Set<String> additionalSeeds) {
        block12: {
            InfoflowPerformanceData performanceData = this.createPerformanceDataClass();
            try {
                this.results = this.createResultsObject();
                this.results.setPerformanceData(performanceData);
                this.checkAndFixConfiguration();
                this.config.printSummary();
                if (this.memoryWatcher != null) {
                    this.memoryWatcher.clearSolvers();
                    this.memoryWatcher = null;
                }
                this.memoryWatcher = new FlowDroidMemoryWatcher(this.results, this.config.getMemoryThreshold());
                Abstraction.initialize(this.config);
                if (this.taintWrapper != null) {
                    this.preProcessors.addAll(this.taintWrapper.getPreAnalysisHandlers());
                }
                long beforeCallgraph = System.nanoTime();
                this.constructCallgraph();
                performanceData.setCallgraphConstructionSeconds((int)Math.round((double)(System.nanoTime() - beforeCallgraph) / 1.0E9));
                this.logger.info(String.format(Locale.getDefault(), "Callgraph construction took %d seconds", performanceData.getCallgraphConstructionSeconds()));
                if (sourcesSinks != null) {
                    sourcesSinks.initialize();
                }
                if (this.config.getCodeEliminationMode() != InfoflowConfiguration.CodeEliminationMode.NoCodeElimination) {
                    long currentMillis = System.nanoTime();
                    this.eliminateDeadCode(sourcesSinks);
                    this.logger.info("Dead code elimination took " + (double)(System.nanoTime() - currentMillis) / 1.0E9 + " seconds");
                }
                if (this.config.getEnableReflection()) {
                    this.releaseCallgraph();
                    this.constructCallgraph();
                }
                if (this.config.getCallgraphAlgorithm() != InfoflowConfiguration.CallgraphAlgorithm.OnDemand) {
                    this.logger.info("Callgraph has {} edges", (Object)Scene.v().getCallGraph().size());
                }
                IInfoflowCFG iCfg = this.icfgFactory.buildBiDirICFG(this.config.getCallgraphAlgorithm(), this.config.getEnableExceptionTracking());
                if (this.config.isTaintAnalysisEnabled()) {
                    this.runTaintAnalysis(sourcesSinks, additionalSeeds, iCfg, performanceData);
                }
                performanceData.setTotalRuntimeSeconds((int)Math.round((double)(System.nanoTime() - beforeCallgraph) / 1.0E9));
                performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                this.logger.info(String.format("Data flow solver took %d seconds. Maximum memory consumption: %d MB", performanceData.getTotalRuntimeSeconds(), performanceData.getMaxMemoryConsumption()));
                for (ResultsAvailableHandler handler : this.onResultsAvailable) {
                    handler.onResultsAvailable(iCfg, this.results);
                }
                if (this.config.getWriteOutputFiles()) {
                    PackManager.v().writeOutput();
                }
            }
            catch (Exception ex) {
                StringWriter stacktrace = new StringWriter();
                PrintWriter pw = new PrintWriter(stacktrace);
                ex.printStackTrace(pw);
                if (this.results != null) {
                    this.results.addException(ex.getClass().getName() + ": " + ex.getMessage() + "\n" + stacktrace.toString());
                }
                this.logger.error("Exception during data flow analysis", (Throwable)ex);
                if (!this.throwExceptions) break block12;
                throw ex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTaintAnalysis(ISourceSinkManager sourcesSinks, Set<String> additionalSeeds, IInfoflowCFG iCfg, InfoflowPerformanceData performanceData) {
        boolean hasMoreSources;
        IOneSourceAtATimeManager oneSourceAtATime;
        this.logger.info("Starting Taint Analysis");
        if (this.pathBuilderFactory == null) {
            this.pathBuilderFactory = new DefaultPathBuilderFactory(this.config.getPathConfiguration());
        }
        IOneSourceAtATimeManager iOneSourceAtATimeManager = oneSourceAtATime = this.config.getOneSourceAtATime() && sourcesSinks != null && sourcesSinks instanceof IOneSourceAtATimeManager ? (IOneSourceAtATimeManager)((Object)sourcesSinks) : null;
        if (oneSourceAtATime != null) {
            oneSourceAtATime.resetCurrentSource();
        }
        boolean bl = hasMoreSources = oneSourceAtATime == null || oneSourceAtATime.hasNextSource();
        while (hasMoreSources) {
            IInfoflowSolver solver;
            long beforePathReconstruction;
            FlowDroidTimeoutWatcher pathTimeoutWatcher;
            FlowDroidTimeoutWatcher timeoutWatcher;
            IInfoflowSolver forwardSolver;
            AbstractInfoflowProblem forwardProblem;
            IAliasingStrategy aliasingStrategy;
            block106: {
                int sinkCount;
                InterruptableExecutor resultExecutor;
                BackwardNativeCallHandler additionalNativeCallHandler;
                IInfoflowSolver additionalAliasSolver;
                IInfoflowSolver additionalSolver;
                Aliasing aliasing;
                IInfoflowSolver backwardSolver;
                InterruptableExecutor executor;
                int numThreads;
                block104: {
                    IInfoflowSolver solver2;
                    block105: {
                        block102: {
                            block103: {
                                if (oneSourceAtATime != null) {
                                    oneSourceAtATime.nextSource();
                                }
                                numThreads = Runtime.getRuntime().availableProcessors();
                                executor = this.executorFactory.createExecutor(numThreads, true, this.config);
                                executor.setThreadFactory(new ThreadFactory(){

                                    @Override
                                    public Thread newThread(Runnable r) {
                                        Thread thrIFDS = new Thread(r);
                                        thrIFDS.setDaemon(true);
                                        thrIFDS.setName("FlowDroid");
                                        return thrIFDS;
                                    }
                                });
                                IMemoryManager<Abstraction, Unit> memoryManager = this.createMemoryManager();
                                HashSet<IInfoflowSolver> solvers = new HashSet<IInfoflowSolver>();
                                GlobalTaintManager globalTaintManager = new GlobalTaintManager(solvers);
                                this.manager = this.initializeInfoflowManager(sourcesSinks, iCfg, globalTaintManager);
                                switch (this.manager.getConfig().getSolverConfiguration().getDataFlowSolver()) {
                                    case FineGrainedGC: {
                                        this.solverPeerGroup = new GCSolverPeerGroup();
                                        break;
                                    }
                                    case GarbageCollecting: {
                                        this.solverPeerGroup = new GCSolverPeerGroup();
                                        break;
                                    }
                                    default: {
                                        this.solverPeerGroup = new DefaultSolverPeerGroup();
                                    }
                                }
                                Abstraction zeroValue = Abstraction.getZeroAbstraction(this.manager.getConfig().getFlowSensitiveAliasing());
                                aliasingStrategy = this.createAliasAnalysis(sourcesSinks, iCfg, executor, memoryManager);
                                backwardSolver = aliasingStrategy.getSolver();
                                if (backwardSolver != null) {
                                    zeroValue = backwardSolver.getTabulationProblem().createZeroValue();
                                    solvers.add(backwardSolver);
                                }
                                aliasing = this.createAliasController(aliasingStrategy);
                                if (this.dummyMainMethod != null) {
                                    aliasing.excludeMethodFromMustAlias(this.dummyMainMethod);
                                }
                                this.manager.setAliasing(aliasing);
                                forwardProblem = this.createInfoflowProblem(zeroValue);
                                forwardSolver = this.createDataFlowSolver(executor, forwardProblem);
                                this.manager.setMainSolver(forwardSolver);
                                if (aliasingStrategy.getSolver() != null) {
                                    aliasingStrategy.getSolver().getTabulationProblem().getManager().setMainSolver(forwardSolver);
                                }
                                solvers.add(forwardSolver);
                                this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                                forwardSolver.setMemoryManager(memoryManager);
                                forwardProblem.setTaintPropagationHandler(this.taintPropagationHandler);
                                forwardProblem.setTaintWrapper(this.taintWrapper);
                                if (this.nativeCallHandler != null) {
                                    forwardProblem.setNativeCallHandler(this.nativeCallHandler);
                                }
                                if (aliasingStrategy.getSolver() != null) {
                                    aliasingStrategy.getSolver().getTabulationProblem().setActivationUnitsToCallSites(forwardProblem);
                                    this.manager.setAliasSolver(aliasingStrategy.getSolver());
                                }
                                additionalSolver = null;
                                additionalAliasSolver = null;
                                additionalNativeCallHandler = null;
                                if (this.config.getAdditionalFlowsEnabled()) {
                                    TaintPropagationHandler forwardHandler = forwardProblem.getTaintPropagationHandler();
                                    if (forwardHandler != null) {
                                        if (forwardHandler instanceof SequentialTaintPropagationHandler) {
                                            ((SequentialTaintPropagationHandler)forwardHandler).addHandler(new SecondaryFlowGenerator());
                                        } else {
                                            SequentialTaintPropagationHandler seqTpg = new SequentialTaintPropagationHandler();
                                            seqTpg.addHandler(forwardHandler);
                                            seqTpg.addHandler(new SecondaryFlowGenerator());
                                            forwardProblem.setTaintPropagationHandler(seqTpg);
                                        }
                                    } else {
                                        forwardProblem.setTaintPropagationHandler(new SecondaryFlowGenerator());
                                    }
                                    if (!(this.manager.getSourceSinkManager() instanceof IConditionalFlowManager)) {
                                        throw new IllegalStateException("Additional Flows enabled but no ConditionalFlowManager in place!");
                                    }
                                    InfoflowManager additionalManager = new InfoflowManager(this.config, null, (IInfoflowCFG)new BackwardsInfoflowCFG(iCfg), (ISourceSinkManager)new ConditionalFlowSourceSinkManagerWrapper((IConditionalFlowManager)((Object)this.manager.getSourceSinkManager())), this.taintWrapper, this.hierarchy, globalTaintManager);
                                    BackwardsInfoflowProblem additionalProblem = new BackwardsInfoflowProblem(additionalManager, zeroValue, this.reverseRuleManagerFactory);
                                    additionalSolver = this.createDataFlowSolver(executor, additionalProblem);
                                    additionalManager.setMainSolver(additionalSolver);
                                    additionalSolver.setMemoryManager(memoryManager);
                                    this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)additionalSolver));
                                    additionalProblem.setTaintPropagationHandler(new SecondaryFlowListener());
                                    additionalProblem.setTaintWrapper(this.taintWrapper);
                                    additionalNativeCallHandler = new BackwardNativeCallHandler();
                                    additionalProblem.setNativeCallHandler(additionalNativeCallHandler);
                                    IAliasingStrategy revereAliasingStrategy = this.createBackwardAliasAnalysis(additionalManager, sourcesSinks, iCfg, executor, memoryManager);
                                    if (revereAliasingStrategy.getSolver() != null) {
                                        revereAliasingStrategy.getSolver().getTabulationProblem().getManager().setMainSolver(additionalSolver);
                                    }
                                    additionalAliasSolver = revereAliasingStrategy.getSolver();
                                    Aliasing reverseAliasing = this.createAliasController(revereAliasingStrategy);
                                    if (this.dummyMainMethod != null) {
                                        reverseAliasing.excludeMethodFromMustAlias(this.dummyMainMethod);
                                    }
                                    additionalManager.setAliasing(reverseAliasing);
                                    additionalManager.setAliasSolver(additionalAliasSolver);
                                    this.manager.additionalManager = additionalManager;
                                    if (this.config.getFilterConditionalSinks()) {
                                        this.addPostProcessor(new ConditionalFlowPostProcessor(this.manager));
                                    }
                                    if (this.usageContextProvider == null) {
                                        this.usageContextProvider = new EmptyUsageContextProvider();
                                    }
                                    this.manager.setUsageContextProvider(this.usageContextProvider);
                                    additionalManager.setUsageContextProvider(this.usageContextProvider);
                                }
                                timeoutWatcher = null;
                                pathTimeoutWatcher = null;
                                if (this.config.getDataFlowTimeout() > 0L) {
                                    timeoutWatcher = new FlowDroidTimeoutWatcher(this.config.getDataFlowTimeout(), this.results);
                                    timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                                    if (aliasingStrategy.getSolver() != null) {
                                        timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)aliasingStrategy.getSolver()));
                                    }
                                    if (additionalSolver != null) {
                                        timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)additionalSolver));
                                    }
                                    if (additionalAliasSolver != null) {
                                        timeoutWatcher.addSolver((IMemoryBoundedSolver)((Object)additionalAliasSolver));
                                    }
                                    timeoutWatcher.start();
                                }
                                resultExecutor = null;
                                beforePathReconstruction = 0L;
                                if (this.config.getFlowSensitiveAliasing() && !aliasingStrategy.isFlowSensitive()) {
                                    this.logger.warn("Trying to use a flow-sensitive aliasing with an aliasing strategy that does not support this feature");
                                }
                                if (this.config.getFlowSensitiveAliasing() && this.config.getSolverConfiguration().getMaxJoinPointAbstractions() > 0) {
                                    this.logger.warn("Running with limited join point abstractions can break context-sensitive path builders");
                                }
                                sinkCount = 0;
                                this.logger.info("Looking for sources and sinks...");
                                for (SootMethod sm : this.getMethodsForSeeds(iCfg)) {
                                    sinkCount += this.scanMethodForSourcesSinks(sourcesSinks, forwardProblem, sm);
                                }
                                if (additionalSeeds != null) {
                                    for (String meth : additionalSeeds) {
                                        SootMethod m = Scene.v().getMethod(meth);
                                        if (!m.hasActiveBody()) {
                                            this.logger.warn("Seed method {} has no active body", (Object)m);
                                            continue;
                                        }
                                        forwardProblem.addInitialSeeds(m.getActiveBody().getUnits().getFirst(), Collections.singleton((Abstraction)forwardProblem.zeroValue()));
                                    }
                                }
                                if (forwardProblem.hasInitialSeeds()) break block102;
                                this.logger.error("No sources found, aborting analysis");
                                if (resultExecutor == null) break block103;
                                resultExecutor.shutdown();
                            }
                            if (timeoutWatcher != null) {
                                timeoutWatcher.stop();
                            }
                            if (pathTimeoutWatcher != null) {
                                pathTimeoutWatcher.stop();
                            }
                            if (aliasingStrategy != null && (solver2 = aliasingStrategy.getSolver()) != null) {
                                solver2.terminate();
                            }
                            hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                            this.memoryWatcher.close();
                            forwardProblem = null;
                            forwardSolver = null;
                            if (this.manager != null) {
                                this.manager.cleanup();
                            }
                            this.manager = null;
                            continue;
                        }
                        if (sinkCount != 0) break block104;
                        this.logger.error("No sinks found, aborting analysis");
                        if (resultExecutor == null) break block105;
                        resultExecutor.shutdown();
                    }
                    if (timeoutWatcher != null) {
                        timeoutWatcher.stop();
                    }
                    if (pathTimeoutWatcher != null) {
                        pathTimeoutWatcher.stop();
                    }
                    if (aliasingStrategy != null && (solver2 = aliasingStrategy.getSolver()) != null) {
                        solver2.terminate();
                    }
                    hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                    this.memoryWatcher.close();
                    forwardProblem = null;
                    forwardSolver = null;
                    if (this.manager != null) {
                        this.manager.cleanup();
                    }
                    this.manager = null;
                    continue;
                }
                try {
                    this.logger.info("Source lookup done, found {} sources and {} sinks.", (Object)forwardProblem.getInitialSeeds().size(), (Object)sinkCount);
                    performanceData.setSourceCount(forwardProblem.getInitialSeeds().size());
                    performanceData.setSinkCount(sinkCount);
                    if (this.taintWrapper != null) {
                        this.taintWrapper.initialize(this.manager);
                    }
                    if (this.nativeCallHandler != null) {
                        this.nativeCallHandler.initialize(this.manager);
                    }
                    if (additionalNativeCallHandler != null) {
                        additionalNativeCallHandler.initialize(this.manager);
                    }
                    TaintPropagationResults propagationResults = forwardProblem.getResults();
                    resultExecutor = this.executorFactory.createExecutor(numThreads, false, this.config);
                    resultExecutor.setThreadFactory(new ThreadFactory(){

                        @Override
                        public Thread newThread(Runnable r) {
                            return AbstractInfoflow.this.createNewThread(r);
                        }
                    });
                    IAbstractionPathBuilder builder = this.createPathBuilder(resultExecutor);
                    if (this.config.getIncrementalResultReporting()) {
                        this.initializeIncrementalResultReporting(propagationResults, builder);
                    }
                    if (performanceData.getTaintPropagationSeconds() < 0) {
                        performanceData.setTaintPropagationSeconds(0);
                    }
                    long beforeTaintPropagation = System.nanoTime();
                    this.onBeforeTaintPropagation(forwardSolver, backwardSolver);
                    forwardSolver.solve();
                    int terminateTries = 0;
                    while (!(terminateTries >= 10 || executor.getActiveCount() == 0 && executor.isTerminated())) {
                        ++terminateTries;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            this.logger.error("Could not wait for executor termination", (Throwable)e);
                        }
                    }
                    if (executor.getActiveCount() != 0 || !executor.isTerminated()) {
                        this.logger.error("Executor did not terminate gracefully");
                    }
                    if (executor.getException() != null) {
                        throw new RuntimeException("An exception has occurred in an executor", executor.getException());
                    }
                    performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                    int taintPropagationSeconds = (int)Math.round((double)(System.nanoTime() - beforeTaintPropagation) / 1.0E9);
                    performanceData.addTaintPropagationSeconds(taintPropagationSeconds);
                    performanceData.addEdgePropagationCount(forwardSolver.getPropagationCount());
                    performanceData.setInfoflowPropagationCount(forwardSolver.getPropagationCount());
                    if (backwardSolver != null) {
                        performanceData.setAliasPropagationCount(backwardSolver.getPropagationCount());
                        performanceData.addEdgePropagationCount(backwardSolver.getPropagationCount());
                    }
                    if (this.taintWrapper != null) {
                        this.logger.info("Taint wrapper hits: " + this.taintWrapper.getWrapperHits());
                        this.logger.info("Taint wrapper misses: " + this.taintWrapper.getWrapperMisses());
                    }
                    this.onTaintPropagationCompleted(forwardSolver, backwardSolver, additionalSolver, additionalAliasSolver);
                    Set<AbstractionAtSink> res = propagationResults.getResults();
                    propagationResults = null;
                    if (this.config.getDataFlowDirection() != InfoflowConfiguration.DataFlowDirection.Backwards) {
                        this.removeEntailedAbstractions(res);
                    }
                    if (this.config.getAdditionalFlowsEnabled()) {
                        res = new HashSet<AbstractionAtSink>(res);
                        Set<AbstractionAtSink> additionalRes = this.manager.additionalManager.getMainSolver().getTabulationProblem().getResults().getResults();
                        res.addAll(additionalRes);
                    }
                    if (this.nativeCallHandler != null) {
                        this.nativeCallHandler.shutdown();
                    }
                    if (additionalNativeCallHandler != null) {
                        additionalNativeCallHandler.shutdown();
                    }
                    if (this.config.getAdditionalFlowsEnabled()) {
                        this.logger.info("IFDS problem with {} forward, {} backward, {} additional backward and {} additional forward edges, solved in {} seconds, processing {} results...", new Object[]{forwardSolver.getPropagationCount(), aliasingStrategy.getSolver() == null ? 0L : aliasingStrategy.getSolver().getPropagationCount(), additionalSolver == null ? 0L : additionalSolver.getPropagationCount(), additionalAliasSolver == null ? 0L : additionalAliasSolver.getPropagationCount(), taintPropagationSeconds, res == null ? 0 : res.size()});
                    } else {
                        this.logger.info("IFDS problem with {} forward and {} backward edges solved in {} seconds, processing {} results...", new Object[]{forwardSolver.getPropagationCount(), aliasingStrategy.getSolver() == null ? 0L : aliasingStrategy.getSolver().getPropagationCount(), taintPropagationSeconds, res == null ? 0 : res.size()});
                    }
                    ISolverTerminationReason reason = ((IMemoryBoundedSolver)((Object)forwardSolver)).getTerminationReason();
                    if (reason != null) {
                        if (reason instanceof OutOfMemoryReason) {
                            this.results.setTerminationState(this.results.getTerminationState() | 2);
                        } else if (reason instanceof TimeoutReason) {
                            this.results.setTerminationState(this.results.getTerminationState() | 1);
                        }
                    }
                    performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                    this.logger.info(String.format("Current memory consumption: %d MB", this.getUsedMemory()));
                    if (timeoutWatcher != null) {
                        timeoutWatcher.stop();
                    }
                    this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)forwardSolver));
                    forwardSolver.cleanup();
                    forwardSolver = null;
                    forwardProblem = null;
                    this.solverPeerGroup = null;
                    aliasing = null;
                    if (aliasingStrategy.getSolver() != null) {
                        aliasingStrategy.getSolver().terminate();
                        this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)aliasingStrategy.getSolver()));
                    }
                    aliasingStrategy.cleanup();
                    aliasingStrategy = null;
                    if (this.config.getIncrementalResultReporting()) {
                        res = null;
                    }
                    iCfg.purge();
                    if (this.manager.additionalManager != null) {
                        additionalSolver.cleanup();
                        this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)additionalSolver));
                        additionalSolver = null;
                        this.manager.additionalManager.setAliasing(null);
                        additionalAliasSolver.cleanup();
                        this.memoryWatcher.removeSolver((IMemoryBoundedSolver)((Object)additionalAliasSolver));
                        additionalAliasSolver = null;
                        this.manager.additionalManager.cleanup();
                        this.manager.additionalManager = null;
                    }
                    if (this.manager != null) {
                        this.manager.cleanup();
                    }
                    this.manager = null;
                    Runtime.getRuntime().gc();
                    performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
                    this.logger.info(String.format("Memory consumption after cleanup: %d MB", this.getUsedMemory()));
                    if (this.config.getPathConfiguration().getPathReconstructionTimeout() > 0L) {
                        pathTimeoutWatcher = new FlowDroidTimeoutWatcher(this.config.getPathConfiguration().getPathReconstructionTimeout(), this.results);
                        pathTimeoutWatcher.addSolver(builder);
                        pathTimeoutWatcher.start();
                    }
                    beforePathReconstruction = System.nanoTime();
                    if (this.config.getIncrementalResultReporting()) {
                        builder.runIncrementalPathComputation();
                        try {
                            resultExecutor.awaitCompletion();
                        }
                        catch (InterruptedException e) {
                            this.logger.error("Could not wait for executor termination", (Throwable)e);
                        }
                    } else {
                        this.memoryWatcher.addSolver(builder);
                        builder.computeTaintPaths(res);
                        res = null;
                        try {
                            long pathTimeout = this.config.getPathConfiguration().getPathReconstructionTimeout();
                            if (pathTimeout > 0L) {
                                resultExecutor.awaitCompletion(pathTimeout + 20L, TimeUnit.SECONDS);
                            } else {
                                resultExecutor.awaitCompletion();
                            }
                        }
                        catch (InterruptedException e) {
                            this.logger.error("Could not wait for executor termination", (Throwable)e);
                        }
                        reason = builder.getTerminationReason();
                        if (reason != null) {
                            if (reason instanceof OutOfMemoryReason) {
                                this.results.setTerminationState(this.results.getTerminationState() | 8);
                            } else if (reason instanceof TimeoutReason) {
                                this.results.setTerminationState(this.results.getTerminationState() | 4);
                            }
                        }
                        this.results.addAll(builder.getResults());
                    }
                    resultExecutor.shutdown();
                    if (builder.isKilled()) {
                        this.logger.warn("Path reconstruction aborted. The reported results may be incomplete. You might want to try again with sequential path processing enabled.");
                    }
                    if (resultExecutor == null) break block106;
                }
                catch (Throwable throwable) {
                    IInfoflowSolver solver3;
                    if (resultExecutor != null) {
                        resultExecutor.shutdown();
                    }
                    if (timeoutWatcher != null) {
                        timeoutWatcher.stop();
                    }
                    if (pathTimeoutWatcher != null) {
                        pathTimeoutWatcher.stop();
                    }
                    if (aliasingStrategy != null && (solver3 = aliasingStrategy.getSolver()) != null) {
                        solver3.terminate();
                    }
                    hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
                    this.memoryWatcher.close();
                    forwardProblem = null;
                    forwardSolver = null;
                    if (this.manager != null) {
                        this.manager.cleanup();
                    }
                    this.manager = null;
                    throw throwable;
                }
                resultExecutor.shutdown();
            }
            if (timeoutWatcher != null) {
                timeoutWatcher.stop();
            }
            if (pathTimeoutWatcher != null) {
                pathTimeoutWatcher.stop();
            }
            if (aliasingStrategy != null && (solver = aliasingStrategy.getSolver()) != null) {
                solver.terminate();
            }
            hasMoreSources = oneSourceAtATime != null && oneSourceAtATime.hasNextSource();
            this.memoryWatcher.close();
            forwardProblem = null;
            forwardSolver = null;
            if (this.manager != null) {
                this.manager.cleanup();
            }
            this.manager = null;
            Runtime.getRuntime().gc();
            performanceData.updateMaxMemoryConsumption(this.getUsedMemory());
            performanceData.setPathReconstructionSeconds((int)Math.round((double)(System.nanoTime() - beforePathReconstruction) / 1.0E9));
            this.logger.info(String.format("Memory consumption after path building: %d MB", this.getUsedMemory()));
            this.logger.info(String.format("Path reconstruction took %d seconds", performanceData.getPathReconstructionSeconds()));
        }
        for (PostAnalysisHandler handler : this.postProcessors) {
            this.results = handler.onResultsAvailable(this.results, iCfg);
        }
        if (this.results == null || this.results.isEmpty()) {
            this.logger.warn("No results found.");
        } else if (this.logger.isInfoEnabled()) {
            for (ResultSinkInfo sink : this.results.getResults().keySet()) {
                this.logger.info("The sink {} in method {} was called with values from the following sources:", (Object)sink, (Object)((SootMethod)iCfg.getMethodOf(sink.getStmt())).getSignature());
                for (ResultSourceInfo source : this.results.getResults().get((Object)sink)) {
                    this.logger.info("- {} in method {}", (Object)source, (Object)((SootMethod)iCfg.getMethodOf(source.getStmt())).getSignature());
                    if (source.getPath() == null) continue;
                    this.logger.info("\ton Path: ");
                    for (Stmt p : source.getPath()) {
                        if (p == null) continue;
                        this.logger.info("\t -> " + iCfg.getMethodOf(p));
                        int ln = p.getJavaSourceStartLineNumber();
                        this.logger.info("\t\t -> " + (Unit)p + (String)(ln != -1 ? " in line " + ln : ""));
                    }
                }
            }
        }
    }

    protected Thread createNewThread(Runnable r) {
        Thread thrPath = new Thread(r);
        thrPath.setDaemon(true);
        thrPath.setName("FlowDroid Path Reconstruction");
        return thrPath;
    }

    protected abstract AbstractInfoflowProblem createInfoflowProblem(Abstraction var1);

    protected AbstractInfoflowProblem createReverseInfoflowProblem(InfoflowManager manager, Abstraction zeroValue) {
        return null;
    }

    protected IInfoflowSolver createDataFlowSolver(InterruptableExecutor executor, AbstractInfoflowProblem problem, InfoflowConfiguration.SolverConfiguration solverConfig) {
        switch (solverConfig.getDataFlowSolver()) {
            case ContextFlowSensitive: {
                this.logger.info("Using context- and flow-sensitive solver");
                InfoflowSolver infoflowSolver = new InfoflowSolver(problem, executor);
                this.solverPeerGroup.addSolver(infoflowSolver);
                return infoflowSolver;
            }
            case SparseContextFlowSensitive: {
                InfoflowConfiguration.SparsePropagationStrategy opt = this.config.getSolverConfiguration().getSparsePropagationStrategy();
                this.logger.info("Using sparse context-sensitive and flow-sensitive solver with sparsification " + opt.toString());
                SparseInfoflowSolver sparseSolver = new SparseInfoflowSolver(problem, executor, opt);
                this.solverPeerGroup.addSolver(sparseSolver);
                return sparseSolver;
            }
            case FlowInsensitive: {
                this.logger.info("Using context-sensitive, but flow-insensitive solver");
                return new soot.jimple.infoflow.solver.fastSolver.flowInsensitive.InfoflowSolver(problem, executor);
            }
            case GarbageCollecting: {
                this.logger.info("Using garbage-collecting solver");
                soot.jimple.infoflow.solver.gcSolver.InfoflowSolver solver = new soot.jimple.infoflow.solver.gcSolver.InfoflowSolver(problem, executor, solverConfig.getSleepTime());
                this.solverPeerGroup.addSolver(solver);
                return solver;
            }
            case FineGrainedGC: {
                this.logger.info("Using fine-grained garbage-collecting solver");
                soot.jimple.infoflow.solver.gcSolver.fpc.InfoflowSolver fgSolver = new soot.jimple.infoflow.solver.gcSolver.fpc.InfoflowSolver(problem, executor, solverConfig.getSleepTime());
                this.solverPeerGroup.addSolver(fgSolver);
                return fgSolver;
            }
        }
        throw new RuntimeException("Unsupported data flow solver");
    }

    private boolean isCallbackOrReturn(Collection<ISourceSinkDefinition> definitions) {
        for (ISourceSinkDefinition definition : definitions) {
            MethodSourceSinkDefinition methodDef;
            MethodSourceSinkDefinition.CallType callType;
            if (!(definition instanceof MethodSourceSinkDefinition) || (callType = (methodDef = (MethodSourceSinkDefinition)definition).getCallType()) != MethodSourceSinkDefinition.CallType.Callback && callType != MethodSourceSinkDefinition.CallType.Return) continue;
            return true;
        }
        return false;
    }

    private int scanMethodForSourcesSinks(ISourceSinkManager sourcesSinks, AbstractInfoflowProblem forwardProblem, SootMethod m) {
        if (this.getConfig().getLogSourcesAndSinks() && this.collectedSources == null) {
            this.collectedSources = new HashSet<Stmt>();
            this.collectedSinks = new HashSet<Stmt>();
        }
        int sinkCount = 0;
        if (m.hasActiveBody()) {
            if (!this.isValidSeedMethod(m)) {
                return sinkCount;
            }
            UnitPatchingChain units = m.getActiveBody().getUnits();
            for (Unit u : units) {
                Stmt s = (Stmt)u;
                SourceOrSink sos = this.scanStmtForSourcesSinks(sourcesSinks, s);
                switch (sos.getState()) {
                    case SOURCE: {
                        if (s.containsInvokeExpr() && !this.isCallbackOrReturn(sos.getSourceInfo().getAllDefinitions())) {
                            s.addTag((Tag)FlowDroidSourceStatement.INSTANCE);
                        }
                        forwardProblem.addInitialSeeds((Unit)s, Collections.singleton((Abstraction)forwardProblem.zeroValue()));
                        if (!this.getConfig().getLogSourcesAndSinks()) break;
                        this.collectedSources.add(s);
                        break;
                    }
                    case SINK: {
                        if (s.containsInvokeExpr()) {
                            s.addTag((Tag)FlowDroidSinkStatement.INSTANCE);
                        }
                        if (this.getConfig().getLogSourcesAndSinks()) {
                            this.collectedSinks.add(s);
                        }
                        ++sinkCount;
                        break;
                    }
                    case BOTH: {
                        if (s.containsInvokeExpr()) {
                            if (!this.isCallbackOrReturn(sos.getSourceInfo().getAllDefinitions())) {
                                s.addTag((Tag)FlowDroidSourceStatement.INSTANCE);
                            }
                            s.addTag((Tag)FlowDroidSinkStatement.INSTANCE);
                        }
                        forwardProblem.addInitialSeeds((Unit)s, Collections.singleton((Abstraction)forwardProblem.zeroValue()));
                        if (this.getConfig().getLogSourcesAndSinks()) {
                            this.collectedSources.add(s);
                            this.collectedSinks.add(s);
                        }
                        ++sinkCount;
                        break;
                    }
                }
            }
        }
        return sinkCount;
    }

    protected abstract SourceOrSink scanStmtForSourcesSinks(ISourceSinkManager var1, Stmt var2);

    protected Collection<SootMethod> getMethodsForSeeds(IInfoflowCFG icfg) {
        LinkedList<SootMethod> seeds = new LinkedList<SootMethod>();
        if (Scene.v().hasCallGraph()) {
            ReachableMethods reachableMethods = Scene.v().getReachableMethods();
            reachableMethods.update();
            QueueReader iter = reachableMethods.listener();
            while (iter.hasNext()) {
                SootMethod sm = ((MethodOrMethodContext)iter.next()).method();
                if (!this.isValidSeedMethod(sm)) continue;
                seeds.add(sm);
            }
        } else {
            long beforeSeedMethods = System.nanoTime();
            HashSet<SootMethod> doneSet = new HashSet<SootMethod>();
            for (SootMethod sm : Scene.v().getEntryPoints()) {
                this.getMethodsForSeedsIncremental(sm, doneSet, seeds, icfg);
            }
            this.logger.info("Collecting seed methods took {} seconds", (Object)((double)(System.nanoTime() - beforeSeedMethods) / 1.0E9));
        }
        return seeds;
    }

    private void getMethodsForSeedsIncremental(SootMethod sm, Set<SootMethod> doneSet, List<SootMethod> seeds, IInfoflowCFG icfg) {
        assert (Scene.v().hasFastHierarchy());
        if (!(sm.isConcrete() && sm.getDeclaringClass().isApplicationClass() && doneSet.add(sm))) {
            return;
        }
        seeds.add(sm);
        for (Unit u : sm.retrieveActiveBody().getUnits()) {
            Stmt stmt = (Stmt)u;
            if (!stmt.containsInvokeExpr()) continue;
            for (SootMethod callee : icfg.getCalleesOfCallAt(stmt)) {
                if (!this.isValidSeedMethod(callee)) continue;
                this.getMethodsForSeedsIncremental(callee, doneSet, seeds, icfg);
            }
        }
    }

    protected boolean isValidSeedMethod(SootMethod sm) {
        if (sm == this.dummyMainMethod) {
            return false;
        }
        if (this.dummyMainMethod != null && sm.getDeclaringClass() == this.dummyMainMethod.getDeclaringClass()) {
            return false;
        }
        String className = sm.getDeclaringClass().getName();
        if (this.config.getIgnoreFlowsInSystemPackages() && SystemClassHandler.v().isClassInSystemPackage(className)) {
            if (this.isUserCodeClass(className)) {
                if (!sm.getDeclaringClass().hasTag("fd_userclass")) {
                    sm.getDeclaringClass().addTag((Tag)FlowDroidUserClass.v());
                }
                return true;
            }
            return false;
        }
        return !this.config.getExcludeSootLibraryClasses() || !sm.getDeclaringClass().isLibraryClass();
    }

    protected boolean isUserCodeClass(String className) {
        return false;
    }

    protected void eliminateDeadCode(ISourceSinkManager sourcesSinks) {
        PointsToAnalysis newPta;
        InfoflowManager dceManager = new InfoflowManager(this.config, null, this.icfgFactory.buildBiDirICFG(this.config.getCallgraphAlgorithm(), this.config.getEnableExceptionTracking()));
        Scene scene = Scene.v();
        PointsToAnalysis pta = scene.getPointsToAnalysis();
        HashSet<SootMethod> excludedMethods = new HashSet<SootMethod>();
        if (this.additionalEntryPointMethods != null) {
            excludedMethods.addAll(this.additionalEntryPointMethods);
        }
        excludedMethods.addAll(Scene.v().getEntryPoints());
        this.performCodeInstrumentationBeforeDCE(dceManager, excludedMethods);
        DeadCodeEliminator dce = new DeadCodeEliminator();
        dce.initialize(this.config);
        dce.run(dceManager, excludedMethods, sourcesSinks, this.taintWrapper);
        if (pta != null && !(pta instanceof DumbPointerAnalysis) && ((newPta = scene.getPointsToAnalysis()) == null || newPta instanceof DumbPointerAnalysis)) {
            scene.setPointsToAnalysis(pta);
        }
        this.performCodeInstrumentationAfterDCE(dceManager, excludedMethods);
    }

    protected void performCodeInstrumentationBeforeDCE(InfoflowManager dceManager, Set<SootMethod> excludedMethods) {
    }

    protected void performCodeInstrumentationAfterDCE(InfoflowManager dceManager, Set<SootMethod> excludedMethods) {
    }

    protected IInfoflowSolver createDataFlowSolver(InterruptableExecutor executor, AbstractInfoflowProblem problem) {
        InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
        IInfoflowSolver solver = this.createDataFlowSolver(executor, problem, solverConfig);
        solver.setSolverId(true);
        solver.setPredecessorShorteningMode(this.pathConfigToShorteningMode(this.manager.getConfig().getPathConfiguration()));
        solver.setMaxJoinPointAbstractions(solverConfig.getMaxJoinPointAbstractions());
        solver.setMaxCalleesPerCallSite(solverConfig.getMaxCalleesPerCallSite());
        solver.setMaxAbstractionPathLength(solverConfig.getMaxAbstractionPathLength());
        return solver;
    }

    protected PredecessorShorteningMode pathConfigToShorteningMode(InfoflowConfiguration.PathConfiguration pathConfiguration) {
        if (this.pathBuilderFactory.supportsPathReconstruction()) {
            switch (pathConfiguration.getPathReconstructionMode()) {
                case Fast: {
                    return PredecessorShorteningMode.ShortenIfEqual;
                }
                case NoPaths: {
                    return PredecessorShorteningMode.AlwaysShorten;
                }
                case Precise: {
                    return PredecessorShorteningMode.NeverShorten;
                }
            }
            throw new RuntimeException("Unknown path reconstruction mode");
        }
        return PredecessorShorteningMode.AlwaysShorten;
    }

    protected IMemoryManager<Abstraction, Unit> createMemoryManager() {
        if (this.memoryManagerFactory == null) {
            return null;
        }
        FlowDroidMemoryManager.PathDataErasureMode erasureMode = this.config.getPathConfiguration().mustKeepStatements() ? FlowDroidMemoryManager.PathDataErasureMode.EraseNothing : (this.pathBuilderFactory.supportsPathReconstruction() ? FlowDroidMemoryManager.PathDataErasureMode.EraseNothing : (this.pathBuilderFactory.isContextSensitive() ? FlowDroidMemoryManager.PathDataErasureMode.KeepOnlyContextData : FlowDroidMemoryManager.PathDataErasureMode.EraseAll));
        IMemoryManager<Abstraction, Unit> memoryManager = this.memoryManagerFactory.getMemoryManager(false, erasureMode);
        return memoryManager;
    }

    protected void releaseCallgraph() {
        Scene.v().releaseCallGraph();
        Scene.v().releasePointsToAnalysis();
        Scene.v().releaseReachableMethods();
        G.v().resetSpark();
    }

    private void checkAndFixConfiguration() {
        InfoflowConfiguration.AccessPathConfiguration accessPathConfig = this.config.getAccessPathConfiguration();
        if (this.config.getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && accessPathConfig.getAccessPathLength() == 0) {
            throw new RuntimeException("Static field tracking must be disabled if the access path length is zero");
        }
        if (this.config.getSolverConfiguration().getDataFlowSolver() == InfoflowConfiguration.DataFlowSolver.FlowInsensitive) {
            this.config.setFlowSensitiveAliasing(false);
            this.config.setEnableTypeChecking(false);
            this.logger.warn("Disabled flow-sensitive aliasing because we are running with a flow-insensitive data flow solver");
        }
        if (this.config.getAdditionalFlowsEnabled() && this.config.getDataFlowDirection() == InfoflowConfiguration.DataFlowDirection.Backwards) {
            throw new RuntimeException("Invalid configuration: the backward direction does not support additional flows");
        }
    }

    protected InfoflowPerformanceData createPerformanceDataClass() {
        return new InfoflowPerformanceData();
    }

    @Override
    public void setExecutorFactory(IExecutorFactory executorFactory) {
        this.executorFactory = executorFactory;
    }

    @Override
    public void setPropagationRuleManagerFactory(IPropagationRuleManagerFactory ruleManagerFactory) {
        this.ruleManagerFactory = ruleManagerFactory;
    }

    @Override
    public Set<Stmt> getCollectedSources() {
        return this.collectedSources;
    }

    @Override
    public Set<Stmt> getCollectedSinks() {
        return this.collectedSinks;
    }

    private int getUsedMemory() {
        Runtime runtime = Runtime.getRuntime();
        return (int)Math.round((double)(runtime.totalMemory() - runtime.freeMemory()) / 1000000.0);
    }

    private void initializeIncrementalResultReporting(TaintPropagationResults propagationResults, final IAbstractionPathBuilder builder) {
        this.memoryWatcher.addSolver(builder);
        this.results = this.createResultsObject();
        propagationResults.addResultAvailableHandler(new TaintPropagationResults.OnTaintPropagationResultAdded(){

            @Override
            public boolean onResultAvailable(AbstractionAtSink abs) {
                builder.addResultAvailableHandler(new IAbstractionPathBuilder.OnPathBuilderResultAvailable(){

                    @Override
                    public void onResultAvailable(ResultSourceInfo source, ResultSinkInfo sink) {
                        for (ResultsAvailableHandler handler : AbstractInfoflow.this.onResultsAvailable) {
                            if (!(handler instanceof ResultsAvailableHandler2)) continue;
                            ResultsAvailableHandler2 handler2 = (ResultsAvailableHandler2)handler;
                            handler2.onSingleResultAvailable(source, sink);
                        }
                        AbstractInfoflow.this.results.addResult(sink, source);
                    }
                });
                builder.computeTaintPaths(Collections.singleton(abs));
                return true;
            }
        });
    }

    protected abstract InfoflowResults createResultsObject();

    private void removeEntailedAbstractions(Set<AbstractionAtSink> res) {
        Iterator<AbstractionAtSink> absAtSinkIt = res.iterator();
        block0: while (absAtSinkIt.hasNext()) {
            AbstractionAtSink curAbs = absAtSinkIt.next();
            for (AbstractionAtSink checkAbs : res) {
                if (checkAbs == curAbs || checkAbs.getSinkStmt() != curAbs.getSinkStmt() || !checkAbs.getAbstraction().localEquals(curAbs.getAbstraction()) || !checkAbs.getSinkDefinitions().equals(curAbs.getSinkDefinitions()) || !checkAbs.getAbstraction().getAccessPath().entails(curAbs.getAbstraction().getAccessPath())) continue;
                absAtSinkIt.remove();
                continue block0;
            }
        }
    }

    protected abstract IAliasingStrategy createAliasAnalysis(ISourceSinkManager var1, IInfoflowCFG var2, InterruptableExecutor var3, IMemoryManager<Abstraction, Unit> var4);

    protected IAliasingStrategy createBackwardAliasAnalysis(InfoflowManager manager, ISourceSinkManager sourcesSinks, IInfoflowCFG iCfg, InterruptableExecutor executor, IMemoryManager<Abstraction, Unit> memoryManager) {
        IInfoflowSolver aliasSolver = null;
        BackwardsAliasProblem aliasProblem = null;
        InfoflowManager aliasManager = null;
        return switch (this.getConfig().getAliasingAlgorithm()) {
            case InfoflowConfiguration.AliasingAlgorithm.FlowSensitive -> {
                aliasManager = new InfoflowManager(this.config, null, iCfg, sourcesSinks, this.taintWrapper, this.hierarchy, manager);
                aliasProblem = new BackwardsAliasProblem(aliasManager);
                InfoflowConfiguration.SolverConfiguration solverConfig = this.config.getSolverConfiguration();
                aliasSolver = this.createDataFlowSolver(executor, aliasProblem, solverConfig);
                aliasSolver.setMemoryManager(memoryManager);
                aliasSolver.setPredecessorShorteningMode(this.pathConfigToShorteningMode(manager.getConfig().getPathConfiguration()));
                aliasSolver.setMaxJoinPointAbstractions(solverConfig.getMaxJoinPointAbstractions());
                aliasSolver.setMaxCalleesPerCallSite(solverConfig.getMaxCalleesPerCallSite());
                aliasSolver.setMaxAbstractionPathLength(solverConfig.getMaxAbstractionPathLength());
                aliasSolver.setSolverId(false);
                aliasProblem.setTaintPropagationHandler(this.aliasPropagationHandler);
                aliasProblem.setTaintWrapper(this.taintWrapper);
                if (this.nativeCallHandler != null) {
                    aliasProblem.setNativeCallHandler(this.nativeCallHandler);
                }
                this.memoryWatcher.addSolver((IMemoryBoundedSolver)((Object)aliasSolver));
                yield new BackwardsFlowSensitiveAliasStrategy(manager, aliasSolver);
            }
            case InfoflowConfiguration.AliasingAlgorithm.None -> {
                aliasProblem = null;
                aliasSolver = null;
                yield new NullAliasStrategy();
            }
            default -> throw new RuntimeException("Unsupported aliasing algorithm: " + this.getConfig().getAliasingAlgorithm());
        };
    }

    protected Aliasing createAliasController(IAliasingStrategy aliasingStrategy) {
        return new Aliasing(aliasingStrategy, this.manager);
    }

    @Override
    public void addResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.add(handler);
    }

    @Override
    public void setTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandler = handler;
    }

    @Override
    public void setAliasPropagationHandler(TaintPropagationHandler handler) {
        this.aliasPropagationHandler = handler;
    }

    @Override
    public void removeResultsAvailableHandler(ResultsAvailableHandler handler) {
        this.onResultsAvailable.remove(handler);
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public boolean isResultAvailable() {
        return this.results != null;
    }

    @Override
    public void abortAnalysis() {
        AbortRequestedReason reason = new AbortRequestedReason();
        if (this.manager != null) {
            IInfoflowSolver backwardSolver;
            IInfoflowSolver forwardSolver = this.manager.getMainSolver();
            if (forwardSolver instanceof IMemoryBoundedSolver) {
                IMemoryBoundedSolver boundedSolver = (IMemoryBoundedSolver)((Object)forwardSolver);
                boundedSolver.forceTerminate(reason);
            }
            if ((backwardSolver = this.manager.getAliasSolver()) instanceof IMemoryBoundedSolver) {
                IMemoryBoundedSolver boundedSolver = (IMemoryBoundedSolver)((Object)backwardSolver);
                boundedSolver.forceTerminate(reason);
            }
            if (this.manager.additionalManager != null) {
                IInfoflowSolver additionalAliasSolver;
                IInfoflowSolver additionalSolver = this.manager.additionalManager.getMainSolver();
                if (additionalSolver instanceof IMemoryBoundedSolver) {
                    IMemoryBoundedSolver boundedSolver = (IMemoryBoundedSolver)((Object)additionalSolver);
                    boundedSolver.forceTerminate(reason);
                }
                if ((additionalAliasSolver = this.manager.additionalManager.getAliasSolver()) instanceof IMemoryBoundedSolver) {
                    IMemoryBoundedSolver boundedSolver = (IMemoryBoundedSolver)((Object)additionalAliasSolver);
                    boundedSolver.forceTerminate(reason);
                }
            }
        }
        if (this.memoryWatcher != null) {
            this.memoryWatcher.forceTerminate(reason);
        }
    }

    public void setThrowExceptions(boolean b) {
        this.throwExceptions = b;
    }

    protected abstract InfoflowManager initializeInfoflowManager(ISourceSinkManager var1, IInfoflowCFG var2, GlobalTaintManager var3);

    protected InfoflowManager initializeReverseInfoflowManager(IInfoflowCFG iCfg, GlobalTaintManager globalTaintManager) {
        return null;
    }

    protected void onBeforeTaintPropagation(IInfoflowSolver forwardSolver, IInfoflowSolver backwardSolver) {
    }

    protected void onTaintPropagationCompleted(IInfoflowSolver forwardSolver, IInfoflowSolver aliasSolver, IInfoflowSolver backwardSolver, IInfoflowSolver backwardAliasSolver) {
    }

    protected IAbstractionPathBuilder createPathBuilder(InterruptableExecutor executor) {
        return this.pathBuilderFactory.createPathBuilder(this.manager, executor);
    }

    protected abstract IPropagationRuleManagerFactory initializeRuleManagerFactory();

    protected IPropagationRuleManagerFactory initializeReverseRuleManagerFactory() {
        return null;
    }

    @Override
    public void setUsageContextProvider(IUsageContextProvider usageContextProvider) {
        this.usageContextProvider = usageContextProvider;
    }

    private static abstract class MethodSourceInjector
    implements MethodSource {
        private MethodSource innerSource;

        public MethodSourceInjector(MethodSource innerSource) {
            this.innerSource = innerSource;
        }

        public Body getBody(SootMethod m, String phaseName) {
            Body b = this.innerSource.getBody(m, phaseName);
            this.onMethodSourceLoaded(m, b);
            return b;
        }

        protected abstract void onMethodSourceLoaded(SootMethod var1, Body var2);
    }

    protected static class SourceOrSink {
        private final SourceInfo sourceInfo;
        private final SinkInfo sinkInfo;
        private final SourceSinkState state;

        protected SourceOrSink(SourceInfo sourceInfo, SinkInfo sinkInfo) {
            this.sourceInfo = sourceInfo;
            this.sinkInfo = sinkInfo;
            this.state = sourceInfo != null && sinkInfo == null ? SourceSinkState.SOURCE : (sinkInfo != null && sourceInfo == null ? SourceSinkState.SINK : (sourceInfo != null && sinkInfo != null ? SourceSinkState.BOTH : SourceSinkState.NEITHER));
        }

        protected SourceSinkState getState() {
            return this.state;
        }

        protected SourceInfo getSourceInfo() {
            return this.sourceInfo;
        }

        protected SinkInfo getSinkInfo() {
            return this.sinkInfo;
        }

        public String toString() {
            switch (this.state) {
                case SOURCE: {
                    return "Source";
                }
                case SINK: {
                    return "Sink";
                }
                case BOTH: {
                    return "Source and Sink";
                }
                case NEITHER: {
                    return "Neither";
                }
            }
            return "Unknown. That's a bad state to be in.";
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.sinkInfo, this.sourceInfo, this.state});
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceOrSink other = (SourceOrSink)obj;
            return Objects.equals(this.sinkInfo, other.sinkInfo) && Objects.equals(this.sourceInfo, other.sourceInfo) && this.state == other.state;
        }
    }

    protected static enum SourceSinkState {
        SOURCE,
        SINK,
        NEITHER,
        BOTH;

    }
}

