/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow;

import soot.FastHierarchy;
import soot.Scene;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.globalTaints.GlobalTaintManager;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.river.IUsageContextProvider;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.toolkits.callgraph.VirtualEdgesSummaries;

public class InfoflowManager {
    private final InfoflowConfiguration config;
    private IInfoflowSolver mainSolver;
    private IInfoflowSolver aliasSolver;
    private final IInfoflowCFG icfg;
    private final IInfoflowCFG originalIcfg;
    private final ISourceSinkManager sourceSinkManager;
    private final ITaintPropagationWrapper taintWrapper;
    private final TypeUtils typeUtils;
    private final FastHierarchy hierarchy;
    private final AccessPathFactory accessPathFactory;
    private final GlobalTaintManager globalTaintManager;
    private final VirtualEdgesSummaries virtualEdgeSummaries = new VirtualEdgesSummaries();
    private Aliasing aliasing;
    public InfoflowManager additionalManager;
    private IUsageContextProvider usageContextProvider;

    public InfoflowManager(InfoflowConfiguration config) {
        this.config = config;
        this.mainSolver = null;
        this.icfg = null;
        this.originalIcfg = null;
        this.sourceSinkManager = null;
        this.taintWrapper = null;
        this.typeUtils = null;
        this.hierarchy = null;
        this.accessPathFactory = null;
        this.globalTaintManager = null;
        this.additionalManager = null;
        this.usageContextProvider = null;
    }

    protected InfoflowManager(InfoflowConfiguration config, IInfoflowSolver mainSolver, IInfoflowCFG icfg, ISourceSinkManager sourceSinkManager, ITaintPropagationWrapper taintWrapper, FastHierarchy hierarchy, GlobalTaintManager globalTaintManager) {
        this.config = config;
        this.mainSolver = mainSolver;
        this.icfg = icfg;
        this.originalIcfg = null;
        this.sourceSinkManager = sourceSinkManager;
        this.taintWrapper = taintWrapper;
        this.typeUtils = new TypeUtils(this);
        this.hierarchy = hierarchy;
        this.accessPathFactory = new AccessPathFactory(config, this.typeUtils);
        this.globalTaintManager = globalTaintManager;
        this.usageContextProvider = null;
    }

    protected InfoflowManager(InfoflowConfiguration config, IInfoflowSolver mainSolver, IInfoflowCFG icfg, ISourceSinkManager sourceSinkManager, ITaintPropagationWrapper taintWrapper, FastHierarchy hierarchy, InfoflowManager existingManager) {
        this.config = config;
        this.mainSolver = mainSolver;
        this.icfg = icfg;
        this.originalIcfg = existingManager.getICFG();
        this.sourceSinkManager = sourceSinkManager;
        this.taintWrapper = taintWrapper;
        this.typeUtils = existingManager.getTypeUtils();
        this.hierarchy = hierarchy;
        this.accessPathFactory = existingManager.getAccessPathFactory();
        this.globalTaintManager = existingManager.getGlobalTaintManager();
        this.usageContextProvider = null;
    }

    public InfoflowManager(InfoflowConfiguration config, IInfoflowSolver mainSolver, IInfoflowCFG icfg) {
        this.config = config;
        this.mainSolver = mainSolver;
        this.icfg = icfg;
        this.originalIcfg = null;
        this.sourceSinkManager = null;
        this.taintWrapper = null;
        this.typeUtils = new TypeUtils(this);
        this.hierarchy = Scene.v().getOrMakeFastHierarchy();
        this.accessPathFactory = new AccessPathFactory(config, this.typeUtils);
        this.globalTaintManager = null;
        this.usageContextProvider = null;
    }

    public InfoflowConfiguration getConfig() {
        return this.config;
    }

    public void setMainSolver(IInfoflowSolver solver) {
        this.mainSolver = solver;
    }

    public IInfoflowSolver getMainSolver() {
        return this.mainSolver;
    }

    public IInfoflowSolver getAliasSolver() {
        return this.aliasSolver;
    }

    public void setAliasSolver(IInfoflowSolver solver) {
        this.aliasSolver = solver;
    }

    public IInfoflowCFG getICFG() {
        return this.icfg;
    }

    public IInfoflowCFG getOriginalICFG() {
        return this.originalIcfg;
    }

    public ISourceSinkManager getSourceSinkManager() {
        return this.sourceSinkManager;
    }

    public ITaintPropagationWrapper getTaintWrapper() {
        return this.taintWrapper;
    }

    public TypeUtils getTypeUtils() {
        return this.typeUtils;
    }

    public FastHierarchy getHierarchy() {
        return this.hierarchy;
    }

    public AccessPathFactory getAccessPathFactory() {
        return this.accessPathFactory;
    }

    public boolean isAnalysisAborted() {
        if (this.mainSolver instanceof IMemoryBoundedSolver) {
            return ((IMemoryBoundedSolver)((Object)this.mainSolver)).isKilled();
        }
        return false;
    }

    public void cleanup() {
        this.mainSolver = null;
        this.aliasing = null;
    }

    public void setAliasing(Aliasing aliasing) {
        this.aliasing = aliasing;
    }

    public Aliasing getAliasing() {
        return this.aliasing;
    }

    public GlobalTaintManager getGlobalTaintManager() {
        return this.globalTaintManager;
    }

    public void setUsageContextProvider(IUsageContextProvider usageContextProvider) {
        this.usageContextProvider = usageContextProvider;
    }

    public IUsageContextProvider getUsageContextProvider() {
        return this.usageContextProvider;
    }

    public VirtualEdgesSummaries getVirtualEdgeSummaries() {
        return this.virtualEdgeSummaries;
    }
}

