/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.aliasing;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import heros.solver.PathEdge;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import soot.Local;
import soot.PointsToAnalysis;
import soot.PointsToSet;
import soot.Scene;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.AbstractBulkAliasStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.AccessPathFactory;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.solver.IInfoflowSolver;

public class PtsBasedAliasStrategy
extends AbstractBulkAliasStrategy {
    private final Table<SootMethod, Abstraction, Set<Abstraction>> aliases = HashBasedTable.create();

    public PtsBasedAliasStrategy(InfoflowManager manager) {
        super(manager);
    }

    @Override
    public void computeAliasTaints(Abstraction d1, Stmt src, Value targetValue, Set<Abstraction> taintSet, SootMethod method, Abstraction newAbs) {
        this.computeAliasTaintsInternal(d1, method, newAbs, Collections.emptyList(), newAbs.getAccessPath().getTaintSubFields(), src);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeAliasTaintsInternal(Abstraction d1, SootMethod method, Abstraction newAbs, List<AccessPathFragment> appendFragments, boolean taintSubFields, Stmt actStmt) {
        actStmt = newAbs.getActivationUnit() == null ? actStmt : (Stmt)newAbs.getActivationUnit();
        Table<SootMethod, Abstraction, Set<Abstraction>> table = this.aliases;
        synchronized (table) {
            if (this.aliases.contains((Object)method, (Object)newAbs)) {
                d1s = (Set)this.aliases.get((Object)method, (Object)newAbs);
                if (d1s.contains(d1)) {
                    return;
                }
                d1s.add(d1);
            } else {
                d1s = Sets.newIdentityHashSet();
                d1s.add(d1);
                this.aliases.put((Object)method, (Object)newAbs, (Object)d1s);
            }
        }
        AccessPath ap = newAbs.getAccessPath();
        if (ap.isInstanceFieldRef() && ap.getFirstField() != null || ap.isStaticFieldRef() && ap.getFragmentCount() > 1) {
            LinkedList<AccessPathFragment> appendList = new LinkedList<AccessPathFragment>(appendFragments);
            appendList.add(0, newAbs.getAccessPath().getLastFragment());
            this.computeAliasTaintsInternal(d1, method, newAbs.deriveNewAbstraction(newAbs.getAccessPath().dropLastField(), null), appendList, taintSubFields, actStmt);
        }
        if (ap.getFragmentCount() > 1) {
            return;
        }
        PointsToSet ptsTaint = this.getPointsToSet(newAbs.getAccessPath());
        AccessPathFragment[] appendFragmentsA = appendFragments.toArray(new AccessPathFragment[appendFragments.size()]);
        boolean beforeActUnit = method.getActiveBody().getUnits().contains((Object)actStmt);
        AccessPathFactory apFactory = this.manager.getAccessPathFactory();
        for (Unit u : method.getActiveBody().getUnits()) {
            Abstraction aliasAbsRight;
            Abstraction aliasAbsLeft;
            Stmt stmt = (Stmt)u;
            if (stmt == actStmt) {
                beforeActUnit = false;
            }
            PointsToSet ptsBaseOrg = this.getPointsToSet((Value)newAbs.getAccessPath().getPlainValue());
            for (ValueBox vb : stmt.getUseAndDefBoxes()) {
                PointsToSet ptsBase = this.getPointsToSet(vb.getValue());
                if (ptsBase == null || !ptsBase.hasNonEmptyIntersection(ptsBaseOrg)) continue;
                AccessPath newAP = apFactory.appendFields(apFactory.copyWithNewValue(newAbs.getAccessPath(), vb.getValue()), appendFragmentsA, taintSubFields);
                Abstraction absCallee = newAbs.deriveNewAbstraction(newAP, stmt);
                absCallee = beforeActUnit ? absCallee.deriveInactiveAbstraction(actStmt) : absCallee.getActiveCopy();
                this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)u, (Object)absCallee));
                break;
            }
            if (!(u instanceof DefinitionStmt)) continue;
            DefinitionStmt assign = (DefinitionStmt)u;
            Value rop = assign.getRightOp();
            Value lop = assign.getLeftOp();
            if (this.isAliasedAtStmt(ptsTaint, rop) && appendFragments != null && appendFragments.size() > 0 && (aliasAbsLeft = newAbs.deriveNewAbstraction(this.manager.getAccessPathFactory().createAccessPath(lop, appendFragmentsA, taintSubFields), stmt)) != null) {
                aliasAbsLeft = beforeActUnit ? aliasAbsLeft.deriveInactiveAbstraction(actStmt) : aliasAbsLeft.getActiveCopy();
                this.computeAliasTaints(d1, stmt, lop, Collections.emptySet(), method, aliasAbsLeft);
            }
            if (!this.isAliasedAtStmt(ptsTaint, lop) || !this.isValidAccessPathRoot(rop) || (aliasAbsRight = newAbs.deriveNewAbstraction(this.manager.getAccessPathFactory().createAccessPath(rop, appendFragmentsA, taintSubFields), stmt)) == null) continue;
            aliasAbsRight = beforeActUnit ? aliasAbsRight.deriveInactiveAbstraction(actStmt) : aliasAbsRight.getActiveCopy();
            this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)u, (Object)aliasAbsRight));
        }
    }

    private boolean isValidAccessPathRoot(Value op) {
        return op instanceof FieldRef || op instanceof Local || op instanceof ArrayRef;
    }

    private boolean isAliasedAtStmt(PointsToSet ptsTaint, Value val) {
        if (ptsTaint != null) {
            PointsToSet ptsRight = this.getPointsToSet(val);
            return ptsRight != null && ptsTaint.hasNonEmptyIntersection(ptsRight);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PointsToSet getPointsToSet(Value targetValue) {
        PointsToAnalysis pta;
        PointsToAnalysis pointsToAnalysis = pta = Scene.v().getPointsToAnalysis();
        synchronized (pointsToAnalysis) {
            if (targetValue instanceof Local) {
                return pta.reachingObjects((Local)targetValue);
            }
            if (targetValue instanceof InstanceFieldRef) {
                InstanceFieldRef iref = (InstanceFieldRef)targetValue;
                return pta.reachingObjects((Local)iref.getBase(), iref.getField());
            }
            if (targetValue instanceof StaticFieldRef) {
                StaticFieldRef sref = (StaticFieldRef)targetValue;
                return pta.reachingObjects(sref.getField());
            }
            if (targetValue instanceof ArrayRef) {
                ArrayRef aref = (ArrayRef)targetValue;
                return pta.reachingObjects((Local)aref.getBase());
            }
            return null;
        }
    }

    private PointsToSet getPointsToSet(AccessPath accessPath) {
        if (accessPath.isLocal()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue());
        }
        if (accessPath.isInstanceFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getPlainValue(), accessPath.getFirstField());
        }
        if (accessPath.isStaticFieldRef()) {
            return Scene.v().getPointsToAnalysis().reachingObjects(accessPath.getFirstField());
        }
        throw new RuntimeException("Unexepected access path type");
    }

    @Override
    public void injectCallingContext(Abstraction abs, IInfoflowSolver fSolver, SootMethod callee, Unit callSite, Abstraction source, Abstraction d1) {
    }

    @Override
    public boolean isFlowSensitive() {
        return false;
    }

    @Override
    public boolean requiresAnalysisOnReturn() {
        return true;
    }

    @Override
    public IInfoflowSolver getSolver() {
        return null;
    }

    @Override
    public void cleanup() {
        this.aliases.clear();
    }
}

