/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.analyses;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import soot.Local;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.NewExpr;
import soot.jimple.Stmt;
import soot.toolkits.graph.DirectedGraph;
import soot.toolkits.scalar.ForwardFlowAnalysis;

public class ListSizeAnalysis
extends ForwardFlowAnalysis<Unit, Map<Local, ListSize>> {
    private final Set<SootClass> classes;
    private static final Set<String> increments = new HashSet<String>();
    private static final Set<String> decrements;
    private static final Set<String> resets;
    private static final Set<String> invalidates;

    public ListSizeAnalysis(DirectedGraph<Unit> graph) {
        super(graph);
        SootClass listClass = Scene.v().getSootClassUnsafe("java.util.List");
        SootClass queueClass = Scene.v().getSootClassUnsafe("java.util.Queue");
        this.classes = new HashSet<SootClass>(Scene.v().getFastHierarchy().getAllSubinterfaces(listClass));
        this.classes.addAll(Scene.v().getFastHierarchy().getAllImplementersOfInterface(listClass));
        this.classes.add(listClass);
        this.classes.addAll(Scene.v().getFastHierarchy().getAllSubinterfaces(queueClass));
        this.classes.addAll(Scene.v().getFastHierarchy().getAllImplementersOfInterface(queueClass));
        this.classes.add(queueClass);
        this.doAnalysis();
    }

    protected void flowThrough(Map<Local, ListSize> in, Unit unit, Map<Local, ListSize> out) {
        ListSize size;
        Local base;
        out.putAll(in);
        Stmt stmt = (Stmt)unit;
        if (stmt instanceof AssignStmt) {
            Value leftOp = ((AssignStmt)stmt).getLeftOp();
            Value rightOp = ((AssignStmt)stmt).getRightOp();
            if (leftOp instanceof Local && rightOp instanceof NewExpr) {
                SootClass sc = ((NewExpr)rightOp).getBaseType().getSootClass();
                if (this.classes.contains(sc)) {
                    out.put((Local)leftOp, new ListSize(0));
                }
            } else {
                out.remove(leftOp);
            }
            out.remove(rightOp);
        }
        if (!stmt.containsInvokeExpr()) {
            return;
        }
        for (Value v : stmt.getInvokeExpr().getArgs()) {
            if (!out.containsKey(v)) continue;
            out.put((Local)v, ListSize.bottom());
        }
        SootMethod sm = stmt.getInvokeExpr().getMethod();
        if (!this.classes.contains(sm.getDeclaringClass())) {
            return;
        }
        String subsig = sm.getSubSignature();
        if (increments.contains(subsig)) {
            base = (Local)((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase();
            ListSize size2 = out.get(base);
            if (size2 != null) {
                out.put(base, size2.plusOne());
            }
        } else if (decrements.contains(subsig)) {
            base = (Local)((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase();
            ListSize size3 = out.get(base);
            if (size3 != null) {
                out.put(base, size3.minusOne());
            }
        } else if (invalidates.contains(subsig)) {
            base = (Local)((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase();
            ListSize size4 = out.get(base);
            if (size4 != null) {
                out.put(base, ListSize.bottom());
            }
        } else if (resets.contains(subsig) && (size = out.get(base = (Local)((InstanceInvokeExpr)stmt.getInvokeExpr()).getBase())) != null) {
            out.put(base, new ListSize(0));
        }
    }

    protected Map<Local, ListSize> newInitialFlow() {
        return new HashMap<Local, ListSize>();
    }

    protected void merge(Map<Local, ListSize> in1, Map<Local, ListSize> in2, Map<Local, ListSize> out) {
        for (Local local : in1.keySet()) {
            ListSize in1Const = in1.get(local);
            ListSize in2Const = in2.get(local);
            if (in1Const == null) {
                out.put(local, in2Const);
                continue;
            }
            if (in2Const == null || in1Const.equals(in2Const)) {
                out.put(local, in1Const);
                continue;
            }
            out.put(local, ListSize.bottom());
        }
    }

    protected void copy(Map<Local, ListSize> source, Map<Local, ListSize> dest) {
        if (source == dest) {
            return;
        }
        dest.putAll(source);
    }

    static {
        increments.add("boolean add(java.lang.Object)");
        increments.add("java.lang.Object push(java.lang.Object)");
        increments.add("void addElement(java.lang.Object)");
        increments.add("boolean offer(java.lang.Object)");
        decrements = new HashSet<String>();
        decrements.add("java.lang.Object remove(int)");
        decrements.add("java.lang.Object pop()");
        resets = new HashSet<String>();
        resets.add("void clear()");
        invalidates = new HashSet<String>();
        invalidates.add("boolean remove(java.lang.Object)");
        invalidates.add("java.util.Iterator iterator()");
        invalidates.add("java.util.ListIterator listIterator()");
        invalidates.add("boolean removeAll(java.util.Collection)");
        invalidates.add("boolean retainAll(java.util.Collection)");
        invalidates.add("java.util.Spliterator spliterator()");
        invalidates.add("java.util.List subList(int,int)");
    }

    public static class ListSize {
        private static ListSize BOTTOM = new ListSize();
        int size;
        boolean isBottom;

        static ListSize bottom() {
            return BOTTOM;
        }

        ListSize(int size) {
            this.size = size;
        }

        private ListSize() {
            this.isBottom = true;
        }

        ListSize plusOne() {
            if (this.isBottom) {
                return this;
            }
            return new ListSize(this.size + 1);
        }

        ListSize minusOne() {
            if (this.isBottom) {
                return this;
            }
            return new ListSize(this.size - 1);
        }

        public int getSize() {
            return this.size;
        }

        public boolean isBottom() {
            return this.isBottom;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ListSize other = (ListSize)o;
            return this.size == other.size && this.isBottom == other.isBottom;
        }

        public int hashCode() {
            return Objects.hash(this.size, this.isBottom);
        }

        public String toString() {
            return this.isBottom ? "Size: BOTTOM" : "Size: " + this.size;
        }
    }
}

