/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.analyses;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import java.util.HashSet;
import java.util.Set;
import soot.FastHierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.LocalDefs;
import soot.toolkits.scalar.SimpleLocalDefs;
import soot.toolkits.scalar.SimpleLocalUses;
import soot.toolkits.scalar.UnitValueBoxPair;

public final class ReadOnlyListViewAnalysis {
    private final LoadingCache<UnitGraph, SimpleLocalUses> graphToUses = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<UnitGraph, SimpleLocalUses>(){

        public SimpleLocalUses load(UnitGraph ug) throws Exception {
            return new SimpleLocalUses(ug, (LocalDefs)new SimpleLocalDefs(ug));
        }
    });
    private final SootClass iteratorClass;
    private final Set<String> iteratorReadOperations;
    private final SootClass listClass;
    private final Set<String> listReadOperations;
    private final FastHierarchy fh;
    private final IInfoflowCFG icfg;

    public ReadOnlyListViewAnalysis(IInfoflowCFG icfg) throws IllegalStateException {
        this.icfg = icfg;
        this.fh = Scene.v().getOrMakeFastHierarchy();
        this.iteratorClass = Scene.v().getSootClassUnsafe("java.util.Iterator");
        this.listClass = Scene.v().getSootClassUnsafe("java.util.List");
        if (this.iteratorClass == null || this.listClass == null) {
            throw new IllegalStateException("Soot is not yet loaded!");
        }
        this.iteratorReadOperations = new HashSet<String>();
        this.iteratorReadOperations.add("void forEachRemaining(java.util.Consumer)");
        this.iteratorReadOperations.add("boolean hasNext()");
        this.iteratorReadOperations.add("boolean hasPrevious()");
        this.iteratorReadOperations.add("java.lang.Object next()");
        this.iteratorReadOperations.add("int nextIndex()");
        this.iteratorReadOperations.add("java.lang.Object previous()");
        this.iteratorReadOperations.add("int previousIndex()");
        this.iteratorReadOperations.add("boolean equals(java.lang.Object)");
        this.iteratorReadOperations.add("int hashCode()");
        this.iteratorReadOperations.add("java.lang.Object clone()");
        this.listReadOperations = new HashSet<String>();
        this.listReadOperations.add("boolean contains(java.lang.Object)");
        this.listReadOperations.add("int indexOf(java.lang.Object)");
        this.listReadOperations.add("int lastIndexOf(java.lang.Object)");
        this.listReadOperations.add("java.util.Iterator iterator()");
        this.listReadOperations.add("java.util.ListIterator listIterator()");
        this.listReadOperations.add("java.util.ListIterator listIterator(int)");
        this.listReadOperations.add("java.util.List subList()");
        this.listReadOperations.add("java.util.List subList(int,int)");
        this.listReadOperations.add("java.lang.Object get(int)");
        this.listReadOperations.add("boolean isEmpty()");
        this.listReadOperations.add("int size()");
        this.listReadOperations.add("java.lang.Object[] toArray()");
        this.listReadOperations.add("java.lang.Object[] toArray(java.lang.Object[])");
        this.listReadOperations.add("boolean equals(java.lang.Object)");
        this.listReadOperations.add("int hashCode()");
        this.listReadOperations.add("java.lang.Object clone()");
        this.listReadOperations.add("void replaceAll(java.util.function.UnaryOperator)");
        this.listReadOperations.add("java.lang.Object set(int,java.lang.Object)");
    }

    private boolean isHarmfulIteratorOperation(SootMethod sm) {
        return this.fh.canStoreClass(sm.getDeclaringClass(), this.iteratorClass) && !this.iteratorReadOperations.contains(sm.getSubSignature());
    }

    private boolean isHarmfulListOperation(SootMethod sm) {
        return this.fh.canStoreClass(sm.getDeclaringClass(), this.listClass) && !this.listReadOperations.contains(sm.getSubSignature());
    }

    public boolean isReadOnlyIterator(Unit unit) {
        if (!(unit instanceof AssignStmt)) {
            return true;
        }
        UnitGraph ug = (UnitGraph)this.icfg.getOrCreateUnitGraph((SootMethod)this.icfg.getMethodOf(unit));
        return this.isReadOnlyIteratorInternal((SimpleLocalUses)this.graphToUses.getUnchecked((Object)ug), (AssignStmt)unit);
    }

    private boolean isSupportedClass(Type type) {
        if (type instanceof RefType) {
            SootClass sc = ((RefType)type).getSootClass();
            return this.fh.canStoreClass(sc, this.iteratorClass) || this.fh.canStoreClass(sc, this.listClass);
        }
        return false;
    }

    private boolean isReadOnlyIteratorInternal(SimpleLocalUses du, AssignStmt assign) {
        for (UnitValueBoxPair uv : du.getUsesOf((Unit)assign)) {
            Stmt stmt = (Stmt)uv.getUnit();
            Value use = uv.getValueBox().getValue();
            if (stmt.containsInvokeExpr()) {
                if (this.isHarmfulIteratorOperation(stmt.getInvokeExpr().getMethod()) || this.isHarmfulListOperation(stmt.getInvokeExpr().getMethod())) {
                    return false;
                }
                if (stmt.getInvokeExpr().getArgs().contains(use)) {
                    return false;
                }
            } else if (stmt instanceof ReturnStmt) {
                return false;
            }
            if (!(stmt instanceof AssignStmt)) continue;
            Value lhs = ((AssignStmt)stmt).getLeftOp();
            boolean isLocal = lhs instanceof Local;
            boolean isSupportedClass = this.isSupportedClass(lhs.getType());
            if (!(!isLocal ? isSupportedClass : isSupportedClass && !this.isReadOnlyIteratorInternal(du, (AssignStmt)stmt))) continue;
            return false;
        }
        return true;
    }
}

