/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.codeOptimization;

import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.MethodOrMethodContext;
import soot.Scene;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.Jimple;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.codeOptimization.ICodeOptimizer;
import soot.jimple.infoflow.collections.codeOptimization.ReplacementCandidates;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.toolkits.callgraph.ReachableMethods;
import soot.tagkit.ConstantValueTag;
import soot.tagkit.Tag;
import soot.util.queue.QueueReader;

public class ConstantTagFolding
implements ICodeOptimizer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private int runtime = -1;
    private int replaced = -1;

    public int getRuntime() {
        return this.runtime;
    }

    public int getReplacedStatementCount() {
        return this.replaced;
    }

    @Override
    public void initialize(InfoflowConfiguration config) {
    }

    private Constant getConstant(FieldRef f) {
        SootField field = f.getField();
        for (Tag t : field.getTags()) {
            if (!(t instanceof ConstantValueTag)) continue;
            return ((ConstantValueTag)t).getConstant();
        }
        return null;
    }

    @Override
    public void run(InfoflowManager manager, Collection<SootMethod> entryPoints, ISourceSinkManager sourcesSinks, ITaintPropagationWrapper taintWrapper) {
        if (manager.getConfig().getCodeEliminationMode() == InfoflowConfiguration.CodeEliminationMode.NoCodeElimination) {
            return;
        }
        long beforeOptimization = System.nanoTime();
        ReplacementCandidates rcs = new ReplacementCandidates();
        ReachableMethods rm = Scene.v().getReachableMethods();
        QueueReader iter = rm.listener();
        while (iter.hasNext()) {
            SootMethod sm = ((MethodOrMethodContext)iter.next()).method();
            if (sm == null || !sm.hasActiveBody() || entryPoints.contains(sm)) continue;
            for (Unit u : sm.retrieveActiveBody().getUnits()) {
                Constant c;
                AssignStmt stmt;
                Value rightOp;
                if (!(u instanceof AssignStmt) || !((rightOp = (stmt = (AssignStmt)u).getRightOp()) instanceof FieldRef) || (c = this.getConstant((FieldRef)rightOp)) == null) continue;
                AssignStmt replacement = Jimple.v().newAssignStmt(stmt.getLeftOp(), (Value)c);
                rcs.add(sm, (Stmt)stmt, (Stmt)replacement);
            }
        }
        rcs.replace(manager.getICFG());
        this.replaced = rcs.size();
        this.runtime = (int)Math.round((double)(System.nanoTime() - beforeOptimization) / 1.0E9);
        this.logger.info(String.format("Resolved %d constant fields in %d seconds.", this.replaced, this.runtime));
    }
}

