/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.codeOptimization;

import java.util.HashSet;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.toolkits.scalar.ConstantPropagatorAndFolder;

public class ReplacementCandidates
extends HashSet<RTriple> {
    private static final long serialVersionUID = -9071828269301702785L;

    public void add(SootMethod sm, Stmt oldStmt, Stmt newStmt) {
        this.add(new RTriple(sm, oldStmt, newStmt));
    }

    public void replace(IInfoflowCFG icfg) {
        HashSet<SootMethod> changedMethods = new HashSet<SootMethod>();
        for (RTriple rt : this) {
            rt.replace();
            changedMethods.add(rt.method);
        }
        for (SootMethod sm : changedMethods) {
            ConstantPropagatorAndFolder.v().transform(sm.getActiveBody());
            icfg.notifyMethodChanged(sm);
        }
    }

    protected static class RTriple {
        private final SootMethod method;
        private final Stmt oldStmt;
        private final Stmt newStmt;

        private RTriple(SootMethod method, Stmt oldStmt, Stmt newStmt) {
            this.method = method;
            this.oldStmt = oldStmt;
            this.newStmt = newStmt;
        }

        private void replace() {
            this.method.getActiveBody().getUnits().swapWith((Unit)this.oldStmt, (Unit)this.newStmt);
        }
    }
}

