/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.context;

import java.util.Objects;
import soot.jimple.infoflow.collections.context.PositionBasedContext;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.ContainerContext;

public class IntervalContext
implements PositionBasedContext<IntervalContext> {
    private final int min;
    private final int max;
    private final boolean impreciseValue;

    public IntervalContext(int i) {
        this(i, i, false);
    }

    public IntervalContext(int min, int max) {
        this(min, max, false);
    }

    public IntervalContext(int min, int max, boolean impreciseValue) {
        this.min = min;
        this.max = max;
        this.impreciseValue = impreciseValue;
    }

    public int getMax() {
        return this.max;
    }

    public int getMin() {
        return this.min;
    }

    @Override
    public Tristate intersects(IntervalContext other) {
        if (this.equals(other)) {
            return this.isImprecise() ? Tristate.MAYBE() : Tristate.TRUE();
        }
        if (Integer.max(this.min, other.min) <= Integer.min(this.max, other.max)) {
            return Tristate.MAYBE();
        }
        return Tristate.FALSE();
    }

    @Override
    public boolean entails(ContainerContext obj) {
        if (!(obj instanceof IntervalContext)) {
            return false;
        }
        IntervalContext other = (IntervalContext)obj;
        return this.min <= other.min && other.max <= this.max;
    }

    @Override
    public IntervalContext exactShift(IntervalContext n) {
        int newMax = n.max > 0 && Integer.MAX_VALUE - this.max < n.max ? Integer.MAX_VALUE : this.max + n.max;
        int newMin = this.min + n.min;
        if (newMin < 0) {
            if (newMax < 0) {
                return this;
            }
            newMin = 0;
        }
        return new IntervalContext(newMin, newMin);
    }

    @Override
    public IntervalContext union(IntervalContext other) {
        return new IntervalContext(Math.min(this.min, other.min), Math.max(this.max, other.max));
    }

    @Override
    public Tristate lessThanEqual(IntervalContext other) {
        if (this.max <= other.min) {
            return Tristate.TRUE();
        }
        if (other.max < this.min) {
            return Tristate.FALSE();
        }
        return Tristate.MAYBE();
    }

    @Override
    public boolean containsInformation() {
        return this.min != 0 || this.max != Integer.MAX_VALUE;
    }

    @Override
    public boolean isImprecise() {
        return this.min != this.max || this.impreciseValue;
    }

    public int size() {
        return this.max - this.min;
    }

    public int hashCode() {
        return Objects.hash(this.min, this.max);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IntervalContext other = (IntervalContext)o;
        return this.min == other.min && this.max == other.max && this.isImprecise() == other.isImprecise();
    }

    public String toString() {
        return this.min + "-" + this.max;
    }
}

