/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.context;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import soot.jimple.infoflow.collections.context.ValueBasedContext;
import soot.jimple.infoflow.collections.util.ImmutableArraySet;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.ContainerContext;

public class KeySetContext<C>
implements ValueBasedContext<KeySetContext<?>> {
    private final Set<C> keys;
    private final boolean impreciseValue;

    public KeySetContext(C key) {
        this(key, false);
    }

    public KeySetContext(C key, boolean impreciseValue) {
        this.keys = new ImmutableArraySet<C>(key);
        this.impreciseValue = impreciseValue;
    }

    public KeySetContext(Set<C> keys) {
        this(keys, false);
    }

    public KeySetContext(Set<C> keys, boolean impreciseValue) {
        this.keys = new ImmutableArraySet<C>(keys);
        this.impreciseValue = impreciseValue;
    }

    @Override
    public Tristate intersect(KeySetContext<?> other) {
        boolean imprecise = this.isImprecise() || other.isImprecise();
        boolean all = true;
        boolean any = false;
        for (C c : this.keys) {
            if (other.keys.contains(c)) {
                any = true;
                all = all && !imprecise;
            } else {
                all = false;
            }
            if (!any || all) continue;
            return Tristate.MAYBE();
        }
        return Tristate.fromBoolean(any && all);
    }

    @Override
    public boolean entails(ContainerContext other) {
        if (!(other instanceof KeySetContext)) {
            return false;
        }
        for (C key : this.keys) {
            if (((KeySetContext)other).keys.contains(key)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean containsInformation() {
        return !this.keys.isEmpty();
    }

    @Override
    public boolean isImprecise() {
        return this.impreciseValue || this.keys.size() > 1;
    }

    public String toString() {
        return this.keys.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeySetContext that = (KeySetContext)o;
        return Objects.equals(this.keys, that.keys) && this.isImprecise() == that.isImprecise();
    }

    public int hashCode() {
        return Objects.hash(this.keys);
    }
}

