/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.problems.rules.forward;

import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import soot.ArrayType;
import soot.IntType;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collections.ICollectionsSupport;
import soot.jimple.infoflow.collections.strategies.containers.IContainerStrategy;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.ContainerContext;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.IArrayContextProvider;
import soot.jimple.infoflow.problems.rules.forward.ArrayPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class ArrayWithIndexPropagationRule
extends ArrayPropagationRule
implements IArrayContextProvider {
    public ArrayWithIndexPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        AccessPath ap;
        Value rightVal;
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        boolean contentTainted = source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length;
        Abstraction newAbs = null;
        Aliasing aliasing = this.getAliasing();
        Value leftVal = assignStmt.getLeftOp();
        if (leftVal instanceof ArrayRef) {
            Value leftBase = ((ArrayRef)leftVal).getBase();
            Value leftIndex = ((ArrayRef)leftVal).getIndex();
            if (contentTainted && aliasing.mayAlias(leftBase, (Value)source.getAccessPath().getPlainValue()) && this.matchesIndex(source, leftIndex, stmt).isTrue()) {
                if (source.getAccessPath().getArrayTaintType() == AccessPath.ArrayTaintType.ContentsAndLength) {
                    AccessPath ap2 = this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)source.getAccessPath().getPlainValue(), source.getAccessPath().getBaseType(), false, true, AccessPath.ArrayTaintType.Length);
                    killSource.value = true;
                    return Collections.singleton(source.deriveNewAbstraction(ap2, stmt));
                }
                killAll.value = true;
                return null;
            }
        }
        if ((rightVal = assignStmt.getRightOp()) instanceof LengthExpr) {
            LengthExpr lengthExpr = (LengthExpr)rightVal;
            if (this.getAliasing().mayAlias((Value)source.getAccessPath().getPlainValue(), lengthExpr.getOp())) {
                if (source.getAccessPath().getArrayTaintType() == AccessPath.ArrayTaintType.Contents) {
                    return null;
                }
                ap = this.getManager().getAccessPathFactory().createAccessPath(leftVal, (Type)IntType.v(), null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength);
                newAbs = source.deriveNewAbstraction(ap, (Stmt)assignStmt);
            }
        }
        if (rightVal instanceof ArrayRef) {
            Value rightBase = ((ArrayRef)rightVal).getBase();
            Value rightIndex = ((ArrayRef)rightVal).getIndex();
            if (contentTainted && this.getAliasing().mayAlias(rightBase, (Value)source.getAccessPath().getPlainValue()) && !this.matchesIndex(source, rightIndex, stmt).isFalse()) {
                Object targetType = source.getAccessPath().getBaseType();
                assert (targetType instanceof ArrayType);
                targetType = targetType instanceof ArrayType ? ((ArrayType)targetType).getElementType() : null;
                AccessPath.ArrayTaintType arrayTaintType = source.getAccessPath().getArrayTaintType();
                AccessPath ap3 = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftVal, (Type)targetType, false, true, arrayTaintType);
                newAbs = source.deriveNewAbstraction(ap3, (Stmt)assignStmt);
            } else if (source.getAccessPath().getArrayTaintType() != AccessPath.ArrayTaintType.Length && rightIndex == source.getAccessPath().getPlainValue() && this.getManager().getConfig().getImplicitFlowMode().trackArrayAccesses()) {
                AccessPath.ArrayTaintType arrayTaintType = AccessPath.ArrayTaintType.ContentsAndLength;
                AccessPath ap4 = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftVal, null, false, true, arrayTaintType);
                newAbs = source.deriveNewAbstraction(ap4, (Stmt)assignStmt);
            }
        } else if (rightVal instanceof NewArrayExpr && this.getManager().getConfig().getEnableArraySizeTainting()) {
            NewArrayExpr newArrayExpr = (NewArrayExpr)rightVal;
            if (this.getAliasing().mayAlias((Value)source.getAccessPath().getPlainValue(), newArrayExpr.getSize())) {
                ap = this.getManager().getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftVal, null, false, true, AccessPath.ArrayTaintType.Length);
                newAbs = source.deriveNewAbstraction(ap, (Stmt)assignStmt);
            }
        }
        if (newAbs == null) {
            return null;
        }
        Set<Object> res = Collections.singleton(newAbs);
        if (this.manager.getAliasing().canHaveAliases((Stmt)assignStmt, leftVal, newAbs)) {
            this.getAliasing().computeAliases(d1, (Stmt)assignStmt, leftVal, res, (SootMethod)this.getManager().getICFG().getMethodOf(assignStmt), newAbs);
        }
        return res;
    }

    private Tristate matchesIndex(Abstraction incoming, Value index, Stmt stmt) {
        ContainerContext[] apCtxt = incoming.getAccessPath().getBaseContext();
        if (apCtxt == null) {
            return Tristate.MAYBE();
        }
        IContainerStrategy strategy = ((ICollectionsSupport)this.manager.getTaintWrapper()).getContainerStrategy();
        ContainerContext indexCtxt = strategy.getIndexContext(index, stmt);
        return strategy.intersect(apCtxt[0], indexCtxt);
    }

    @Override
    public ContainerContext[] getContextForArrayRef(ArrayRef arrayRef, Stmt stmt) {
        ContainerContext[] containerContextArray;
        IContainerStrategy strategy = ((ICollectionsSupport)this.manager.getTaintWrapper()).getContainerStrategy();
        ContainerContext ctxt = strategy.getIndexContext(arrayRef.getIndex(), stmt);
        if (ctxt.containsInformation()) {
            ContainerContext[] containerContextArray2 = new ContainerContext[1];
            containerContextArray = containerContextArray2;
            containerContextArray2[0] = ctxt;
        } else {
            containerContextArray = null;
        }
        return containerContextArray;
    }
}

