/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.problems.rules.forward;

import java.util.HashSet;
import java.util.Set;
import soot.Local;
import soot.RefType;
import soot.SootMethod;
import soot.Value;
import soot.jimple.DefinitionStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.collections.ICollectionsSupport;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.forward.WrapperPropagationRule;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class CollectionWrapperPropagationRule
extends WrapperPropagationRule {
    public CollectionWrapperPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    protected Set<Abstraction> computeWrapperTaints(Abstraction d1, Stmt iStmt, Abstraction source, ByReferenceBoolean killSource) {
        if (source == this.getZeroValue()) {
            return null;
        }
        if (this.getManager().getTaintWrapper() == null) {
            return null;
        }
        Aliasing aliasing = this.getAliasing();
        if (aliasing != null && !source.getAccessPath().isStaticFieldRef() && !source.getAccessPath().isEmpty()) {
            boolean found = false;
            Local base = null;
            if (iStmt.getInvokeExpr() instanceof InstanceInvokeExpr) {
                InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)iStmt.getInvokeExpr();
                base = (Local)iiExpr.getBase();
                found = aliasing.mayAlias((Value)base, (Value)source.getAccessPath().getPlainValue());
            }
            if (!found) {
                for (int paramIdx = 0; paramIdx < iStmt.getInvokeExpr().getArgCount(); ++paramIdx) {
                    if (!aliasing.mayAlias((Value)source.getAccessPath().getPlainValue(), iStmt.getInvokeExpr().getArg(paramIdx))) continue;
                    found = true;
                    break;
                }
            }
            if (!found && base != null && this.manager.getTaintWrapper() instanceof ICollectionsSupport) {
                Set<Abstraction> approx = ((ICollectionsSupport)this.manager.getTaintWrapper()).getTaintsForMethodApprox(iStmt, d1, source);
                if (approx == null) {
                    return null;
                }
                killSource.value = true;
                return approx;
            }
            if (!found) {
                return null;
            }
        }
        if (!this.getManager().getConfig().getInspectSources() && iStmt.hasTag("fd_source")) {
            return null;
        }
        Set<Abstraction> res = this.getManager().getTaintWrapper().getTaintsForMethod(iStmt, d1, source);
        if (res != null) {
            HashSet<Abstraction> resWithAliases = new HashSet<Abstraction>(res);
            for (Abstraction abs : res) {
                if (abs.equals(source)) continue;
                this.checkAndPropagateAlias(d1, iStmt, resWithAliases, abs);
            }
            res = resWithAliases;
        }
        killSource.value = this.manager.getTaintWrapper() != null && this.manager.getTaintWrapper().isExclusive(iStmt, source);
        return res;
    }

    @Override
    protected void checkAndPropagateAlias(Abstraction d1, Stmt iStmt, Set<Abstraction> resWithAliases, Abstraction abs) {
        boolean taintedValueOverwritten;
        AccessPath val = abs.getAccessPath();
        boolean isBasicString = TypeUtils.isStringType(val.getBaseType()) && !val.getCanHaveImmutableAliases() && !this.getAliasing().isStringConstructorCall(iStmt);
        boolean taintsObjectValue = val.getBaseType() instanceof RefType && abs.getAccessPath().getBaseType() instanceof RefType && !isBasicString;
        boolean taintsStaticField = this.getManager().getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && abs.getAccessPath().isStaticFieldRef();
        boolean bl = taintedValueOverwritten = iStmt instanceof DefinitionStmt ? Aliasing.baseMatches(((DefinitionStmt)iStmt).getLeftOp(), abs) : false;
        if (!taintedValueOverwritten && (taintsStaticField || taintsObjectValue && abs.getAccessPath().getTaintSubFields() || this.manager.getAliasing().canHaveAliases(iStmt, val.getCompleteValue(), abs))) {
            HashSet<Abstraction> aliases = new HashSet<Abstraction>();
            for (Abstraction a : resWithAliases) {
                boolean contextChange = abs.equalsWithoutContext(a);
                if (contextChange) continue;
                aliases.add(a);
            }
            if (!aliases.isEmpty()) {
                this.getAliasing().computeAliases(d1, iStmt, (Value)val.getPlainValue(), aliases, (SootMethod)this.getManager().getICFG().getMethodOf(iStmt), abs);
            }
        }
    }
}

