/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.strategies.containers;

import soot.Value;
import soot.jimple.IntConstant;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collections.context.IntervalContext;
import soot.jimple.infoflow.collections.context.KeySetContext;
import soot.jimple.infoflow.collections.context.UnknownContext;
import soot.jimple.infoflow.collections.strategies.containers.ConstantMapStrategy;
import soot.jimple.infoflow.collections.strategies.containers.shift.IShiftOperation;
import soot.jimple.infoflow.collections.strategies.containers.shift.MinMaxShift;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.ContainerContext;

public abstract class AbstractListStrategy
extends ConstantMapStrategy {
    private long resolvedIndices;
    private long unresolvedIndices;
    private final IShiftOperation shiftOp;

    public AbstractListStrategy(InfoflowManager manager) {
        super(manager);
        this.shiftOp = new MinMaxShift();
    }

    public AbstractListStrategy(InfoflowManager manager, IShiftOperation shiftOp) {
        super(manager);
        this.shiftOp = shiftOp;
    }

    public long getResolvedIndices() {
        return this.resolvedIndices;
    }

    public long getUnresolvedIndices() {
        return this.unresolvedIndices;
    }

    @Override
    public Tristate intersect(ContainerContext apKey, ContainerContext stmtKey) {
        if (apKey == UnknownContext.v() || stmtKey == UnknownContext.v()) {
            return Tristate.MAYBE();
        }
        if (apKey instanceof IntervalContext) {
            return ((IntervalContext)apKey).intersects((IntervalContext)stmtKey);
        }
        if (apKey instanceof KeySetContext) {
            return ((KeySetContext)apKey).intersect((KeySetContext)stmtKey);
        }
        throw new RuntimeException("Got unknown context: " + apKey.getClass());
    }

    @Override
    public ContainerContext getIndexContext(Value value, Stmt stmt) {
        if (value instanceof IntConstant) {
            ++this.resolvedIndices;
            return new IntervalContext(((IntConstant)value).value);
        }
        ++this.unresolvedIndices;
        return UnknownContext.v();
    }

    @Override
    public abstract ContainerContext getNextPosition(Value var1, Stmt var2);

    @Override
    public ContainerContext getFirstPosition(Value value, Stmt stmt) {
        ++this.resolvedIndices;
        return new IntervalContext(0);
    }

    @Override
    public abstract ContainerContext getLastPosition(Value var1, Stmt var2);

    @Override
    public Tristate lessThanEqual(ContainerContext ctxt1, ContainerContext ctxt2) {
        if (ctxt1 == UnknownContext.v() || ctxt2 == UnknownContext.v()) {
            return Tristate.MAYBE();
        }
        if (ctxt1 instanceof IntervalContext && ctxt2 instanceof IntervalContext) {
            return ((IntervalContext)ctxt1).lessThanEqual((IntervalContext)ctxt2);
        }
        throw new RuntimeException("Unknown combination of " + ctxt1.toString() + " and " + ctxt2.toString());
    }

    @Override
    public ContainerContext shift(ContainerContext ctxt, int n, boolean exact) {
        return this.shiftOp.shift(ctxt, n, exact);
    }

    @Override
    public ContainerContext[] append(ContainerContext[] ctxt1, ContainerContext[] ctxt2) {
        if (ctxt1 == null || ctxt2 == null || ctxt1.length != ctxt2.length || ctxt1.length != 1 || !(ctxt1[0] instanceof IntervalContext)) {
            return null;
        }
        ContainerContext[] newCtxt = new ContainerContext[]{((IntervalContext)ctxt1[0]).exactShift((IntervalContext)ctxt2[0])};
        return newCtxt;
    }
}

