/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.strategies.containers;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import soot.FastHierarchy;
import soot.Local;
import soot.RefType;
import soot.Scene;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.Constant;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collections.analyses.ReadOnlyListViewAnalysis;
import soot.jimple.infoflow.collections.context.KeySetContext;
import soot.jimple.infoflow.collections.context.UnknownContext;
import soot.jimple.infoflow.collections.strategies.containers.IContainerStrategy;
import soot.jimple.infoflow.collections.util.Tristate;
import soot.jimple.infoflow.data.ContainerContext;

public class ConstantMapStrategy
implements IContainerStrategy {
    private volatile long resolvedKeys;
    private volatile long unresolvedKeys;
    protected final InfoflowManager manager;
    protected final ReadOnlyListViewAnalysis itAnalysis;
    protected final List<RefType> indexTypes;

    public ConstantMapStrategy(InfoflowManager manager) {
        this.manager = manager;
        this.itAnalysis = new ReadOnlyListViewAnalysis(manager.getICFG());
        this.indexTypes = new ArrayList<RefType>(2);
        this.indexTypes.add(RefType.v((String)"java.util.List"));
        this.indexTypes.add(RefType.v((String)"java.util.Queue"));
    }

    public long getResolvedKeys() {
        return this.resolvedKeys;
    }

    public long getUnresolvedKeys() {
        return this.unresolvedKeys;
    }

    @Override
    public Tristate intersect(ContainerContext apKey, ContainerContext stmtKey) {
        if (apKey == UnknownContext.v() || stmtKey == UnknownContext.v()) {
            return Tristate.MAYBE();
        }
        if (apKey instanceof KeySetContext) {
            return ((KeySetContext)apKey).intersect((KeySetContext)stmtKey);
        }
        throw new RuntimeException("Got unknown context: " + apKey.getClass());
    }

    @Override
    public ContainerContext[] append(ContainerContext[] ctxt1, ContainerContext[] ctxt2) {
        return null;
    }

    @Override
    public ContainerContext getKeyContext(Value value, Stmt stmt) {
        if (value instanceof Constant) {
            ++this.resolvedKeys;
            return new KeySetContext<Constant>((Constant)value);
        }
        ++this.unresolvedKeys;
        return UnknownContext.v();
    }

    protected boolean shouldResolveIndex(Value base) {
        if (!(base instanceof Local)) {
            return false;
        }
        if (base.getType() instanceof RefType && !((RefType)base.getType()).getClassName().equals("java.util.Collection")) {
            return true;
        }
        Set types = Scene.v().getPointsToAnalysis().reachingObjects((Local)base).possibleTypes();
        FastHierarchy fh = Scene.v().getFastHierarchy();
        for (Type t : types) {
            for (RefType idxType : this.indexTypes) {
                if (!fh.canStoreType(t, (Type)idxType)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public ContainerContext getIndexContext(Value value, Stmt stmt) {
        return UnknownContext.v();
    }

    @Override
    public ContainerContext getNextPosition(Value value, Stmt stmt) {
        return UnknownContext.v();
    }

    @Override
    public ContainerContext getFirstPosition(Value value, Stmt stmt) {
        return UnknownContext.v();
    }

    @Override
    public ContainerContext getLastPosition(Value value, Stmt stmt) {
        return UnknownContext.v();
    }

    @Override
    public Tristate lessThanEqual(ContainerContext ctxt1, ContainerContext ctxt2) {
        return Tristate.MAYBE();
    }

    @Override
    public ContainerContext shift(ContainerContext ctxt, int n, boolean exact) {
        return UnknownContext.v();
    }

    @Override
    public boolean shouldSmash(ContainerContext[] ctxts) {
        for (ContainerContext ctxt : ctxts) {
            if (!ctxt.containsInformation()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isReadOnly(Unit unit) {
        return this.itAnalysis.isReadOnlyIterator(unit);
    }
}

