/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.strategies.widening;

import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import soot.Unit;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collections.strategies.widening.WideningStrategy;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;

public class WideningTaintPropagationHandler
implements TaintPropagationHandler {
    private volatile WideningStrategy<Unit, Abstraction> wideningStrategy;
    private final Function<InfoflowManager, WideningStrategy<Unit, Abstraction>> wideningStrategySupplier;

    public WideningTaintPropagationHandler(Function<InfoflowManager, WideningStrategy<Unit, Abstraction>> wideningStrategySupplier) {
        this.wideningStrategySupplier = wideningStrategySupplier;
    }

    private synchronized WideningStrategy<Unit, Abstraction> getWideningStrategy(InfoflowManager manager) {
        if (this.wideningStrategy == null) {
            this.wideningStrategy = this.wideningStrategySupplier.apply(manager);
        }
        return this.wideningStrategy;
    }

    @Override
    public void notifyFlowIn(Unit stmt, Abstraction taint, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
    }

    @Override
    public Set<Abstraction> notifyFlowOut(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        if (type != TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction) {
            return outgoing;
        }
        Set<Abstraction> newOutgoing = outgoing;
        WideningStrategy<Unit, Abstraction> wideningStrategy = this.getWideningStrategy(manager);
        for (Abstraction abs : outgoing) {
            Abstraction widened = wideningStrategy.widen(incoming, abs, stmt);
            if (widened == abs) continue;
            if (newOutgoing == outgoing) {
                newOutgoing = new HashSet<Abstraction>(outgoing);
            }
            newOutgoing.add(widened);
            newOutgoing.remove(abs);
        }
        return newOutgoing;
    }
}

