/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.util;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Consumer;

public class MySpecialMultiMap<K, V> {
    protected NotReusableSet<V> notReusableSet = new NotReusableSet();
    protected final ConcurrentMap<K, MySet<V>> m = new ConcurrentHashMap<K, MySet<V>>();

    public V putAndGetFirst(K key, V value) {
        Object[] returnValue = new Object[1];
        this.m.compute(key, (k, set) -> {
            if (set == null) {
                return new MySet<Object>(value);
            }
            returnValue[0] = set.firstValue;
            set.add(value);
            return set;
        });
        return (V)returnValue[0];
    }

    public void consumeOtherValuesAndRemove(K key, Consumer<V> consumer) {
        this.m.computeIfPresent(key, (k, set) -> {
            for (Object v : set.otherValues) {
                consumer.accept(v);
            }
            return this.notReusableSet;
        });
    }

    public void consumeOtherValues(K key, Consumer<V> consumer) {
        this.m.computeIfPresent(key, (k, set) -> {
            for (Object v : set.otherValues) {
                consumer.accept(v);
            }
            return set;
        });
    }

    public void clear() {
        this.m.clear();
    }

    protected static class NotReusableSet<V>
    extends MySet<V> {
        NotReusableSet() {
            super(null, Collections.emptySet());
        }

        @Override
        void add(V value) {
        }
    }

    protected static class MySet<V> {
        protected final V firstValue;
        protected final Set<V> otherValues;

        MySet(V v) {
            this(v, new HashSet());
        }

        private MySet(V v, Set<V> newSet) {
            this.firstValue = v;
            this.otherValues = newSet;
        }

        void add(V value) {
            if (!this.firstValue.equals(value)) {
                this.otherValues.add(value);
            }
        }
    }
}

