/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.collections.util;

public class Tristate {
    private final State internal;
    private static final Tristate TRUE_INSTANCE = new Tristate(State.TRUE);
    private static final Tristate FALSE_INSTANCE = new Tristate(State.FALSE);
    private static final Tristate MAYBE_INSTANCE = new Tristate(State.MAYBE);

    private Tristate(State s) {
        this.internal = s;
    }

    public static Tristate TRUE() {
        return TRUE_INSTANCE;
    }

    public static Tristate FALSE() {
        return FALSE_INSTANCE;
    }

    public static Tristate MAYBE() {
        return MAYBE_INSTANCE;
    }

    public static Tristate fromBoolean(boolean b) {
        return b ? Tristate.TRUE() : Tristate.FALSE();
    }

    public boolean isTrue() {
        return this.internal == State.TRUE;
    }

    public boolean isFalse() {
        return this.internal == State.FALSE;
    }

    public boolean isMaybe() {
        return this.internal == State.MAYBE;
    }

    public Tristate and(Tristate other) {
        if (this.isTrue() && other.isTrue()) {
            return TRUE_INSTANCE;
        }
        if (this.isFalse() || other.isFalse()) {
            return FALSE_INSTANCE;
        }
        return MAYBE_INSTANCE;
    }

    public Tristate negate() {
        switch (this.internal) {
            case MAYBE: {
                return MAYBE_INSTANCE;
            }
            case TRUE: {
                return FALSE_INSTANCE;
            }
            case FALSE: {
                return TRUE_INSTANCE;
            }
        }
        throw new RuntimeException("Case missing!");
    }

    public String toString() {
        return this.internal.toString();
    }

    private static enum State {
        TRUE,
        FALSE,
        MAYBE;

    }
}

