/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Collection;
import soot.jimple.Stmt;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class AbstractionAtSink {
    private final Collection<ISourceSinkDefinition> sinkDefinitions;
    private final Abstraction abstraction;
    private final Stmt sinkStmt;

    public AbstractionAtSink(Collection<ISourceSinkDefinition> sinkDefinitions, Abstraction abstraction, Stmt sinkStmt) {
        this.sinkDefinitions = sinkDefinitions;
        this.abstraction = AbstractionAtSink.cleanse(abstraction);
        this.sinkStmt = sinkStmt;
    }

    private static Abstraction cleanse(Abstraction abs) {
        if (abs.getTurnUnit() == null) {
            return abs;
        }
        return abs.deriveNewAbstractionWithTurnUnit(null);
    }

    public Collection<ISourceSinkDefinition> getSinkDefinitions() {
        return this.sinkDefinitions;
    }

    public Abstraction getAbstraction() {
        return this.abstraction;
    }

    public Stmt getSinkStmt() {
        return this.sinkStmt;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.abstraction == null ? 0 : this.abstraction.hashCode());
        result = 31 * result + (this.sinkDefinitions == null ? 0 : this.sinkDefinitions.hashCode());
        result = 31 * result + (this.sinkStmt == null ? 0 : this.sinkStmt.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractionAtSink other = (AbstractionAtSink)obj;
        if (this.abstraction == null ? other.abstraction != null : !this.abstraction.equals(other.abstraction)) {
            return false;
        }
        if (this.sinkDefinitions == null ? other.sinkDefinitions != null : !this.sinkDefinitions.equals(other.sinkDefinitions)) {
            return false;
        }
        return !(this.sinkStmt == null ? other.sinkStmt != null : !this.sinkStmt.equals(other.sinkStmt));
    }

    public String toString() {
        return this.abstraction + " at " + this.sinkStmt;
    }
}

