/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data;

import java.util.Arrays;
import java.util.Objects;
import soot.SootField;
import soot.Type;
import soot.jimple.infoflow.data.ContainerContext;

public class AccessPathFragment {
    private final SootField field;
    private final Type fieldType;
    private final ContainerContext[] context;

    public AccessPathFragment(SootField field) {
        this(field, null, null);
    }

    public AccessPathFragment(SootField field, Type fieldType) {
        this(field, fieldType, null);
    }

    public AccessPathFragment(SootField field, Type fieldType, ContainerContext[] context) {
        this.field = field;
        this.fieldType = fieldType == null ? field.getType() : fieldType;
        this.context = context;
    }

    public SootField getField() {
        return this.field;
    }

    public Type getFieldType() {
        return this.fieldType == null ? this.field.getType() : this.fieldType;
    }

    public ContainerContext[] getContext() {
        return this.context;
    }

    public boolean hasContext() {
        return this.context != null;
    }

    public String toString() {
        if (this.hasContext()) {
            StringBuilder sb = new StringBuilder(this.field.toString());
            sb.append("@[");
            for (ContainerContext c : this.context) {
                sb.append(c).append(",");
            }
            sb.append("]");
            return sb.toString();
        }
        return this.field.toString();
    }

    public boolean isValid() {
        return this.fieldType != null;
    }

    public static AccessPathFragment[] createFragmentArray(SootField[] fields, Type[] fieldTypes, ContainerContext[][] contexts) {
        if (fields == null || fields.length == 0) {
            return null;
        }
        AccessPathFragment[] fragments = new AccessPathFragment[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            fragments[i] = new AccessPathFragment(fields[i], fieldTypes == null ? null : fieldTypes[i], contexts == null ? null : contexts[i]);
        }
        return fragments;
    }

    public int hashCode() {
        int result = Objects.hash(this.field, this.fieldType);
        result = 31 * result + Arrays.hashCode(this.context);
        return result;
    }

    public int hashCodeWithoutContext() {
        return Objects.hash(this.field, this.fieldType);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathFragment other = (AccessPathFragment)obj;
        return Arrays.equals(this.context, other.context) && Objects.equals(this.field, other.field) && Objects.equals(this.fieldType, other.fieldType);
    }

    public boolean equalsWithoutContext(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AccessPathFragment other = (AccessPathFragment)obj;
        return Objects.equals(this.field, other.field) && Objects.equals(this.fieldType, other.fieldType);
    }

    public AccessPathFragment copyWithNewType(Type newType) {
        return new AccessPathFragment(this.field, newType, this.context);
    }

    public AccessPathFragment copyWithNewContext(ContainerContext[] newContext) {
        return new AccessPathFragment(this.field, this.fieldType, newContext);
    }
}

