/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.accessPaths;

import java.util.Arrays;
import soot.Value;
import soot.jimple.infoflow.data.AccessPathFragment;
import soot.jimple.infoflow.data.accessPaths.IAccessPathReductionStrategy;

public class SameFieldReductionStrategy
implements IAccessPathReductionStrategy {
    @Override
    public AccessPathFragment[] reduceAccessPath(Value base, AccessPathFragment[] fragments) {
        for (int bucketStart = fragments.length - 2; bucketStart >= 0; --bucketStart) {
            int repeatPos = -1;
            for (int i = bucketStart + 1; i < fragments.length; ++i) {
                if (fragments[i].getField() != fragments[bucketStart].getField() || !Arrays.equals(fragments[i].getContext(), fragments[bucketStart].getContext())) continue;
                repeatPos = i;
                break;
            }
            int repeatLen = repeatPos - bucketStart;
            if (repeatPos < 0) continue;
            boolean matches = true;
            for (int i = 0; i < repeatPos - bucketStart; ++i) {
                matches &= repeatPos + i < fragments.length && fragments[bucketStart + i].getField() == fragments[repeatPos + i].getField();
            }
            if (!matches) continue;
            AccessPathFragment[] newFragments = new AccessPathFragment[fragments.length - repeatLen];
            System.arraycopy(fragments, 0, newFragments, 0, bucketStart + 1);
            System.arraycopy(fragments, repeatPos + 1, newFragments, bucketStart + 1, fragments.length - repeatPos - 1);
            fragments = newFragments;
            break;
        }
        return fragments;
    }
}

