/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import java.util.HashSet;
import java.util.Set;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentIdentityHashMultiMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContext;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.ConcurrentAbstractionPathBuilder;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;

public class ContextInsensitivePathBuilder
extends ConcurrentAbstractionPathBuilder {
    private ConcurrentIdentityHashMultiMap<Abstraction, SourceContextAndPath> pathCache = new ConcurrentIdentityHashMultiMap();

    public ContextInsensitivePathBuilder(InfoflowManager manager, InterruptableExecutor executor) {
        super(manager, executor);
    }

    private boolean checkForSource(Abstraction abs, SourceContextAndPath scap) {
        if (abs.getPredecessor() != null) {
            return false;
        }
        assert (abs.getSourceContext() != null);
        assert (abs.getNeighbors() == null);
        SourceContext sourceContext = abs.getSourceContext();
        this.results.addResult(scap.getDefinitions(), scap.getAccessPath(), scap.getStmt(), sourceContext.getDefinitions(), sourceContext.getAccessPath(), sourceContext.getStmt(), sourceContext.getUserData(), scap.getAbstractionPath(), this.manager);
        return true;
    }

    @Override
    protected Runnable getTaintPathTask(AbstractionAtSink abs) {
        SourceContextAndPath scap = new SourceContextAndPath(this.config, abs.getSinkDefinitions(), abs.getAbstraction().getAccessPath(), abs.getSinkStmt());
        scap = scap.extendPath(abs.getAbstraction(), this.config);
        if (this.pathCache.put(abs.getAbstraction(), scap) && !this.checkForSource(abs.getAbstraction(), scap)) {
            return new SourceFindingTask(abs.getAbstraction());
        }
        return null;
    }

    @Override
    protected boolean triggerComputationForNeighbors() {
        return true;
    }

    @Override
    public void runIncrementalPathComputation() {
        HashSet<AbstractionAtSink> incrementalAbs = new HashSet<AbstractionAtSink>();
        for (Abstraction abs : this.pathCache.keySet()) {
            for (SourceContextAndPath scap : this.pathCache.get(abs)) {
                if (abs.getNeighbors() == null || abs.getNeighbors().size() == scap.getNeighborCounter()) continue;
                scap.setNeighborCounter(abs.getNeighbors().size());
                for (Abstraction neighbor : abs.getNeighbors()) {
                    incrementalAbs.add(new AbstractionAtSink(scap.getDefinitions(), neighbor, scap.getStmt()));
                }
            }
        }
        if (!incrementalAbs.isEmpty()) {
            this.computeTaintPaths(incrementalAbs);
        }
    }

    private class SourceFindingTask
    implements Runnable {
        private final Abstraction abstraction;

        public SourceFindingTask(Abstraction abstraction) {
            this.abstraction = abstraction;
        }

        @Override
        public void run() {
            Set<SourceContextAndPath> paths = ContextInsensitivePathBuilder.this.pathCache.get(this.abstraction);
            Abstraction pred = this.abstraction.getPredecessor();
            if (pred != null) {
                for (SourceContextAndPath scap : paths) {
                    if (this.processPredecessor(scap, pred)) {
                        ContextInsensitivePathBuilder.this.scheduleDependentTask(new SourceFindingTask(pred));
                    }
                    if (pred.getNeighbors() == null) continue;
                    for (Abstraction neighbor : pred.getNeighbors()) {
                        if (!this.processPredecessor(scap, neighbor)) continue;
                        ContextInsensitivePathBuilder.this.scheduleDependentTask(new SourceFindingTask(neighbor));
                    }
                }
            }
        }

        private boolean processPredecessor(SourceContextAndPath scap, Abstraction pred) {
            Set<SourceContextAndPath> existingPaths;
            SourceContextAndPath extendedScap = scap.extendPath(pred, ContextInsensitivePathBuilder.this.config);
            if (extendedScap == null) {
                return false;
            }
            ContextInsensitivePathBuilder.this.checkForSource(pred, extendedScap);
            int maxPaths = ContextInsensitivePathBuilder.this.config.getPathConfiguration().getMaxPathsPerAbstraction();
            if (maxPaths > 0 && (existingPaths = ContextInsensitivePathBuilder.this.pathCache.get(pred)) != null && existingPaths.size() > maxPaths) {
                return false;
            }
            return ContextInsensitivePathBuilder.this.pathCache.put(pred, extendedScap);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.abstraction == null ? 0 : this.abstraction.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SourceFindingTask other = (SourceFindingTask)obj;
            return this.abstraction == other.abstraction;
        }
    }
}

