/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.data.pathBuilders;

import heros.solver.CountingThreadPoolExecutor;
import heros.solver.Pair;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Set;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.SourceContextAndPath;
import soot.jimple.infoflow.data.pathBuilders.AbstractAbstractionPathBuilder;
import soot.jimple.infoflow.memory.IMemoryBoundedSolver;
import soot.jimple.infoflow.memory.ISolverTerminationReason;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.util.FastStack;

public class RecursivePathBuilder
extends AbstractAbstractionPathBuilder {
    private final InfoflowResults results;
    private final CountingThreadPoolExecutor executor;
    private static int lastTaskId = 0;

    public RecursivePathBuilder(InfoflowManager manager, CountingThreadPoolExecutor executor) {
        super(manager);
        this.executor = executor;
        this.results = new InfoflowResults(manager.getConfig().getPathAgnosticResults());
    }

    private Set<SourceContextAndPath> getPaths(int taskId, Abstraction curAbs, FastStack<Pair<Stmt, Set<Abstraction>>> callStack) {
        Set callAbs;
        Pair stackTop;
        HashSet<SourceContextAndPath> cacheData = new HashSet<SourceContextAndPath>();
        Pair pair = stackTop = callStack.isEmpty() ? null : (Pair)callStack.peek();
        if (stackTop != null && !(callAbs = (Set)stackTop.getO2()).add(curAbs)) {
            return Collections.emptySet();
        }
        if (curAbs.getSourceContext() != null) {
            SourceContextAndPath sourceAndPath = new SourceContextAndPath(this.config, curAbs.getSourceContext().getDefinitions(), curAbs.getSourceContext().getAccessPath(), curAbs.getSourceContext().getStmt(), curAbs.getSourceContext().getUserData()).extendPath(curAbs);
            cacheData.add(sourceAndPath);
            assert (curAbs.getPredecessor() == null);
        } else {
            FastStack newCallStack = new FastStack();
            newCallStack.addAll(callStack);
            if (curAbs.getCorrespondingCallSite() != null) {
                newCallStack.push((Object)new Pair((Object)curAbs.getCorrespondingCallSite(), Collections.newSetFromMap(new IdentityHashMap())));
            }
            boolean isMethodEnter = curAbs.getCurrentStmt() != null && curAbs.getCurrentStmt().containsInvokeExpr();
            boolean scanPreds = true;
            if (isMethodEnter && !newCallStack.isEmpty()) {
                Object newStackTop;
                Object object = newStackTop = newCallStack.isEmpty() ? null : (Pair)newCallStack.peek();
                if (newStackTop != null && newStackTop.getO1() != null) {
                    if (curAbs.getCurrentStmt() != newStackTop.getO1()) {
                        scanPreds = false;
                    }
                    newCallStack.pop();
                }
            }
            if (scanPreds) {
                for (SourceContextAndPath curScap : this.getPaths(taskId, curAbs.getPredecessor(), (FastStack<Pair<Stmt, Set<Abstraction>>>)newCallStack)) {
                    SourceContextAndPath extendedPath = curScap.extendPath(curAbs, this.config);
                    if (extendedPath == null) continue;
                    cacheData.add(extendedPath);
                }
            }
        }
        if (curAbs.getNeighbors() != null) {
            for (Abstraction nb : curAbs.getNeighbors()) {
                for (SourceContextAndPath path : this.getPaths(taskId, nb, callStack)) {
                    cacheData.add(path);
                }
            }
        }
        return Collections.unmodifiableSet(cacheData);
    }

    private void computeTaintPathsInternal(Set<AbstractionAtSink> res) {
        this.logger.debug("Running path reconstruction");
        this.logger.info("Obtainted {} connections between sources and sinks", (Object)res.size());
        int curResIdx = 0;
        long startTime = System.nanoTime();
        long totalTime = this.manager.getConfig().getPathConfiguration().getPathReconstructionTotalTime();
        for (final AbstractionAtSink abs : res) {
            ++curResIdx;
            long executionNanoTime = System.nanoTime() - startTime;
            if (totalTime > 0L && (double)executionNanoTime / 1.0E9 >= (double)totalTime) {
                this.logger.info("Path Reconstruction has terminated as it exceeds the configured pathReconstructionTotalTime.");
                this.logger.info("The pathReconstructionTotalTime is set to " + totalTime + "seconds.");
                this.logger.info("Now the current resId:" + curResIdx);
                this.logger.info("The number of remaining res:" + (res.size() - curResIdx));
                break;
            }
            this.logger.info("Path Reconstruction has used " + (double)executionNanoTime / 1.0E9 + " seconds");
            this.logger.info(String.format("Building path %d...", curResIdx));
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    FastStack initialStack = new FastStack();
                    initialStack.push((Object)new Pair(null, Collections.newSetFromMap(new IdentityHashMap())));
                    for (SourceContextAndPath context : RecursivePathBuilder.this.getPaths(lastTaskId++, abs.getAbstraction(), (FastStack<Pair<Stmt, Set<Abstraction>>>)initialStack)) {
                        RecursivePathBuilder.this.results.addResult(abs.getSinkDefinitions(), abs.getAbstraction().getAccessPath(), abs.getSinkStmt(), context.getDefinitions(), context.getAccessPath(), context.getStmt(), context.getUserData(), context.getAbstractionPath(), RecursivePathBuilder.this.manager);
                    }
                }
            });
        }
        try {
            this.executor.awaitCompletion();
        }
        catch (InterruptedException ex) {
            this.logger.error("Could not wait for path executor completion: {0}", (Object)ex.getMessage());
            ex.printStackTrace();
        }
        this.executor.shutdown();
        this.logger.debug("Path reconstruction done.");
    }

    @Override
    public void computeTaintPaths(Set<AbstractionAtSink> res) {
        this.computeTaintPathsInternal(res);
    }

    @Override
    public InfoflowResults getResults() {
        return this.results;
    }

    @Override
    public void runIncrementalPathComputation() {
    }

    @Override
    public void forceTerminate(ISolverTerminationReason reason) {
    }

    @Override
    public boolean isTerminated() {
        return false;
    }

    @Override
    public boolean isKilled() {
        return false;
    }

    @Override
    public void reset() {
    }

    @Override
    public void addStatusListener(IMemoryBoundedSolver.IMemoryBoundedSolverStatusNotification listener) {
    }

    @Override
    public ISolverTerminationReason getTerminationReason() {
        return null;
    }
}

