/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.InterproceduralCFG;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.CaughtExceptionRef;
import soot.jimple.DefinitionStmt;
import soot.jimple.InvokeExpr;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.ConcurrentHashSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.nativeCallHandler.INativeCallHandler;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.IPropagationRuleManagerFactory;
import soot.jimple.infoflow.problems.rules.PropagationRuleManager;
import soot.jimple.infoflow.solver.IInfoflowSolver;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.toolkits.ide.DefaultJimpleIFDSTabulationProblem;

public abstract class AbstractInfoflowProblem
extends DefaultJimpleIFDSTabulationProblem<Abstraction, IInfoflowCFG> {
    protected final InfoflowManager manager;
    protected final Map<Unit, Set<Abstraction>> initialSeeds = new HashMap<Unit, Set<Abstraction>>();
    protected ITaintPropagationWrapper taintWrapper;
    protected INativeCallHandler ncHandler;
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    protected Abstraction zeroValue = null;
    protected IInfoflowSolver solver = null;
    protected TaintPropagationHandler taintPropagationHandler = null;
    private ConcurrentHashMap<Unit, CallSite> activationUnitsToCallSites = new ConcurrentHashMap();
    protected final PropagationRuleManager propagationRules;
    protected final TaintPropagationResults results;
    private static Function<? super Unit, ? extends CallSite> createNewCallSite = new Function<Unit, CallSite>(){

        @Override
        public CallSite apply(Unit t) {
            return new CallSite();
        }
    };

    public AbstractInfoflowProblem(InfoflowManager manager, Abstraction zeroValue, IPropagationRuleManagerFactory ruleManagerFactory) {
        super((InterproceduralCFG)manager.getICFG());
        this.manager = manager;
        this.zeroValue = zeroValue == null ? this.createZeroValue() : zeroValue;
        this.results = new TaintPropagationResults(manager);
        this.propagationRules = ruleManagerFactory.createRuleManager(manager, this.zeroValue, this.results);
    }

    public void setSolver(IInfoflowSolver solver) {
        this.solver = solver;
    }

    public void setZeroValue(Abstraction zeroValue) {
        this.zeroValue = zeroValue;
    }

    public boolean followReturnsPastSeeds() {
        return this.manager.getConfig().getSolverConfiguration().isFollowReturnsPastSources();
    }

    public void setTaintWrapper(ITaintPropagationWrapper wrapper) {
        this.taintWrapper = wrapper;
    }

    public void setNativeCallHandler(INativeCallHandler handler) {
        this.ncHandler = handler;
    }

    protected boolean isInitialMethod(SootMethod sm) {
        for (Unit u : this.initialSeeds.keySet()) {
            if (this.interproceduralCFG().getMethodOf(u) != sm) continue;
            return true;
        }
        return false;
    }

    public Map<Unit, Set<Abstraction>> initialSeeds() {
        return this.initialSeeds;
    }

    public boolean autoAddZero() {
        return false;
    }

    public boolean isCallSiteActivatingTaint(Unit callSite, Unit activationUnit) {
        if (!this.manager.getConfig().getFlowSensitiveAliasing()) {
            return false;
        }
        if (activationUnit == null) {
            return false;
        }
        CallSite callSites = this.activationUnitsToCallSites.get(activationUnit);
        if (callSites != null) {
            return callSites.callsites.contains(callSite);
        }
        return false;
    }

    protected boolean registerActivationCallSite(Unit callSite, SootMethod callee, Abstraction activationAbs) {
        if (!this.manager.getConfig().getFlowSensitiveAliasing()) {
            return false;
        }
        Unit activationUnit = activationAbs.getActivationUnit();
        if (activationUnit == null) {
            return false;
        }
        CallSite callSites = this.activationUnitsToCallSites.computeIfAbsent(activationUnit, createNewCallSite);
        if (callSites.callsites.contains(callSite)) {
            return false;
        }
        IInfoflowCFG icfg = (IInfoflowCFG)super.interproceduralCFG();
        if (!activationAbs.isAbstractionActive() && !callee.getActiveBody().getUnits().contains((Object)activationUnit)) {
            Set<SootMethod> cm = callSites.callsiteMethods.get();
            if (cm != null) {
                if (!cm.contains(callee)) {
                    return false;
                }
            } else {
                cm = new HashSet<SootMethod>();
                boolean found = false;
                for (Unit au : callSites.callsites) {
                    cm.add((SootMethod)icfg.getMethodOf(au));
                    if (!callee.getActiveBody().getUnits().contains((Object)au)) continue;
                    found = true;
                    break;
                }
                callSites.callsiteMethods = new SoftReference<Set<SootMethod>>(cm);
                if (!found) {
                    return false;
                }
            }
        }
        return callSites.addCallsite(callSite, icfg);
    }

    public void setActivationUnitsToCallSites(AbstractInfoflowProblem other) {
        this.activationUnitsToCallSites = other.activationUnitsToCallSites;
    }

    public IInfoflowCFG interproceduralCFG() {
        return (IInfoflowCFG)super.interproceduralCFG();
    }

    public void addInitialSeeds(Unit unit, Set<Abstraction> seeds) {
        if (this.initialSeeds.containsKey(unit)) {
            this.initialSeeds.get(unit).addAll(seeds);
        } else {
            this.initialSeeds.put(unit, new HashSet<Abstraction>(seeds));
        }
    }

    public boolean hasInitialSeeds() {
        return !this.initialSeeds.isEmpty();
    }

    public Map<Unit, Set<Abstraction>> getInitialSeeds() {
        return this.initialSeeds;
    }

    public void setTaintPropagationHandler(TaintPropagationHandler handler) {
        this.taintPropagationHandler = handler;
    }

    public TaintPropagationHandler getTaintPropagationHandler() {
        return this.taintPropagationHandler;
    }

    public Abstraction createZeroValue() {
        if (this.zeroValue == null) {
            this.zeroValue = Abstraction.getZeroAbstraction(this.manager.getConfig().getFlowSensitiveAliasing());
        }
        return this.zeroValue;
    }

    protected Abstraction getZeroValue() {
        return this.zeroValue;
    }

    protected boolean isExceptionHandler(Unit u) {
        if (u instanceof DefinitionStmt) {
            DefinitionStmt defStmt = (DefinitionStmt)u;
            return defStmt.getRightOp() instanceof CaughtExceptionRef;
        }
        return false;
    }

    protected Set<Abstraction> notifyOutFlowHandlers(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, TaintPropagationHandler.FlowFunctionType functionType) {
        if (this.taintPropagationHandler != null && outgoing != null && !outgoing.isEmpty()) {
            outgoing = this.taintPropagationHandler.notifyFlowOut(stmt, d1, incoming, outgoing, this.manager, functionType);
        }
        return outgoing;
    }

    public boolean computeValues() {
        return false;
    }

    public InfoflowManager getManager() {
        return this.manager;
    }

    protected boolean isExcluded(SootMethod sm) {
        SootClass declClass;
        if (sm.hasTag("fd_essential_method")) {
            return false;
        }
        if (this.manager.getConfig().getExcludeSootLibraryClasses() && (declClass = sm.getDeclaringClass()) != null && declClass.isLibraryClass()) {
            return true;
        }
        if (this.manager.getConfig().getIgnoreFlowsInSystemPackages() && (declClass = sm.getDeclaringClass()) != null && SystemClassHandler.v().isClassInSystemPackage(declClass)) {
            return true;
        }
        return sm.isConcrete() && !sm.hasActiveBody();
    }

    public TaintPropagationResults getResults() {
        return this.results;
    }

    public PropagationRuleManager getPropagationRules() {
        return this.propagationRules;
    }

    protected boolean hasAnotherReferenceOnBase(InvokeExpr e, Value actualBase, int ignoreIndex) {
        for (int i = 0; i < e.getArgCount(); ++i) {
            if (i == ignoreIndex || e.getArg(i) != actualBase) continue;
            return true;
        }
        return false;
    }

    private static class CallSite {
        public Set<Unit> callsites = new ConcurrentHashSet<Unit>();
        public SoftReference<Set<SootMethod>> callsiteMethods = new SoftReference(new ConcurrentHashSet());

        private CallSite() {
        }

        public boolean addCallsite(Unit callSite, IInfoflowCFG icfg) {
            if (this.callsites.add(callSite)) {
                Set<SootMethod> c = this.callsiteMethods.get();
                if (c == null) {
                    c = new ConcurrentHashSet<SootMethod>();
                    this.callsiteMethods = new SoftReference<Set<SootMethod>>(c);
                }
                c.add((SootMethod)icfg.getMethodOf(callSite));
                return true;
            }
            return false;
        }
    }
}

