/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.Identity;
import heros.flowfunc.KillAll;
import heros.solver.PathEdge;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.PrimType;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.BinopExpr;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.UnopExpr;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.callmappers.CallerCalleeManager;
import soot.jimple.infoflow.callmappers.ICallerCalleeArgumentMapper;
import soot.jimple.infoflow.collect.MutableTwoElementSet;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.rules.EmptyPropagationRuleManagerFactory;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;

public class BackwardsAliasProblem
extends AbstractInfoflowProblem {
    private static final boolean DEBUG_PRINT = false;

    public BackwardsAliasProblem(InfoflowManager manager) {
        super(manager, null, EmptyPropagationRuleManagerFactory.INSTANCE);
    }

    protected FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            private Abstraction checkAbstraction(Abstraction abs) {
                if (abs == null) {
                    return null;
                }
                if (!abs.getAccessPath().isStaticFieldRef() ? abs.getAccessPath().getBaseType() instanceof PrimType : abs.getAccessPath().getFirstFieldType() instanceof PrimType) {
                    return null;
                }
                return abs;
            }

            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit srcUnit, Unit destUnit) {
                if (!(srcUnit instanceof DefinitionStmt)) {
                    return Identity.v();
                }
                final DefinitionStmt defStmt = (DefinitionStmt)srcUnit;
                return new SolverNormalFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        assert (!source.getAccessPath().isEmpty());
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(srcUnit, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                        if (source.getTurnUnit() == srcUnit) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(srcUnit, d1, source, null, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                        Set<Abstraction> res = this.computeAliases(defStmt, d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(srcUnit, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                    }

                    private Set<Abstraction> computeAliases(DefinitionStmt defStmt2, Abstraction d1, Abstraction source) {
                        boolean fieldAliases;
                        if (defStmt2 instanceof IdentityStmt) {
                            return Collections.singleton(source);
                        }
                        if (!(defStmt2 instanceof AssignStmt)) {
                            return null;
                        }
                        MutableTwoElementSet<Abstraction> res = new MutableTwoElementSet<Abstraction>();
                        AssignStmt assignStmt = (AssignStmt)defStmt2;
                        Value leftOp = assignStmt.getLeftOp();
                        Value rightOp = assignStmt.getRightOp();
                        Value leftVal = BaseSelector.selectBase(leftOp, false);
                        Value rightVal = BaseSelector.selectBase(rightOp, false);
                        AccessPath ap = source.getAccessPath();
                        Local sourceBase = ap.getPlainValue();
                        Type rightType = rightOp.getType();
                        boolean handoverLeftValue = false;
                        boolean cutSubfield = false;
                        boolean leftSideOverwritten = false;
                        if (leftOp instanceof StaticFieldRef) {
                            if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && ap.firstFieldMatches(((StaticFieldRef)leftOp).getField())) {
                                handoverLeftValue = true;
                                cutSubfield = true;
                            }
                        } else if (leftOp instanceof InstanceFieldRef) {
                            Object mappedAp;
                            InstanceFieldRef instRef = (InstanceFieldRef)leftOp;
                            if (instRef.getBase() == sourceBase && (mappedAp = Aliasing.getReferencedAPBase(ap, new SootField[]{instRef.getField()}, BackwardsAliasProblem.this.manager)) != null) {
                                handoverLeftValue = true;
                                cutSubfield = true;
                                if (!((AccessPath)mappedAp).equals(ap)) {
                                    ap = mappedAp;
                                }
                            }
                        } else if (leftVal == sourceBase) {
                            handoverLeftValue = leftOp instanceof ArrayRef && ap.getArrayTaintType() != AccessPath.ArrayTaintType.Length;
                            boolean bl = leftSideOverwritten = !handoverLeftValue;
                        }
                        if (handoverLeftValue) {
                            Abstraction newAbs = null;
                            if (rightVal instanceof Constant) {
                                if (BackwardsAliasProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
                                    newAbs = source.deriveConditionalUpdate((Stmt)assignStmt);
                                    for (Unit pred : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(srcUnit)) {
                                        this.handOver(d1, pred, newAbs);
                                    }
                                }
                            } else {
                                AccessPath newAp = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, rightOp, rightType, cutSubfield);
                                newAbs = source.deriveNewAbstraction(newAp, (Stmt)assignStmt);
                            }
                            if (newAbs != null && !newAbs.equals(source)) {
                                for (Unit pred : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(srcUnit)) {
                                    this.handOver(d1, pred, newAbs);
                                }
                            }
                        }
                        if (leftSideOverwritten) {
                            return null;
                        }
                        res.add(source);
                        if (rightOp instanceof BinopExpr || rightOp instanceof UnopExpr || rightOp instanceof NewArrayExpr) {
                            return res;
                        }
                        boolean localAliases = (leftOp instanceof Local || leftOp instanceof ArrayRef) && !(leftOp.getType() instanceof PrimType);
                        boolean bl = fieldAliases = leftOp instanceof FieldRef && !(((FieldRef)leftOp).getField().getType() instanceof PrimType);
                        if ((localAliases || fieldAliases) && !(rightVal.getType() instanceof PrimType)) {
                            AccessPath newAp;
                            Abstraction newAbs;
                            boolean addLeftValue = false;
                            boolean cutFirstFieldLeft = false;
                            Type leftType = null;
                            boolean createNewVal = false;
                            if (rightVal instanceof StaticFieldRef) {
                                if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && ap.firstFieldMatches(((StaticFieldRef)rightVal).getField())) {
                                    addLeftValue = true;
                                }
                            } else if (rightVal instanceof InstanceFieldRef) {
                                AccessPath mappedAp;
                                InstanceFieldRef instRef = (InstanceFieldRef)rightVal;
                                if (instRef.getBase() == sourceBase && ap.isInstanceFieldRef() && (mappedAp = Aliasing.getReferencedAPBase(ap, new SootField[]{instRef.getField()}, BackwardsAliasProblem.this.manager)) != null) {
                                    addLeftValue = true;
                                    cutFirstFieldLeft = true;
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                        source = source.deriveNewAbstraction(mappedAp, null);
                                    }
                                }
                            } else if (rightVal == sourceBase) {
                                addLeftValue = true;
                                leftType = ap.getBaseType();
                                if (rightOp instanceof ArrayRef) {
                                    leftType = ((ArrayType)leftType).getElementType();
                                } else if (leftOp instanceof ArrayRef) {
                                    ArrayRef arrayRef = (ArrayRef)leftOp;
                                    leftType = TypeUtils.buildArrayOrAddDimension(leftType, (Type)arrayRef.getType().getArrayType());
                                } else if (!BackwardsAliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath().getBaseType(), leftOp.getType())) {
                                    return null;
                                }
                                if (rightVal instanceof CastExpr) {
                                    CastExpr ce = (CastExpr)rightOp;
                                    if (!BackwardsAliasProblem.this.manager.getHierarchy().canStoreType(leftType, ce.getCastType())) {
                                        leftType = ce.getCastType();
                                    }
                                } else if (rightVal instanceof InstanceOfExpr) {
                                    addLeftValue = false;
                                }
                            }
                            if (addLeftValue && (newAbs = this.checkAbstraction(source.deriveNewAbstraction(newAp = createNewVal ? BackwardsAliasProblem.this.manager.getAccessPathFactory().createAccessPath(leftVal, true) : BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, leftOp, leftType, cutFirstFieldLeft), (Stmt)assignStmt))) != null && newAbs != source) {
                                if (rightVal instanceof StaticFieldRef && BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                    BackwardsAliasProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                                } else {
                                    res.add(newAbs);
                                }
                            }
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getCallFlowFunction(final Unit callSite, final SootMethod dest) {
                if (!dest.hasActiveBody()) {
                    BackwardsAliasProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)callSite, (Object)dest);
                    return KillAll.v();
                }
                if (!(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt callStmt = (Stmt)callSite;
                final InvokeExpr ie = callStmt.containsInvokeExpr() ? callStmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isSink = callStmt.hasTag("fd_sink");
                final boolean isSource = callStmt.hasTag("fd_source");
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(BackwardsAliasProblem.this.manager, callStmt, dest);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn((Unit)callStmt, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if (source.getTurnUnit() == callSite) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, null, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers((Unit)callStmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        AccessPath accessPath;
                        Abstraction abs;
                        Local sourceBase;
                        Value callBase;
                        Abstraction abs2;
                        if (!BackwardsAliasProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!BackwardsAliasProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintWrapper != null && BackwardsAliasProblem.this.taintWrapper.isExclusive(callStmt, source)) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !BackwardsAliasProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs2 = this.checkAbstraction(source.deriveNewAbstraction(source.getAccessPath(), callStmt))) != null) {
                            res.add(abs2);
                        }
                        if (!(source.getAccessPath().isStaticFieldRef() || dest.isStatic() || (callBase = mapper.getCallerValueOfCalleeParameter(ie, -1)) == null || callBase != (sourceBase = source.getAccessPath().getPlainValue()) || !BackwardsAliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass()) || !isReflectiveCallSite && BackwardsAliasProblem.this.hasAnotherReferenceOnBase(ie, (Value)sourceBase, mapper.getCallerIndexOfCalleeParameter(-1)) || (abs = this.checkAbstraction(source.deriveNewAbstraction(accessPath = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)thisLocal), (Stmt)callSite))) == null)) {
                            res.add(abs);
                        }
                        if (ie != null && dest.getParameterCount() > 0) {
                            for (int i = 0; i < ie.getArgCount(); ++i) {
                                int mappedIndex;
                                if (ie.getArg(i) != source.getAccessPath().getPlainValue() || (mappedIndex = mapper.getCalleeIndexOfCallerParameter(i)) == -3) continue;
                                if (mappedIndex == -2) {
                                    for (Local param : paramLocals) {
                                        AccessPath ap2 = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)param, null, false);
                                        Abstraction abs3 = this.checkAbstraction(source.deriveNewAbstraction(ap2, callStmt));
                                        if (abs3 == null) continue;
                                        res.add(abs3);
                                    }
                                    continue;
                                }
                                AccessPath accessPath2 = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)paramLocals[i]);
                                abs = this.checkAbstraction(source.deriveNewAbstraction(accessPath2, callStmt));
                                if (abs == null) continue;
                                res.add(abs);
                            }
                        }
                        for (Abstraction d3 : res) {
                            BackwardsAliasProblem.this.manager.getMainSolver().injectContext(BackwardsAliasProblem.this.solver, dest, d3, callSite, source, d1);
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitStmt, final Unit returnSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt callStmt = (Stmt)callSite;
                final InvokeExpr ie = callStmt != null && callStmt.containsInvokeExpr() ? callStmt.getInvokeExpr() : null;
                final ReturnStmt returnStmt = exitStmt instanceof ReturnStmt ? (ReturnStmt)exitStmt : null;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(BackwardsAliasProblem.this.manager, callStmt, callee);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction calleeD1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (callSite == null) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn((Unit)callStmt, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        if (source.getTurnUnit() == callSite) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, calleeD1, source, null, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(exitStmt, calleeD1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source) {
                        AccessPath ap;
                        Abstraction abs;
                        Value callBase;
                        Local sourceBase;
                        HashSet<Abstraction> res = new HashSet<Abstraction>();
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            res.add(source);
                            return res;
                        }
                        if (returnStmt != null && callStmt instanceof AssignStmt) {
                            AccessPath ap2;
                            Abstraction abs2;
                            Value retLocal = returnStmt.getOp();
                            DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                            Value leftOp = defnStmt.getLeftOp();
                            if (retLocal == source.getAccessPath().getPlainValue() && !BackwardsAliasProblem.this.isExceptionHandler(returnSite) && (abs2 = this.checkAbstraction(source.deriveNewAbstraction(ap2 = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), leftOp), (Stmt)exitStmt))) != null) {
                                res.add(abs2);
                            }
                        }
                        if (!callee.isStatic() && thisLocal == (sourceBase = source.getAccessPath().getPlainValue()) && BackwardsAliasProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && (callBase = mapper.getCallerValueOfCalleeParameter(ie, -1)) != null && (isReflectiveCallSite || !BackwardsAliasProblem.this.hasAnotherReferenceOnBase(ie, (Value)sourceBase, mapper.getCallerIndexOfCalleeParameter(-1))) && (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), callBase, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) != null) {
                            res.add(abs);
                        }
                        if (ie != null) {
                            for (int i = 0; i < callee.getParameterCount(); ++i) {
                                Value originalCallArg;
                                if (source.getAccessPath().getPlainValue() != paramLocals[i] || this.isPrimitiveOrStringBase(source) || (originalCallArg = mapper.getCallerValueOfCalleeParameter(ie, i)) == null) continue;
                                if (callSite instanceof DefinitionStmt && !BackwardsAliasProblem.this.isExceptionHandler(returnSite)) {
                                    DefinitionStmt defnStmt = (DefinitionStmt)callSite;
                                    Value leftOp = defnStmt.getLeftOp();
                                    originalCallArg = defnStmt.getInvokeExpr().getArg(i);
                                    if (originalCallArg == leftOp) continue;
                                }
                                if (BackwardsAliasProblem.this.interproceduralCFG().methodWritesValue(callee, paramLocals[i]) || !AccessPath.canContainValue(originalCallArg) || !isReflectiveCallSite && !BackwardsAliasProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), originalCallArg.getType()) || (abs = this.checkAbstraction(source.deriveNewAbstraction(ap = BackwardsAliasProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), originalCallArg, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), (Stmt)exitStmt))) == null) continue;
                                res.add(abs);
                            }
                        }
                        if (res.isEmpty()) {
                            return null;
                        }
                        for (Abstraction abs3 : res) {
                            if (abs3 == source) continue;
                            abs3.setCorrespondingCallSite((Stmt)callSite);
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit callSite, Unit returnSite) {
                if (!(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt callStmt = (Stmt)callSite;
                InvokeExpr invExpr = callStmt.getInvokeExpr();
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final boolean isSource = BackwardsAliasProblem.this.manager.getSourceSinkManager() != null && BackwardsAliasProblem.this.manager.getSourceSinkManager().getSourceInfo(callStmt, BackwardsAliasProblem.this.manager) != null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (source == BackwardsAliasProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (BackwardsAliasProblem.this.taintPropagationHandler != null) {
                            BackwardsAliasProblem.this.taintPropagationHandler.notifyFlowIn(callSite, source, BackwardsAliasProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        if (source.getTurnUnit() != null && (source.getTurnUnit() == callSite || BackwardsAliasProblem.this.manager.getICFG().getCalleesOfCallAt(callSite).stream().anyMatch(m -> BackwardsAliasProblem.this.manager.getICFG().getMethodOf(source.getTurnUnit()) == m))) {
                            return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, null, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsAliasProblem.this.notifyOutFlowHandlers(callSite, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        if (BackwardsAliasProblem.this.taintWrapper != null) {
                            Set<Abstraction> wrapperAliases;
                            if (BackwardsAliasProblem.this.taintWrapper.isExclusive(callStmt, source)) {
                                this.handOver(d1, callSite, source);
                            }
                            if ((wrapperAliases = BackwardsAliasProblem.this.taintWrapper.getAliasesForMethod(callStmt, d1, source)) != null && !wrapperAliases.isEmpty()) {
                                HashSet<Abstraction> passOnSet = new HashSet<Abstraction>(wrapperAliases.size());
                                for (Abstraction abs : wrapperAliases) {
                                    passOnSet.add(abs);
                                    if (abs != source) {
                                        abs.setCorrespondingCallSite(callStmt);
                                    }
                                    for (Unit u : BackwardsAliasProblem.this.manager.getICFG().getPredsOf(callSite)) {
                                        this.handOver(d1, u, abs);
                                    }
                                }
                                return passOnSet;
                            }
                        }
                        if (BackwardsAliasProblem.this.interproceduralCFG().getCalleesOfCallAt(callSite).isEmpty()) {
                            return Collections.singleton(source);
                        }
                        if (BackwardsAliasProblem.this.isExcluded(callee)) {
                            return Collections.singleton(source);
                        }
                        if (BackwardsAliasProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && BackwardsAliasProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        if (!callee.isNative()) {
                            InstanceInvokeExpr inv;
                            if (callStmt.getInvokeExpr() instanceof InstanceInvokeExpr && (inv = (InstanceInvokeExpr)callStmt.getInvokeExpr()).getBase() == source.getAccessPath().getPlainValue()) {
                                return null;
                            }
                            if (Arrays.stream(callArgs).anyMatch(arg -> !this.isPrimitiveOrStringBase(source) && arg == source.getAccessPath().getPlainValue())) {
                                if (isSource) {
                                    this.handOver(d1, callSite, source);
                                }
                                return null;
                            }
                        } else {
                            for (Value arg2 : callArgs) {
                                if (arg2 != source.getAccessPath().getPlainValue()) continue;
                                Abstraction newSource = source.deriveNewAbstractionWithTurnUnit(callSite);
                                this.handOver(d1, callSite, newSource);
                                return null;
                            }
                        }
                        return Collections.singleton(source);
                    }
                };
            }

            private boolean isPrimitiveOrStringBase(Abstraction abs) {
                Type t = abs.getAccessPath().getBaseType();
                return t instanceof PrimType || TypeUtils.isStringType(t) && !abs.getAccessPath().getCanHaveImmutableAliases();
            }

            private void handOver(Abstraction d1, Unit unit, Abstraction in) {
                in = in.getActiveCopy();
                if (BackwardsAliasProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
                    List<Unit> condUnits = BackwardsAliasProblem.this.manager.getOriginalICFG().getConditionalBranchesInterprocedural(unit);
                    for (Unit condUnit : condUnits) {
                        Abstraction abs = in.deriveNewAbstractionWithDominator(condUnit);
                        if (abs == null) continue;
                        BackwardsAliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)unit, (Object)abs));
                    }
                } else {
                    BackwardsAliasProblem.this.manager.getMainSolver().processEdge((PathEdge<Unit, Abstraction>)new PathEdge((Object)d1, (Object)unit, (Object)in));
                }
            }
        };
    }
}

