/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import heros.FlowFunction;
import heros.FlowFunctions;
import heros.flowfunc.KillAll;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import soot.ArrayType;
import soot.Local;
import soot.NullType;
import soot.PrimType;
import soot.SootMethod;
import soot.Type;
import soot.Unit;
import soot.Value;
import soot.jimple.AnyNewExpr;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.CastExpr;
import soot.jimple.Constant;
import soot.jimple.FieldRef;
import soot.jimple.InstanceFieldRef;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InstanceOfExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LengthExpr;
import soot.jimple.NewArrayExpr;
import soot.jimple.ReturnStmt;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.callmappers.CallerCalleeManager;
import soot.jimple.infoflow.callmappers.ICallerCalleeArgumentMapper;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.problems.rules.IPropagationRuleManagerFactory;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.functions.SolverCallFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverCallToReturnFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverNormalFlowFunction;
import soot.jimple.infoflow.solver.functions.SolverReturnFlowFunction;
import soot.jimple.infoflow.typing.TypeUtils;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class BackwardsInfoflowProblem
extends AbstractInfoflowProblem {
    public BackwardsInfoflowProblem(InfoflowManager manager, Abstraction zeroValue, IPropagationRuleManagerFactory ruleManagerFactory) {
        super(manager, zeroValue, ruleManagerFactory);
    }

    protected FlowFunctions<Unit, Abstraction, SootMethod> createFlowFunctionsFactory() {
        return new FlowFunctions<Unit, Abstraction, SootMethod>(){

            public FlowFunction<Abstraction> getNormalFlowFunction(final Unit srcUnit, final Unit destUnit) {
                if (!(srcUnit instanceof Stmt)) {
                    return KillAll.v();
                }
                final Aliasing aliasing = BackwardsInfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                return new SolverNormalFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(srcUnit, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(srcUnit, d1, source, res, TaintPropagationHandler.FlowFunctionType.NormalFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res = null;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        if (BackwardsInfoflowProblem.this.propagationRules != null) {
                            res = BackwardsInfoflowProblem.this.propagationRules.applyNormalFlowFunction(d1, source, (Stmt)srcUnit, (Stmt)destUnit, killSource, killAll);
                        }
                        if (killAll.value) {
                            return null;
                        }
                        if (res == null) {
                            res = new HashSet<Abstraction>();
                        }
                        if (source.getAccessPath().isEmpty()) {
                            if (killSource.value) {
                                res.remove(source);
                            }
                            return res;
                        }
                        if (!(srcUnit instanceof AssignStmt)) {
                            return res;
                        }
                        AssignStmt assignStmt = (AssignStmt)srcUnit;
                        Value leftVal = assignStmt.getLeftOp();
                        Value rightOp = assignStmt.getRightOp();
                        Value[] rightVals = BaseSelector.selectBaseList(rightOp, true);
                        AccessPath ap = source.getAccessPath();
                        Local sourceBase = ap.getPlainValue();
                        boolean keepSource = false;
                        for (Value rightVal : rightVals) {
                            AccessPath newAp;
                            Abstraction newAbs;
                            boolean isImplicit;
                            AccessPath newAp2;
                            Abstraction newAbs2;
                            boolean addLeftValue = false;
                            boolean cutFirstFieldLeft = false;
                            boolean createNewVal = false;
                            Type leftType = null;
                            if (rightVal instanceof StaticFieldRef) {
                                StaticFieldRef staticRef = (StaticFieldRef)rightVal;
                                AccessPath mappedAp = aliasing.mayAlias(ap, (Value)staticRef);
                                if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && mappedAp != null) {
                                    addLeftValue = true;
                                    cutFirstFieldLeft = true;
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                        source = source.deriveNewAbstraction(ap, null);
                                    }
                                }
                            } else if (rightVal instanceof InstanceFieldRef) {
                                InstanceFieldRef instRef = (InstanceFieldRef)rightVal;
                                if (instRef.getBase().getType() instanceof NullType) {
                                    return null;
                                }
                                AccessPath mappedAp = aliasing.mayAlias(ap, (Value)instRef);
                                if (mappedAp != null) {
                                    addLeftValue = true;
                                    boolean bl = cutFirstFieldLeft = mappedAp.getFragmentCount() > 0 && mappedAp.getFirstField() == instRef.getField();
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                    }
                                } else if (aliasing.mayAlias(instRef.getBase(), (Value)sourceBase) && ap.getTaintSubFields() && ap.getFragmentCount() == 0) {
                                    addLeftValue = true;
                                    createNewVal = true;
                                }
                            } else if (rightVal instanceof ArrayRef) {
                                if (!BackwardsInfoflowProblem.this.getManager().getConfig().getEnableArrayTracking() || ap.getArrayTaintType() == AccessPath.ArrayTaintType.Length) continue;
                                ArrayRef arrayRef = (ArrayRef)rightVal;
                                if (BackwardsInfoflowProblem.this.getManager().getConfig().getImplicitFlowMode().trackArrayAccesses()) {
                                    if (arrayRef.getIndex() == sourceBase) {
                                        addLeftValue = true;
                                        leftType = ((ArrayType)arrayRef.getBase().getType()).getElementType();
                                    }
                                } else if (aliasing.mayAlias(arrayRef.getBase(), (Value)sourceBase)) {
                                    addLeftValue = true;
                                    leftType = ((ArrayType)arrayRef.getBase().getType()).getElementType();
                                }
                            }
                            if (rightVal == sourceBase) {
                                addLeftValue = true;
                                leftType = ap.getBaseType();
                                if (leftVal instanceof ArrayRef) {
                                    ArrayRef arrayRef = (ArrayRef)leftVal;
                                    leftType = TypeUtils.buildArrayOrAddDimension(leftType, (Type)arrayRef.getType().getArrayType());
                                } else if (rightOp instanceof InstanceOfExpr) {
                                    createNewVal = true;
                                } else if (rightOp instanceof LengthExpr) {
                                    if (ap.getArrayTaintType() == AccessPath.ArrayTaintType.Contents) {
                                        addLeftValue = false;
                                    }
                                    createNewVal = true;
                                } else if (rightOp instanceof NewArrayExpr) {
                                    createNewVal = true;
                                } else if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), leftVal.getType())) {
                                    return null;
                                }
                                if (rightVal instanceof CastExpr) {
                                    CastExpr ce = (CastExpr)rightOp;
                                    if (!BackwardsInfoflowProblem.this.manager.getHierarchy().canStoreType(leftType, ce.getCastType())) {
                                        leftType = ce.getCastType();
                                    }
                                }
                            }
                            if (addLeftValue && (newAbs2 = source.deriveNewAbstraction(newAp2 = createNewVal ? BackwardsInfoflowProblem.this.manager.getAccessPathFactory().createAccessPath(leftVal, true) : BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, leftVal, leftType, cutFirstFieldLeft), (Stmt)assignStmt)) != null && aliasing.canHaveAliasesRightSide((Stmt)assignStmt, leftVal, newAbs2)) {
                                for (Unit pred : BackwardsInfoflowProblem.this.manager.getICFG().getPredsOf(srcUnit)) {
                                    aliasing.computeAliases(d1, (Stmt)pred, leftVal, Collections.singleton(newAbs2), (SootMethod)BackwardsInfoflowProblem.this.interproceduralCFG().getMethodOf(pred), newAbs2);
                                }
                            }
                            boolean addRightValue = false;
                            boolean cutFirstField = false;
                            Type rightType = null;
                            if (leftVal instanceof StaticFieldRef) {
                                StaticFieldRef staticRef = (StaticFieldRef)leftVal;
                                mappedAp = aliasing.mayAlias(ap, (Value)staticRef);
                                if (BackwardsInfoflowProblem.this.getManager().getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && mappedAp != null) {
                                    addRightValue = true;
                                    cutFirstField = true;
                                    rightType = mappedAp.getFirstFieldType();
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                        source = source.deriveNewAbstraction(ap, null);
                                    }
                                }
                            } else if (leftVal instanceof InstanceFieldRef) {
                                InstanceFieldRef instRef = (InstanceFieldRef)leftVal;
                                if (instRef.getBase().getType() instanceof NullType) {
                                    return null;
                                }
                                mappedAp = aliasing.mayAlias(ap, (Value)instRef);
                                if (mappedAp != null) {
                                    addRightValue = true;
                                    cutFirstField = mappedAp.getFragmentCount() > 0 && mappedAp.getFirstField() == instRef.getField();
                                    rightType = mappedAp.getFirstFieldType();
                                    if (!mappedAp.equals(ap)) {
                                        ap = mappedAp;
                                        source = source.deriveNewAbstraction(ap, null);
                                    }
                                } else if (aliasing.mayAlias(instRef.getBase(), (Value)sourceBase) && ap.getTaintSubFields() && ap.getFragmentCount() == 0) {
                                    addRightValue = true;
                                    rightType = instRef.getField().getType();
                                    keepSource = true;
                                }
                            } else if (leftVal instanceof ArrayRef) {
                                if (!BackwardsInfoflowProblem.this.getManager().getConfig().getEnableArrayTracking() || ap.getArrayTaintType() == AccessPath.ArrayTaintType.Length) continue;
                                ArrayRef arrayRef = (ArrayRef)leftVal;
                                if (BackwardsInfoflowProblem.this.getManager().getConfig().getImplicitFlowMode().trackArrayAccesses()) {
                                    if (arrayRef.getIndex() == sourceBase) {
                                        addRightValue = true;
                                        rightType = ((ArrayType)arrayRef.getBase().getType()).getElementType();
                                    }
                                } else if (aliasing.mayAlias(arrayRef.getBase(), (Value)sourceBase)) {
                                    addRightValue = true;
                                    rightType = ((ArrayType)arrayRef.getBase().getType()).getElementType();
                                    keepSource = true;
                                }
                            } else if (aliasing.mayAlias(leftVal, (Value)sourceBase)) {
                                if (rightOp instanceof InstanceOfExpr) {
                                    rightType = rightVal.getType();
                                } else if (rightOp instanceof CastExpr) {
                                    CastExpr ce = (CastExpr)rightOp;
                                    if (!BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(ce.getCastType(), rightVal.getType())) {
                                        return null;
                                    }
                                }
                                if (rightOp instanceof InstanceOfExpr && BackwardsInfoflowProblem.this.manager.getConfig().getEnableInstanceOfTainting()) {
                                    addRightValue = true;
                                } else {
                                    boolean bl = addRightValue = !(rightOp instanceof LengthExpr) && !(rightOp instanceof ArrayRef) && !(rightOp instanceof InstanceOfExpr);
                                }
                            }
                            if (!addRightValue) continue;
                            if (!keepSource) {
                                res.remove(source);
                            }
                            boolean bl = isImplicit = source.getDominator() != null;
                            if (isImplicit) {
                                res.add(source.deriveConditionalUpdate((Stmt)assignStmt));
                            }
                            if (rightVal instanceof Constant || rightOp instanceof AnyNewExpr || (newAbs = source.deriveNewAbstraction(newAp = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(ap, rightVal, rightType, cutFirstField), (Stmt)assignStmt)) == null) continue;
                            if (rightVal instanceof StaticFieldRef && BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.ContextFlowInsensitive) {
                                BackwardsInfoflowProblem.this.manager.getGlobalTaintManager().addToGlobalTaintState(newAbs);
                                continue;
                            }
                            this.enterConditional(newAbs, (Unit)assignStmt, destUnit);
                            if (this.isPrimitiveOrStringBase(source)) {
                                newAbs = newAbs.deriveNewAbstractionWithTurnUnit(srcUnit);
                            } else if (leftVal instanceof FieldRef && this.isPrimitiveOrStringType(((FieldRef)leftVal).getField().getType()) && !ap.getCanHaveImmutableAliases()) {
                                newAbs = newAbs.deriveNewAbstractionWithTurnUnit(srcUnit);
                            } else if (aliasing.canHaveAliasesRightSide((Stmt)assignStmt, rightVal, newAbs)) {
                                for (Unit pred : BackwardsInfoflowProblem.this.manager.getICFG().getPredsOf(assignStmt)) {
                                    aliasing.computeAliases(d1, (Stmt)pred, rightVal, res, (SootMethod)BackwardsInfoflowProblem.this.interproceduralCFG().getMethodOf(pred), newAbs);
                                }
                            }
                            res.add(newAbs);
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getCallFlowFunction(final Unit callStmt, final SootMethod dest) {
                if (!dest.hasActiveBody()) {
                    BackwardsInfoflowProblem.this.logger.debug("Call skipped because target has no body: {} -> {}", (Object)callStmt, (Object)dest);
                    return KillAll.v();
                }
                final Aliasing aliasing = BackwardsInfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                if (!(callStmt instanceof Stmt)) {
                    return KillAll.v();
                }
                final Stmt stmt = (Stmt)callStmt;
                final InvokeExpr ie = stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Local[] paramLocals = dest.getActiveBody().getParameterLocals().toArray(new Local[0]);
                final Local thisLocal = dest.isStatic() ? null : dest.getActiveBody().getThisLocal();
                final boolean isSink = stmt.hasTag("fd_sink");
                final boolean isSource = stmt.hasTag("fd_source");
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(BackwardsInfoflowProblem.this.manager, stmt, dest);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverCallFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        Set<Abstraction> res;
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn((Unit)stmt, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                        }
                        if ((res = this.computeTargetsInternal(d1, source)) != null) {
                            for (Abstraction abs : res) {
                                aliasing.getAliasingStrategy().injectCallingContext(abs, BackwardsInfoflowProblem.this.solver, dest, callStmt, source, d1);
                            }
                        }
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers((Unit)stmt, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        AccessPath ap;
                        Abstraction abs;
                        Local sourceBase;
                        Value callBase;
                        Abstraction abs2;
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !BackwardsInfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSources() && isSource) {
                            return null;
                        }
                        if (!BackwardsInfoflowProblem.this.manager.getConfig().getInspectSinks() && isSink) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() == InfoflowConfiguration.StaticFieldTrackingMode.None && dest.isStaticInitializer()) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.isExcluded(dest)) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && !BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(dest, source.getAccessPath().getFirstField()) && !BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldRead(dest, source.getAccessPath().getFirstField())) {
                            return null;
                        }
                        HashSet<Abstraction> res = null;
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        if (BackwardsInfoflowProblem.this.propagationRules != null) {
                            res = BackwardsInfoflowProblem.this.propagationRules.applyCallFlowFunction(d1, source, stmt, dest, killAll);
                        }
                        if (killAll.value) {
                            return null;
                        }
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (callStmt instanceof AssignStmt) {
                            boolean isImplicit;
                            AssignStmt assignStmt = (AssignStmt)callStmt;
                            Value left = assignStmt.getLeftOp();
                            boolean bl = isImplicit = source.getDominator() != null;
                            if (aliasing.mayAlias(left, (Value)source.getAccessPath().getPlainValue()) && !isImplicit) {
                                for (Unit unit : dest.getActiveBody().getUnits()) {
                                    List<Unit> condUnits;
                                    AccessPath ap2;
                                    Abstraction abs3;
                                    ReturnStmt returnStmt;
                                    Value retVal;
                                    if (!(unit instanceof ReturnStmt) || !((retVal = (returnStmt = (ReturnStmt)unit).getOp()) instanceof Local) || !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath().getBaseType(), retVal.getType()) || (abs3 = source.deriveNewAbstraction(ap2 = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), retVal, returnStmt.getOp().getType(), false), stmt)) == null) continue;
                                    if (this.isPrimitiveOrStringBase(source)) {
                                        abs3 = abs3.deriveNewAbstractionWithTurnUnit((Unit)stmt);
                                    }
                                    if (abs3.getDominator() == null && BackwardsInfoflowProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies() && (condUnits = BackwardsInfoflowProblem.this.manager.getICFG().getConditionalBranchIntraprocedural((Unit)returnStmt)).size() >= 1) {
                                        abs3.setDominator(condUnits.get(0));
                                        for (int i = 1; i < condUnits.size(); ++i) {
                                            res.add(abs3.deriveNewAbstractionWithDominator(condUnits.get(i)));
                                        }
                                    }
                                    res.add(abs3);
                                }
                            }
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && (abs2 = source.deriveNewAbstraction(source.getAccessPath(), stmt)) != null) {
                            res.add(abs2);
                        }
                        if (!source.getAccessPath().isStaticFieldRef() && !dest.isStatic() && (callBase = mapper.getCallerValueOfCalleeParameter(ie, -1)) != null && aliasing.mayAlias(callBase, (Value)(sourceBase = source.getAccessPath().getPlainValue())) && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), dest.getDeclaringClass()) && (isReflectiveCallSite || !BackwardsInfoflowProblem.this.hasAnotherReferenceOnBase(ie, (Value)sourceBase, mapper.getCallerIndexOfCalleeParameter(-1))) && (abs = source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)thisLocal), (Stmt)callStmt)) != null) {
                            res.add(abs);
                        }
                        if (ie != null && dest.getParameterCount() > 0) {
                            for (int i = 0; i < ie.getArgCount(); ++i) {
                                int calleeIndex;
                                if (!aliasing.mayAlias(ie.getArg(i), (Value)source.getAccessPath().getPlainValue()) || this.isPrimitiveOrStringBase(source) || !source.getAccessPath().getTaintSubFields() || (calleeIndex = mapper.getCalleeIndexOfCallerParameter(i)) == -3 || !isReflectiveCallSite && BackwardsInfoflowProblem.this.interproceduralCFG().methodWritesValue(dest, (Value)paramLocals[calleeIndex])) continue;
                                if (calleeIndex == -2) {
                                    for (Local param : paramLocals) {
                                        AccessPath ap3 = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)param, null, false);
                                        Abstraction abs4 = source.deriveNewAbstraction(ap3, stmt);
                                        if (abs4 == null) continue;
                                        res.add(abs4);
                                    }
                                    continue;
                                }
                                AccessPath ap4 = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), (Value)paramLocals[i]);
                                abs = source.deriveNewAbstraction(ap4, stmt);
                                if (abs == null) continue;
                                res.add(abs);
                            }
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getReturnFlowFunction(final Unit callSite, final SootMethod callee, final Unit exitSite, final Unit returnSite) {
                if (callSite != null && !(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Aliasing aliasing = BackwardsInfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                final Value[] paramLocals = new Value[callee.getParameterCount()];
                for (int i = 0; i < callee.getParameterCount(); ++i) {
                    paramLocals[i] = callee.getActiveBody().getParameterLocal(i);
                }
                final Stmt stmt = (Stmt)callSite;
                final InvokeExpr ie = stmt != null && stmt.containsInvokeExpr() ? stmt.getInvokeExpr() : null;
                final Stmt callStmt = (Stmt)callSite;
                final Stmt exitStmt = (Stmt)exitSite;
                final Local thisLocal = callee.isStatic() ? null : callee.getActiveBody().getThisLocal();
                final ICallerCalleeArgumentMapper mapper = CallerCalleeManager.getMapper(BackwardsInfoflowProblem.this.manager, stmt, callee);
                final boolean isReflectiveCallSite = mapper != null ? mapper.isReflectiveMapper() : false;
                return new SolverReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction source, Abstraction calleeD1, Collection<Abstraction> callerD1s) {
                        if (source == BackwardsInfoflowProblem.this.getZeroValue()) {
                            return null;
                        }
                        if (callSite == null) {
                            return null;
                        }
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn((Unit)stmt, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(source, calleeD1, callerD1s);
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(exitSite, calleeD1, source, res, TaintPropagationHandler.FlowFunctionType.ReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction source, Abstraction calleeD1, Collection<Abstraction> callerD1s) {
                        AccessPath ap;
                        Abstraction abs;
                        Value value;
                        Local sourceBase;
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !BackwardsInfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        Set<Object> res = null;
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        if (BackwardsInfoflowProblem.this.propagationRules != null) {
                            res = BackwardsInfoflowProblem.this.propagationRules.applyReturnFlowFunction(callerD1s, calleeD1, source, (Stmt)exitSite, (Stmt)returnSite, (Stmt)callSite, killAll);
                        }
                        if (killAll.value) {
                            return null;
                        }
                        if (source.getAccessPath().isEmpty()) {
                            return res;
                        }
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef()) {
                            res.add(source);
                        }
                        if (!callee.isStatic() && aliasing.mayAlias((Value)thisLocal, (Value)(sourceBase = source.getAccessPath().getPlainValue())) && BackwardsInfoflowProblem.this.manager.getTypeUtils().hasCompatibleTypesForCall(source.getAccessPath(), callee.getDeclaringClass()) && (value = mapper.getCallerValueOfCalleeParameter(ie, -1)) != null && (isReflectiveCallSite || !BackwardsInfoflowProblem.this.hasAnotherReferenceOnBase(ie, (Value)sourceBase, mapper.getCallerIndexOfCalleeParameter(-1))) && (abs = source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), value, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), exitStmt)) != null) {
                            this.enterConditional(abs, callSite, returnSite);
                            res.add(abs);
                        }
                        if (ie != null) {
                            for (int paramIndex = 0; paramIndex < callee.getParameterCount(); ++paramIndex) {
                                Value value2;
                                if (!aliasing.mayAlias((Value)source.getAccessPath().getPlainValue(), paramLocals[paramIndex]) || (value2 = mapper.getCallerValueOfCalleeParameter(ie, paramIndex)) == null || !AccessPath.canContainValue(value2) || !isReflectiveCallSite && !BackwardsInfoflowProblem.this.manager.getTypeUtils().checkCast(source.getAccessPath(), value2.getType()) || (abs = source.deriveNewAbstraction(ap = BackwardsInfoflowProblem.this.manager.getAccessPathFactory().copyWithNewValue(source.getAccessPath(), value2, isReflectiveCallSite ? null : source.getAccessPath().getBaseType(), false), exitStmt)) == null) continue;
                                this.enterConditional(abs, callSite, returnSite);
                                res.add(abs);
                                if (isReflectiveCallSite || !aliasing.canHaveAliasesRightSide(callStmt, value2, abs)) continue;
                                SootMethod caller = (SootMethod)BackwardsInfoflowProblem.this.manager.getICFG().getMethodOf(callStmt);
                                boolean foundDuplicate = false;
                                for (int argIndex = 0; argIndex < ie.getArgCount(); ++argIndex) {
                                    if (paramIndex == argIndex || value2 != ie.getArg(argIndex)) continue;
                                    foundDuplicate = true;
                                    break;
                                }
                                if (foundDuplicate) {
                                    for (Value arg : ie.getArgs()) {
                                        if (arg != value2) continue;
                                        for (Abstraction d1 : callerD1s) {
                                            aliasing.computeAliases(d1, callStmt, arg, res, caller, abs);
                                        }
                                    }
                                }
                                for (Unit u : callee.getActiveBody().getUnits()) {
                                    Value retOp;
                                    if (!(u instanceof ReturnStmt) || paramLocals[paramIndex] != (retOp = ((ReturnStmt)u).getOp())) continue;
                                    for (Unit pred : BackwardsInfoflowProblem.this.manager.getICFG().getPredsOf(callStmt)) {
                                        for (Abstraction d1 : callerD1s) {
                                            aliasing.computeAliases(d1, stmt, value2, Collections.singleton(abs), (SootMethod)BackwardsInfoflowProblem.this.manager.getICFG().getMethodOf(pred), abs);
                                        }
                                    }
                                }
                            }
                        }
                        for (Abstraction abstraction : res) {
                            if (abstraction == source) continue;
                            abstraction.setCorrespondingCallSite(callStmt);
                        }
                        return res;
                    }
                };
            }

            public FlowFunction<Abstraction> getCallToReturnFlowFunction(final Unit callSite, final Unit returnSite) {
                if (!(callSite instanceof Stmt)) {
                    return KillAll.v();
                }
                final Aliasing aliasing = BackwardsInfoflowProblem.this.manager.getAliasing();
                if (aliasing == null) {
                    return KillAll.v();
                }
                final Stmt callStmt = (Stmt)callSite;
                final InvokeExpr invExpr = callStmt.getInvokeExpr();
                final Value[] callArgs = new Value[invExpr.getArgCount()];
                for (int i = 0; i < invExpr.getArgCount(); ++i) {
                    callArgs[i] = invExpr.getArg(i);
                }
                final SootMethod callee = invExpr.getMethod();
                final boolean isSink = BackwardsInfoflowProblem.this.manager.getSourceSinkManager() != null && BackwardsInfoflowProblem.this.manager.getSourceSinkManager().getSinkInfo(callStmt, BackwardsInfoflowProblem.this.manager, null) != null;
                return new SolverCallToReturnFlowFunction(){

                    @Override
                    public Set<Abstraction> computeTargets(Abstraction d1, Abstraction source) {
                        if (BackwardsInfoflowProblem.this.taintPropagationHandler != null) {
                            BackwardsInfoflowProblem.this.taintPropagationHandler.notifyFlowIn(callSite, source, BackwardsInfoflowProblem.this.manager, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                        }
                        Set<Abstraction> res = this.computeTargetsInternal(d1, source);
                        return BackwardsInfoflowProblem.this.notifyOutFlowHandlers(callSite, d1, source, res, TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction);
                    }

                    private Set<Abstraction> computeTargetsInternal(Abstraction d1, Abstraction source) {
                        IInfoflowCFG.UnitContainer dom;
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStopAfterFirstFlow() && !BackwardsInfoflowProblem.this.results.isEmpty()) {
                            return null;
                        }
                        HashSet<Abstraction> res = null;
                        ByReferenceBoolean killSource = new ByReferenceBoolean();
                        ByReferenceBoolean killAll = new ByReferenceBoolean();
                        if (BackwardsInfoflowProblem.this.propagationRules != null) {
                            res = BackwardsInfoflowProblem.this.propagationRules.applyCallToReturnFlowFunction(d1, source, callStmt, killSource, killAll, true);
                        }
                        if (killAll.value) {
                            return null;
                        }
                        if (res == null) {
                            res = new HashSet();
                        }
                        if (callStmt instanceof AssignStmt && aliasing.mayAlias(((AssignStmt)callStmt).getLeftOp(), (Value)source.getAccessPath().getPlainValue())) {
                            return res;
                        }
                        if (!killSource.value && source != BackwardsInfoflowProblem.this.zeroValue) {
                            boolean hasConcreteCallees = false;
                            for (SootMethod callee2 : BackwardsInfoflowProblem.this.interproceduralCFG().getCalleesOfCallAt(callSite)) {
                                if (!callee2.isConcrete()) continue;
                                hasConcreteCallees = true;
                                break;
                            }
                            if (!hasConcreteCallees) {
                                res.add(source);
                            }
                        }
                        if (isSink && !BackwardsInfoflowProblem.this.manager.getConfig().getInspectSinks() && source != BackwardsInfoflowProblem.this.zeroValue && !killSource.value) {
                            res.add(source);
                        }
                        if (BackwardsInfoflowProblem.this.isExcluded(callee) && source != BackwardsInfoflowProblem.this.zeroValue && !killSource.value) {
                            res.add(source);
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getStaticFieldTrackingMode() != InfoflowConfiguration.StaticFieldTrackingMode.None && source.getAccessPath().isStaticFieldRef() && BackwardsInfoflowProblem.this.interproceduralCFG().isStaticFieldUsed(callee, source.getAccessPath().getFirstField())) {
                            return res;
                        }
                        if (callee.isNative() && BackwardsInfoflowProblem.this.ncHandler != null) {
                            for (Value arg2 : callArgs) {
                                if (!aliasing.mayAlias(arg2, (Value)source.getAccessPath().getPlainValue())) continue;
                                Set<Abstraction> nativeAbs = BackwardsInfoflowProblem.this.ncHandler.getTaintedValues(callStmt, source, callArgs);
                                if (nativeAbs == null) break;
                                res.addAll(nativeAbs);
                                for (Abstraction abs : nativeAbs) {
                                    this.enterConditional(abs, (Unit)callStmt, returnSite);
                                    if (!abs.getAccessPath().isStaticFieldRef() && !aliasing.canHaveAliasesRightSide(callStmt, (Value)abs.getAccessPath().getPlainValue(), abs)) continue;
                                    for (Unit pred : BackwardsInfoflowProblem.this.manager.getICFG().getPredsOf(callStmt)) {
                                        aliasing.computeAliases(d1, (Stmt)pred, (Value)abs.getAccessPath().getPlainValue(), res, (SootMethod)BackwardsInfoflowProblem.this.interproceduralCFG().getMethodOf(pred), abs);
                                    }
                                }
                                break;
                            }
                        }
                        if (invExpr instanceof InstanceInvokeExpr && aliasing.mayAlias(((InstanceInvokeExpr)invExpr).getBase(), (Value)source.getAccessPath().getPlainValue()) && (source.getAccessPath().getTaintSubFields() || source.getAccessPath().getFragmentCount() > 0) && !callee.isNative()) {
                            return res;
                        }
                        if (Arrays.stream(callArgs).anyMatch(arg -> !this.isPrimitiveOrStringBase(source) && aliasing.mayAlias((Value)arg, (Value)source.getAccessPath().getPlainValue()))) {
                            return res;
                        }
                        if (!killSource.value && source != BackwardsInfoflowProblem.this.zeroValue) {
                            res.add(source);
                        }
                        if (BackwardsInfoflowProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies() && source.getDominator() == null && res.contains(source) && (dom = BackwardsInfoflowProblem.this.manager.getICFG().getDominatorOf(callSite)).getUnit() != null && dom.getUnit() != returnSite) {
                            res.remove(source);
                            res.add(source.deriveNewAbstractionWithDominator(dom.getUnit()));
                        }
                        return res;
                    }
                };
            }

            private void enterConditional(Abstraction abs, Unit stmt, Unit destStmt) {
                if (!BackwardsInfoflowProblem.this.manager.getConfig().getImplicitFlowMode().trackControlFlowDependencies() || abs.getDominator() != null) {
                    return;
                }
                IInfoflowCFG.UnitContainer dom = BackwardsInfoflowProblem.this.manager.getICFG().getDominatorOf(stmt);
                if (dom.getUnit() != null && dom.getUnit() != destStmt) {
                    abs.setDominator(dom.getUnit());
                }
            }

            private boolean isPrimitiveOrStringBase(Abstraction abs) {
                Type t = abs.getAccessPath().getBaseType();
                return t instanceof PrimType || TypeUtils.isStringType(t) && !abs.getAccessPath().getCanHaveImmutableAliases();
            }

            private boolean isPrimitiveOrStringType(Type t) {
                return t instanceof PrimType || TypeUtils.isStringType(t);
            }
        };
    }
}

