/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems;

import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.collect.MyConcurrentHashMap;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.solver.memory.IMemoryManager;
import soot.jimple.infoflow.util.SystemClassHandler;

public class TaintPropagationResults {
    protected final InfoflowManager manager;
    protected final MyConcurrentHashMap<AbstractionAtSink, Abstraction> results = new MyConcurrentHashMap();
    protected final Set<OnTaintPropagationResultAdded> resultAddedHandlers = new HashSet<OnTaintPropagationResultAdded>();

    TaintPropagationResults(InfoflowManager manager) {
        this.manager = manager;
    }

    public boolean addResult(AbstractionAtSink resultAbs) {
        if (this.manager.getConfig().getIgnoreFlowsInSystemPackages()) {
            SootMethod sm = (SootMethod)this.manager.getICFG().getMethodOf(resultAbs.getSinkStmt());
            if (SystemClassHandler.v().isClassInSystemPackage(sm.getDeclaringClass()) && !sm.hasTag("fd_essential_method")) {
                return true;
            }
        }
        Abstraction abs = resultAbs.getAbstraction();
        abs = abs.deriveDefinitelyNewAbstraction(abs.getAccessPath(), resultAbs.getSinkStmt());
        abs.setCorrespondingCallSite(resultAbs.getSinkStmt());
        IMemoryManager<Abstraction, Unit> memoryManager = this.manager.getMainSolver().getMemoryManager();
        if (memoryManager != null && (abs = memoryManager.handleMemoryObject(abs)) == null) {
            return true;
        }
        Abstraction newAbs = this.results.putIfAbsentElseGet(resultAbs = new AbstractionAtSink(resultAbs.getSinkDefinitions(), abs, resultAbs.getSinkStmt()), resultAbs.getAbstraction());
        if (newAbs != resultAbs.getAbstraction()) {
            newAbs.addNeighbor(resultAbs.getAbstraction());
        }
        boolean continueAnalysis = true;
        for (OnTaintPropagationResultAdded handler : this.resultAddedHandlers) {
            if (handler.onResultAvailable(resultAbs)) continue;
            continueAnalysis = false;
        }
        return continueAnalysis;
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public Set<AbstractionAtSink> getResults() {
        return this.results.keySet();
    }

    public void addResultAvailableHandler(OnTaintPropagationResultAdded handler) {
        this.resultAddedHandlers.add(handler);
    }

    public int size() {
        return this.results == null ? 0 : this.results.size();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TaintPropagationResults other = (TaintPropagationResults)obj;
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.results != null && !this.results.isEmpty()) {
            for (AbstractionAtSink aas : this.results.keySet()) {
                sb.append("Abstraction: ");
                sb.append(aas.getAbstraction());
                sb.append(" at ");
                sb.append(aas.getSinkStmt());
                sb.append("\n");
            }
        }
        return sb.toString();
    }

    public static interface OnTaintPropagationResultAdded {
        public boolean onResultAvailable(AbstractionAtSink var1);
    }
}

