/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.DummyArrayContext;
import soot.jimple.infoflow.problems.rules.IArrayContextProvider;
import soot.jimple.infoflow.problems.rules.ITaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class PropagationRuleManager {
    protected final InfoflowManager manager;
    protected final Abstraction zeroValue;
    protected final TaintPropagationResults results;
    protected final ITaintPropagationRule[] rules;
    protected IArrayContextProvider arrayRule;

    public PropagationRuleManager(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results, ITaintPropagationRule[] rules) {
        this.manager = manager;
        this.zeroValue = zeroValue;
        this.results = results;
        this.rules = rules;
        if (rules != null) {
            for (ITaintPropagationRule rule : rules) {
                if (!(rule instanceof IArrayContextProvider)) continue;
                this.arrayRule = (IArrayContextProvider)((Object)rule);
                break;
            }
        }
        if (this.arrayRule == null) {
            this.arrayRule = new DummyArrayContext();
        }
    }

    public Set<Abstraction> applyNormalFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt) {
        return this.applyNormalFlowFunction(d1, source, stmt, destStmt, null, null);
    }

    public Set<Abstraction> applyNormalFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        if (killSource == null) {
            killSource = new ByReferenceBoolean();
        }
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateNormalFlow(d1, source, stmt, destStmt, killSource, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        if (!(killAll != null && killAll.value || killSource.value)) {
            if (res == null) {
                res = new HashSet<Abstraction>();
            }
            res.add(source);
        }
        return res;
    }

    public Set<Abstraction> applyCallFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateCallFlow(d1, source, stmt, dest, killAll);
            if (killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        return res;
    }

    public Set<Abstraction> applyCallToReturnFlowFunction(Abstraction d1, Abstraction source, Stmt stmt) {
        return this.applyCallToReturnFlowFunction(d1, source, stmt, new ByReferenceBoolean(), null, false);
    }

    public Set<Abstraction> applyCallToReturnFlowFunction(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll, boolean noAddSource) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateCallToReturnFlow(d1, source, stmt, killSource, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        if (!noAddSource && !killSource.value) {
            if (res == null) {
                res = new HashSet<Abstraction>();
            }
            res.add(source);
        }
        return res;
    }

    public Set<Abstraction> applyReturnFlowFunction(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        HashSet<Abstraction> res = null;
        for (ITaintPropagationRule rule : this.rules) {
            Collection<Abstraction> ruleOut = rule.propagateReturnFlow(callerD1s, calleeD1, source, stmt, retSite, callSite, killAll);
            if (killAll != null && killAll.value) {
                return null;
            }
            if (ruleOut == null || ruleOut.isEmpty()) continue;
            if (res == null) {
                res = new HashSet<Abstraction>(ruleOut);
                continue;
            }
            res.addAll(ruleOut);
        }
        return res;
    }

    public ITaintPropagationRule[] getRules() {
        return this.rules;
    }

    public IArrayContextProvider getArrayContextProvider() {
        return this.arrayRule;
    }
}

