/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.forward;

import java.util.Collection;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.IfStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.LookupSwitchStmt;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.TableSwitchStmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AbstractionAtSink;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.sourcesSinks.manager.ISourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class SinkPropagationRule
extends AbstractTaintPropagationRule {
    private boolean killState = false;

    public SinkPropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (stmt instanceof ReturnStmt) {
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            this.checkForSink(d1, source, stmt, returnStmt.getOp());
        } else if (stmt instanceof IfStmt) {
            IfStmt ifStmt = (IfStmt)stmt;
            this.checkForSink(d1, source, stmt, ifStmt.getCondition());
        } else if (stmt instanceof LookupSwitchStmt) {
            LookupSwitchStmt switchStmt = (LookupSwitchStmt)stmt;
            this.checkForSink(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof TableSwitchStmt) {
            TableSwitchStmt switchStmt = (TableSwitchStmt)stmt;
            this.checkForSink(d1, source, stmt, switchStmt.getKey());
        } else if (stmt instanceof AssignStmt) {
            AssignStmt assignStmt = (AssignStmt)stmt;
            this.checkForSink(d1, source, stmt, assignStmt.getRightOp());
        }
        return null;
    }

    private void checkForSink(Abstraction d1, Abstraction source, Stmt stmt, Value retVal) {
        AccessPath ap = source.getAccessPath();
        Aliasing aliasing = this.getAliasing();
        ISourceSinkManager sourceSinkManager = this.getManager().getSourceSinkManager();
        if (ap != null && sourceSinkManager != null && aliasing != null && source.isAbstractionActive()) {
            for (Value val : BaseSelector.selectBaseList(retVal, false)) {
                SinkInfo sinkInfo;
                if (!aliasing.mayAlias(val, (Value)ap.getPlainValue()) || (sinkInfo = sourceSinkManager.getSinkInfo(stmt, this.getManager(), source.getAccessPath())) == null || this.getResults().addResult(new AbstractionAtSink(sinkInfo.getDefinitions(), source, stmt))) continue;
                this.killState = true;
            }
        }
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    protected boolean isTaintVisibleInCallee(Stmt stmt, Abstraction source) {
        if (this.getAliasing() == null) {
            return false;
        }
        InvokeExpr iexpr = stmt.getInvokeExpr();
        boolean found = false;
        Local apBaseValue = source.getAccessPath().getPlainValue();
        if (apBaseValue != null) {
            for (int i = 0; i < iexpr.getArgCount(); ++i) {
                if (!this.getAliasing().mayAlias(iexpr.getArg(i), (Value)apBaseValue) || !source.getAccessPath().getTaintSubFields() && !source.getAccessPath().isLocal()) continue;
                return true;
            }
        }
        return !found && iexpr instanceof InstanceInvokeExpr && ((InstanceInvokeExpr)iexpr).getBase() == source.getAccessPath().getPlainValue();
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        SinkInfo sinkInfo;
        ISourceSinkManager ssm;
        if (!(!source.isAbstractionActive() || source.getAccessPath().isStaticFieldRef() || stmt.containsInvokeExpr() && !this.isTaintVisibleInCallee(stmt, source) || (ssm = this.getManager().getSourceSinkManager()) == null || (sinkInfo = ssm.getSinkInfo(stmt, this.getManager(), source.getAccessPath())) == null || this.getResults().addResult(new AbstractionAtSink(sinkInfo.getDefinitions(), source, stmt)))) {
            this.killState = true;
        }
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        if (stmt instanceof ReturnStmt) {
            SinkInfo sinkInfo;
            boolean matches;
            ReturnStmt returnStmt = (ReturnStmt)stmt;
            ISourceSinkManager ssm = this.getManager().getSourceSinkManager();
            Aliasing aliasing = this.getAliasing();
            boolean bl = matches = source.getAccessPath().isLocal() || source.getAccessPath().getTaintSubFields();
            if (matches && source.isAbstractionActive() && ssm != null && aliasing != null && aliasing.mayAlias((Value)source.getAccessPath().getPlainValue(), returnStmt.getOp()) && (sinkInfo = ssm.getSinkInfo((Stmt)returnStmt, this.getManager(), source.getAccessPath())) != null && !this.getResults().addResult(new AbstractionAtSink(sinkInfo.getDefinitions(), source, (Stmt)returnStmt))) {
                this.killState = true;
            }
        }
        if (killAll != null) {
            killAll.value |= this.killState;
        }
        return null;
    }
}

