/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.problems.rules.forward;

import java.util.Collection;
import soot.Local;
import soot.SootMethod;
import soot.Value;
import soot.ValueBox;
import soot.jimple.ArrayRef;
import soot.jimple.AssignStmt;
import soot.jimple.InstanceFieldRef;
import soot.jimple.StaticFieldRef;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.aliasing.Aliasing;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.problems.TaintPropagationResults;
import soot.jimple.infoflow.problems.rules.AbstractTaintPropagationRule;
import soot.jimple.infoflow.util.ByReferenceBoolean;

public class StrongUpdatePropagationRule
extends AbstractTaintPropagationRule {
    public StrongUpdatePropagationRule(InfoflowManager manager, Abstraction zeroValue, TaintPropagationResults results) {
        super(manager, zeroValue, results);
    }

    @Override
    public Collection<Abstraction> propagateNormalFlow(Abstraction d1, Abstraction source, Stmt stmt, Stmt destStmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        if (!(stmt instanceof AssignStmt)) {
            return null;
        }
        AssignStmt assignStmt = (AssignStmt)stmt;
        if (assignStmt.getLeftOp() instanceof ArrayRef) {
            return null;
        }
        if (!source.isAbstractionActive() && source.getCurrentStmt() == stmt) {
            return null;
        }
        if (source.getPredecessor() != null && !source.getPredecessor().isAbstractionActive() && source.isAbstractionActive() && source.getPredecessor().getActivationUnit() == stmt && source.getAccessPath().equals(source.getPredecessor().getAccessPath())) {
            return null;
        }
        Value lhs = assignStmt.getLeftOp();
        Aliasing aliasing = this.getAliasing();
        if (aliasing != null && source.getAccessPath().isInstanceFieldRef()) {
            if (lhs instanceof InstanceFieldRef) {
                boolean baseAliases;
                InstanceFieldRef leftRef = (InstanceFieldRef)lhs;
                if (source.isAbstractionActive()) {
                    baseAliases = aliasing.mustAlias((Local)leftRef.getBase(), source.getAccessPath().getPlainValue(), (Stmt)assignStmt);
                } else {
                    boolean bl = baseAliases = leftRef.getBase() == source.getAccessPath().getPlainValue();
                }
                if (baseAliases && aliasing.mustAlias(leftRef.getField(), source.getAccessPath().getFirstField())) {
                    killAll.value = true;
                    return null;
                }
            } else if (lhs instanceof Local && aliasing.mustAlias((Local)lhs, source.getAccessPath().getPlainValue(), stmt)) {
                killAll.value = true;
                return null;
            }
        } else if (aliasing != null && source.getAccessPath().isStaticFieldRef()) {
            if (lhs instanceof StaticFieldRef && aliasing.mustAlias(((StaticFieldRef)lhs).getField(), source.getAccessPath().getFirstField())) {
                killAll.value = true;
                return null;
            }
        } else if (source.getAccessPath().isLocal() && lhs instanceof Local && lhs == source.getAccessPath().getPlainValue()) {
            boolean found = false;
            for (ValueBox vb : assignStmt.getRightOp().getUseBoxes()) {
                if (vb.getValue() != source.getAccessPath().getPlainValue()) continue;
                found = true;
                break;
            }
            killAll.value = !found;
            killSource.value = true;
            return null;
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallFlow(Abstraction d1, Abstraction source, Stmt stmt, SootMethod dest, ByReferenceBoolean killAll) {
        return null;
    }

    @Override
    public Collection<Abstraction> propagateCallToReturnFlow(Abstraction d1, Abstraction source, Stmt stmt, ByReferenceBoolean killSource, ByReferenceBoolean killAll) {
        AccessPath ap;
        if (stmt instanceof AssignStmt && (ap = source.getAccessPath()) != null) {
            AssignStmt assignStmt = (AssignStmt)stmt;
            Aliasing aliasing = this.getAliasing();
            if (aliasing != null && !ap.isStaticFieldRef() && assignStmt.getLeftOp() instanceof Local && aliasing.mayAlias(assignStmt.getLeftOp(), (Value)ap.getPlainValue())) {
                killSource.value = true;
            }
        }
        return null;
    }

    @Override
    public Collection<Abstraction> propagateReturnFlow(Collection<Abstraction> callerD1s, Abstraction calleeD1, Abstraction source, Stmt stmt, Stmt retSite, Stmt callSite, ByReferenceBoolean killAll) {
        return null;
    }
}

