/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public abstract class AbstractResultSourceSinkInfo {
    protected final ISourceSinkDefinition definition;
    protected final AccessPath accessPath;
    protected final Stmt stmt;
    protected final Object userData;

    public AbstractResultSourceSinkInfo() {
        this.stmt = null;
        this.definition = null;
        this.accessPath = null;
        this.userData = null;
    }

    public AbstractResultSourceSinkInfo(ISourceSinkDefinition definition, AccessPath accessPath, Stmt stmt) {
        this(definition, accessPath, stmt, null);
    }

    public AbstractResultSourceSinkInfo(ISourceSinkDefinition definition, AccessPath accessPath, Stmt stmt, Object userData) {
        assert (accessPath != null);
        this.definition = definition;
        this.accessPath = accessPath;
        this.stmt = stmt;
        this.userData = userData;
    }

    public ISourceSinkDefinition getDefinition() {
        return this.definition;
    }

    public AccessPath getAccessPath() {
        return this.accessPath;
    }

    public Stmt getStmt() {
        return this.stmt;
    }

    public Object getUserData() {
        return this.userData;
    }

    public int hashCode() {
        int prime = 31;
        int result = InfoflowConfiguration.getOneResultPerAccessPath() ? 31 * this.accessPath.hashCode() : 0;
        result = 31 * result + (this.definition == null ? 0 : this.definition.hashCode());
        result = 31 * result + (this.stmt == null ? 0 : this.stmt.hashCode());
        result = 31 * result + (this.userData == null ? 0 : this.userData.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractResultSourceSinkInfo si = (AbstractResultSourceSinkInfo)o;
        if (InfoflowConfiguration.getOneResultPerAccessPath() && !this.accessPath.equals(si.accessPath)) {
            return false;
        }
        if (this.definition == null ? si.definition != null : !this.definition.equals(si.definition)) {
            return false;
        }
        if (this.stmt == null ? si.stmt != null : !this.stmt.equals(si.stmt)) {
            return false;
        }
        return !(this.userData == null ? si.userData != null : !this.userData.equals(si.userData));
    }
}

