/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results;

import heros.solver.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.results.InfoflowResults;
import soot.jimple.infoflow.results.ResultSinkInfo;
import soot.jimple.infoflow.results.ResultSourceInfo;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;

public class BackwardsInfoflowResults
extends InfoflowResults {
    public BackwardsInfoflowResults() {
    }

    public BackwardsInfoflowResults(boolean pathAgnosticResults) {
        super(pathAgnosticResults);
    }

    @Override
    public Collection<Pair<ResultSourceInfo, ResultSinkInfo>> addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt, Object userData, List<Stmt> propagationPath, List<AccessPath> propagationAccessPath, List<Stmt> propagationCallSites, InfoflowManager manager) {
        if (propagationCallSites != null) {
            Collections.reverse(propagationCallSites);
        }
        if (propagationPath != null) {
            Collections.reverse(propagationPath);
            if (!manager.getConfig().getPathAgnosticResults() && propagationCallSites != null && manager != null) {
                for (int i = 0; i < propagationPath.size(); ++i) {
                    if (!manager.getICFG().isExitStmt((Unit)propagationPath.get(i))) continue;
                    propagationPath.set(i, propagationCallSites.get(i));
                }
            }
        }
        if (propagationAccessPath != null) {
            Collections.reverse(propagationAccessPath);
        }
        HashSet<Pair<ResultSourceInfo, ResultSinkInfo>> resultPairs = new HashSet<Pair<ResultSourceInfo, ResultSinkInfo>>(sinkDefinitions.size() * sourceDefinitions.size());
        for (ISourceSinkDefinition sourceDefinition : sourceDefinitions) {
            for (ISourceSinkDefinition sinkDefinition : sinkDefinitions) {
                ResultSinkInfo sourceObj = new ResultSinkInfo(sourceDefinition, source, sourceStmt);
                ResultSourceInfo sinkObj = new ResultSourceInfo(sinkDefinition, sink, sinkStmt, userData, propagationPath, propagationAccessPath, propagationCallSites, this.pathAgnosticResults);
                this.addResult(sourceObj, sinkObj);
                resultPairs.add((Pair<ResultSourceInfo, ResultSinkInfo>)new Pair((Object)sinkObj, (Object)sourceObj));
            }
        }
        return resultPairs;
    }

    @Override
    public void addResult(Collection<ISourceSinkDefinition> sinkDefinitions, AccessPath sink, Stmt sinkStmt, Collection<ISourceSinkDefinition> sourceDefinitions, AccessPath source, Stmt sourceStmt) {
        for (ISourceSinkDefinition sourceDefinition : sourceDefinitions) {
            for (ISourceSinkDefinition sinkDefinition : sinkDefinitions) {
                this.addResult(new ResultSinkInfo(sourceDefinition, sink, sinkStmt), new ResultSourceInfo(sinkDefinition, source, sourceStmt, this.pathAgnosticResults));
            }
        }
    }
}

