/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.results.xml;

import java.util.Set;
import soot.jimple.infoflow.results.InfoflowPerformanceData;
import soot.jimple.infoflow.results.xml.SerializedSinkInfo;
import soot.jimple.infoflow.results.xml.SerializedSourceInfo;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public class SerializedInfoflowResults {
    private int fileFormatVersion = -1;
    private final MultiMap<SerializedSinkInfo, SerializedSourceInfo> results = new HashMultiMap();
    private InfoflowPerformanceData performanceData = null;

    SerializedInfoflowResults() {
    }

    void setFileFormatVersion(int version) {
        this.fileFormatVersion = version;
    }

    void addResult(SerializedSourceInfo source, SerializedSinkInfo sink) {
        this.results.put((Object)sink, (Object)source);
    }

    public int getResultCount() {
        int cnt = 0;
        for (SerializedSinkInfo sink : this.results.keySet()) {
            Set sources = this.results.get((Object)sink);
            cnt += sources == null ? 0 : sources.size();
        }
        return cnt;
    }

    public InfoflowPerformanceData getPerformanceData() {
        return this.performanceData;
    }

    InfoflowPerformanceData getOrCreatePerformanceData() {
        if (this.performanceData == null) {
            this.performanceData = new InfoflowPerformanceData();
        }
        return this.performanceData;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.fileFormatVersion;
        result = 31 * result + (this.performanceData == null ? 0 : this.performanceData.hashCode());
        result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SerializedInfoflowResults other = (SerializedInfoflowResults)obj;
        if (this.fileFormatVersion != other.fileFormatVersion) {
            return false;
        }
        if (this.performanceData == null ? other.performanceData != null : !this.performanceData.equals(other.performanceData)) {
            return false;
        }
        return !(this.results == null ? other.results != null : !this.results.equals(other.results));
    }

    public boolean isEmpty() {
        return this.results.isEmpty();
    }

    public int getFileFormatVersion() {
        return this.fileFormatVersion;
    }

    public MultiMap<SerializedSinkInfo, SerializedSourceInfo> getResults() {
        return this.results;
    }
}

