/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.river;

import java.util.Set;
import soot.Unit;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.TaintPropagationHandler;
import soot.jimple.infoflow.problems.rules.ITaintPropagationRule;
import soot.jimple.infoflow.problems.rules.PropagationRuleManager;
import soot.jimple.infoflow.river.IAdditionalFlowSinkPropagationRule;
import soot.jimple.infoflow.river.IConditionalFlowManager;

public class SecondaryFlowListener
implements TaintPropagationHandler {
    private IAdditionalFlowSinkPropagationRule sinkRule = null;

    private void ensureSourcePropagationRule(InfoflowManager manager) {
        if (this.sinkRule != null) {
            return;
        }
        if (!manager.getConfig().getAdditionalFlowsEnabled()) {
            throw new IllegalStateException("Additional flows are not enabled!");
        }
        PropagationRuleManager ruleManager = manager.getMainSolver().getTabulationProblem().getPropagationRules();
        for (ITaintPropagationRule rule : ruleManager.getRules()) {
            if (!(rule instanceof IAdditionalFlowSinkPropagationRule)) continue;
            this.sinkRule = (IAdditionalFlowSinkPropagationRule)((Object)rule);
            return;
        }
        throw new IllegalStateException("Enabled additional flows but no IConditionalFlowSinkPropagationRule in place!");
    }

    @Override
    public void notifyFlowIn(Unit unit, Abstraction incoming, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        Stmt stmt;
        if (type != TaintPropagationHandler.FlowFunctionType.CallToReturnFlowFunction) {
            return;
        }
        this.ensureSourcePropagationRule(manager);
        if (!(manager.getSourceSinkManager() instanceof IConditionalFlowManager)) {
            return;
        }
        IConditionalFlowManager ssm = (IConditionalFlowManager)((Object)manager.getSourceSinkManager());
        if (ssm.isSecondarySink(stmt = (Stmt)unit) || manager.getUsageContextProvider().isStatementWithAdditionalInformation(stmt, incoming)) {
            this.sinkRule.processSecondaryFlowSink(null, incoming, stmt);
        }
    }

    @Override
    public Set<Abstraction> notifyFlowOut(Unit stmt, Abstraction d1, Abstraction incoming, Set<Abstraction> outgoing, InfoflowManager manager, TaintPropagationHandler.FlowFunctionType type) {
        return outgoing;
    }
}

