/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.cfg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import soot.Body;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.IfStmt;
import soot.jimple.Stmt;
import soot.jimple.SwitchStmt;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.cfg.InfoflowCFG;
import soot.jimple.toolkits.ide.icfg.BackwardsInterproceduralCFG;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.toolkits.graph.DirectedGraph;

public class BackwardsInfoflowCFG
extends InfoflowCFG {
    private final IInfoflowCFG baseCFG;

    public BackwardsInfoflowCFG(IInfoflowCFG baseCFG) {
        super((BiDiInterproceduralCFG<Unit, SootMethod>)new BackwardsInterproceduralCFG((BiDiInterproceduralCFG)baseCFG));
        this.baseCFG = baseCFG;
    }

    public IInfoflowCFG getBaseCFG() {
        return this.baseCFG;
    }

    @Override
    public boolean isStaticFieldRead(SootMethod method, SootField variable) {
        return this.baseCFG.isStaticFieldRead(method, variable);
    }

    @Override
    public boolean isStaticFieldUsed(SootMethod method, SootField variable) {
        return this.baseCFG.isStaticFieldUsed(method, variable);
    }

    @Override
    public boolean hasSideEffects(SootMethod method) {
        return this.baseCFG.hasSideEffects(method);
    }

    @Override
    public boolean methodReadsValue(SootMethod m, Value v) {
        return this.baseCFG.methodReadsValue(m, v);
    }

    @Override
    public boolean methodWritesValue(SootMethod m, Value v) {
        return this.baseCFG.methodWritesValue(m, v);
    }

    @Override
    public IInfoflowCFG.UnitContainer getPostdominatorOf(Unit u) {
        return this.baseCFG.getPostdominatorOf(u);
    }

    @Override
    public IInfoflowCFG.UnitContainer getDominatorOf(Unit u) {
        return this.baseCFG.getDominatorOf(u);
    }

    @Override
    public boolean isExceptionalEdgeBetween(Unit u1, Unit u2) {
        return super.isExceptionalEdgeBetween(u2, u1);
    }

    @Override
    public List<Unit> getConditionalBranchIntraprocedural(Unit unit) {
        SootMethod sm = this.getMethodOf(unit);
        if (sm.getDeclaringClass().getName().equals("dummyMainClass") && sm.getName().equals("dummy")) {
            return null;
        }
        DirectedGraph<Unit> graph = this.getOrCreateUnitGraph(sm);
        ArrayList<Unit> worklist = new ArrayList<Unit>(this.sameLevelPredecessors(graph, unit));
        HashSet<Unit> doneSet = new HashSet<Unit>();
        ArrayList<Unit> conditionals = new ArrayList<Unit>();
        while (worklist.size() > 0) {
            Unit item = (Unit)worklist.remove(0);
            doneSet.add(item);
            if (item instanceof IfStmt || item instanceof SwitchStmt) {
                conditionals.add(item);
            }
            ArrayList<Unit> preds = new ArrayList<Unit>(this.sameLevelPredecessors(graph, item));
            preds.removeIf(doneSet::contains);
            worklist.addAll(preds);
        }
        return conditionals;
    }

    @Override
    public List<Unit> getConditionalBranchesInterprocedural(Unit unit) {
        ArrayList<Unit> conditionals = new ArrayList<Unit>();
        HashSet<Unit> doneSet = new HashSet<Unit>();
        this.getConditionalsRecursive(unit, conditionals, doneSet);
        return conditionals;
    }

    private void getConditionalsRecursive(Unit unit, List<Unit> conditionals, Set<Unit> doneSet) {
        SootMethod sm = this.getMethodOf(unit);
        if (sm.getDeclaringClass().getName().equals("dummyMainClass") && sm.getName().equals("dummy")) {
            return;
        }
        DirectedGraph<Unit> graph = this.getOrCreateUnitGraph(sm);
        ArrayList<Unit> worklist = new ArrayList<Unit>(this.sameLevelPredecessors(graph, unit));
        worklist.removeIf(doneSet::contains);
        doneSet.addAll(worklist);
        while (worklist.size() > 0) {
            List<Object> entryPoints;
            Unit item = (Unit)worklist.remove(0);
            if (item instanceof IfStmt || item instanceof SwitchStmt) {
                conditionals.add(item);
            }
            if (item instanceof Stmt && ((Stmt)item).containsInvokeExpr()) {
                entryPoints = this.getPredsOf(item).stream().filter(pred -> this.getMethodOf((Unit)pred) != sm).collect(Collectors.toList());
                entryPoints.removeIf(doneSet::contains);
                for (Unit unit2 : entryPoints) {
                    this.getConditionalsRecursive(unit2, conditionals, doneSet);
                }
            }
            if (this.isExitStmt(item)) {
                entryPoints = new ArrayList<Unit>(this.getCallersOf(sm));
                entryPoints.removeIf(doneSet::contains);
                for (Unit unit3 : entryPoints) {
                    this.getConditionalsRecursive(unit3, conditionals, doneSet);
                }
            }
            ArrayList<Unit> preds = new ArrayList<Unit>(this.sameLevelPredecessors(graph, item));
            preds.removeIf(doneSet::contains);
            worklist.addAll(preds);
            doneSet.addAll(preds);
        }
    }

    private List<Unit> sameLevelPredecessors(DirectedGraph<Unit> graph, Unit u) {
        IInfoflowCFG.UnitContainer dom;
        List preds = graph.getPredsOf((Object)u);
        if (preds.size() <= 1) {
            if (preds.size() == 0) {
                return preds;
            }
            Unit pred = (Unit)preds.get(0);
            if (!pred.branches()) {
                return preds;
            }
            IInfoflowCFG.UnitContainer postdom = this.getPostdominatorOf(pred);
            if (postdom.getUnit() != u) {
                return preds;
            }
        }
        if ((dom = this.getDominatorOf(u)).getUnit() != null) {
            return graph.getPredsOf((Object)dom.getUnit());
        }
        return Collections.emptyList();
    }

    @Override
    public void notifyMethodChanged(SootMethod m) {
        this.baseCFG.notifyMethodChanged(m);
    }

    @Override
    public void notifyNewBody(Body b) {
        this.baseCFG.notifyNewBody(b);
    }

    @Override
    public void purge() {
        this.baseCFG.purge();
        super.purge();
    }
}

