/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.solver.sparseSolver;

import heros.FlowFunction;
import heros.solver.PathEdge;
import java.util.Collection;
import java.util.Set;
import java.util.function.Consumer;
import soot.SootMethod;
import soot.Unit;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.problems.AbstractInfoflowProblem;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.solver.executors.InterruptableExecutor;
import soot.jimple.infoflow.solver.fastSolver.InfoflowSolver;
import soot.jimple.infoflow.solver.sparseSolver.propagation.DensePropagation;
import soot.jimple.infoflow.solver.sparseSolver.propagation.IPropagationStrategy;
import soot.jimple.infoflow.solver.sparseSolver.propagation.PreciseSparsePropagation;
import soot.jimple.infoflow.solver.sparseSolver.propagation.SimpleSparsePropagation;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;

public class SparseInfoflowSolver
extends InfoflowSolver {
    private final IPropagationStrategy<Unit, Abstraction, BiDiInterproceduralCFG<Unit, SootMethod>> propagationStrategy;

    public SparseInfoflowSolver(AbstractInfoflowProblem problem, InterruptableExecutor executor, InfoflowConfiguration.SparsePropagationStrategy propStrategyOpt) {
        super(problem, executor);
        switch (propStrategyOpt) {
            case Dense: {
                this.propagationStrategy = new DensePropagation<Unit, Abstraction, IInfoflowCFG>(problem.interproceduralCFG());
                break;
            }
            case Simple: {
                this.propagationStrategy = new SimpleSparsePropagation(problem);
                break;
            }
            case Precise: {
                this.propagationStrategy = new PreciseSparsePropagation(problem);
                break;
            }
            default: {
                throw new RuntimeException("Unknown option!");
            }
        }
    }

    @Override
    protected void processNormalFlow(PathEdge<Unit, Abstraction> edge) {
        if (this.problem.getManager().getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
            super.processNormalFlow(edge);
            return;
        }
        Abstraction d1 = (Abstraction)edge.factAtSource();
        Unit n = (Unit)edge.getTarget();
        Abstraction d2 = (Abstraction)edge.factAtTarget();
        if (this.killFlag != null) {
            return;
        }
        FlowFunction flowFunction = this.flowFunctions.getNormalFlowFunction((Object)n, null);
        Set<Abstraction> res = this.computeNormalFlowFunction((FlowFunction<Abstraction>)flowFunction, d1, d2);
        if (res != null && !res.isEmpty()) {
            for (Abstraction d3 : res) {
                for (Unit m : this.propagationStrategy.getSuccsOf(n, d3)) {
                    if (this.memoryManager != null && d2 != d3) {
                        d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                    }
                    if (d3 == null) continue;
                    this.schedulingStrategy.propagateNormalFlow(d1, m, d3, null, false);
                }
            }
        }
    }

    @Override
    protected void processCall(PathEdge<Unit, Abstraction> edge) {
        FlowFunction callToReturnFlowFunction;
        Set<Abstraction> res;
        if (this.problem.getManager().getConfig().getImplicitFlowMode().trackControlFlowDependencies()) {
            super.processCall(edge);
            return;
        }
        final Abstraction d1 = (Abstraction)edge.factAtSource();
        final Unit n = (Unit)edge.getTarget();
        final Abstraction d2 = (Abstraction)edge.factAtTarget();
        assert (d2 != null);
        final Collection returnSiteNs = ((IInfoflowCFG)this.icfg).getReturnSitesOfCallAt(n);
        Collection callees = ((IInfoflowCFG)this.icfg).getCalleesOfCallAt(n);
        if (!(callees == null || callees.isEmpty() || this.maxCalleesPerCallSite >= 0 && callees.size() > this.maxCalleesPerCallSite)) {
            callees.stream().filter(m -> m.isConcrete()).forEach(new Consumer<SootMethod>(){

                @Override
                public void accept(SootMethod sCalledProcN) {
                    if (SparseInfoflowSolver.this.killFlag != null) {
                        return;
                    }
                    FlowFunction function = SparseInfoflowSolver.this.flowFunctions.getCallFlowFunction((Object)n, (Object)sCalledProcN);
                    Set res = SparseInfoflowSolver.this.computeCallFlowFunction((FlowFunction<Abstraction>)function, d1, d2);
                    if (res != null && !res.isEmpty()) {
                        for (Abstraction d3 : res) {
                            Collection<Unit> startPointsOf = SparseInfoflowSolver.this.propagationStrategy.getStartPointsOf(sCalledProcN, d3);
                            if (SparseInfoflowSolver.this.memoryManager != null) {
                                d3 = SparseInfoflowSolver.this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                            }
                            if (d3 == null) continue;
                            for (Unit sP : startPointsOf) {
                                SparseInfoflowSolver.this.schedulingStrategy.propagateCallFlow(d3, sP, d3, n, false);
                            }
                            if (!SparseInfoflowSolver.this.addIncoming(sCalledProcN, d3, n, d1, d2)) continue;
                            SparseInfoflowSolver.this.applyEndSummaryOnCall(d1, n, d2, returnSiteNs, sCalledProcN, d3);
                        }
                    }
                }
            });
        }
        if ((res = this.computeCallToReturnFlowFunction((FlowFunction<Abstraction>)(callToReturnFlowFunction = this.flowFunctions.getCallToReturnFlowFunction((Object)n, null)), d1, d2)) != null && !res.isEmpty()) {
            for (Abstraction d3 : res) {
                for (Unit returnSiteN : this.propagationStrategy.getSuccsOf(n, d3)) {
                    if (this.memoryManager != null) {
                        d3 = this.memoryManager.handleGeneratedMemoryObject(d2, d3);
                    }
                    if (d3 == null) continue;
                    this.schedulingStrategy.propagateCallToReturnFlow(d1, returnSiteN, d3, n, false);
                }
            }
        }
    }
}

