/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.sourcesSinks.manager;

import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import heros.solver.IDESolver;
import heros.solver.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.FastHierarchy;
import soot.Hierarchy;
import soot.Scene;
import soot.SootClass;
import soot.SootField;
import soot.SootMethod;
import soot.Type;
import soot.Value;
import soot.VoidType;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DefinitionStmt;
import soot.jimple.FieldRef;
import soot.jimple.IdentityStmt;
import soot.jimple.InstanceInvokeExpr;
import soot.jimple.InvokeExpr;
import soot.jimple.ParameterRef;
import soot.jimple.ReturnStmt;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowConfiguration;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.callbacks.CallbackDefinition;
import soot.jimple.infoflow.data.AccessPath;
import soot.jimple.infoflow.data.SootMethodAndClass;
import soot.jimple.infoflow.river.IConditionalFlowManager;
import soot.jimple.infoflow.solver.cfg.IInfoflowCFG;
import soot.jimple.infoflow.sourcesSinks.definitions.AccessPathTuple;
import soot.jimple.infoflow.sourcesSinks.definitions.FieldSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.ISourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.MethodSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.definitions.SourceSinkCondition;
import soot.jimple.infoflow.sourcesSinks.definitions.StatementSourceSinkDefinition;
import soot.jimple.infoflow.sourcesSinks.manager.IOneSourceAtATimeManager;
import soot.jimple.infoflow.sourcesSinks.manager.IReversibleSourceSinkManager;
import soot.jimple.infoflow.sourcesSinks.manager.SinkInfo;
import soot.jimple.infoflow.sourcesSinks.manager.SourceInfo;
import soot.jimple.infoflow.util.BaseSelector;
import soot.jimple.infoflow.util.SystemClassHandler;
import soot.jimple.infoflow.values.IValueProvider;
import soot.jimple.infoflow.values.SimpleConstantValueProvider;
import soot.jimple.toolkits.ide.icfg.BiDiInterproceduralCFG;
import soot.util.HashMultiMap;
import soot.util.MultiMap;

public abstract class BaseSourceSinkManager
implements IReversibleSourceSinkManager,
IOneSourceAtATimeManager,
IConditionalFlowManager {
    private static final String GLOBAL_SIG = "--GLOBAL--";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected MultiMap<String, ISourceSinkDefinition> sourceDefs;
    protected MultiMap<String, ISourceSinkDefinition> sinkDefs;
    protected MultiMap<SootMethod, ISourceSinkDefinition> sourceMethods;
    protected Map<SootMethod, ISourceSinkDefinition> sourceCallbackMethods;
    protected MultiMap<Stmt, ISourceSinkDefinition> sourceStatements;
    protected MultiMap<SootMethod, ISourceSinkDefinition> sinkMethods;
    protected MultiMap<SootMethod, ISourceSinkDefinition> sinkReturnMethods;
    protected Map<SootMethod, CallbackDefinition> callbackMethods;
    protected MultiMap<SootField, ISourceSinkDefinition> sourceFields;
    protected MultiMap<SootField, ISourceSinkDefinition> sinkFields;
    protected MultiMap<Stmt, ISourceSinkDefinition> sinkStatements;
    protected Set<SootMethod> conditionalSinks = new HashSet<SootMethod>();
    protected MultiMap<SootMethod, SootClass> conditionalSinkToExcludedClasses = new HashMultiMap();
    protected Set<SootMethod> secondarySinkMethods = new HashSet<SootMethod>();
    protected Set<SootClass> secondarySinkClasses = new HashSet<SootClass>();
    protected final InfoflowConfiguration.SourceSinkConfiguration sourceSinkConfig;
    protected final Set<SootMethod> excludedMethods = new HashSet<SootMethod>();
    protected boolean oneSourceAtATime = false;
    protected SourceType osaatType = SourceType.MethodCall;
    protected Iterator<SootMethod> osaatIterator = null;
    protected SootMethod currentSource = null;
    protected IValueProvider valueProvider = new SimpleConstantValueProvider();
    protected final LoadingCache<SootClass, Collection<SootClass>> parentClassesAndInterfaces = IDESolver.DEFAULT_CACHE_BUILDER.build((CacheLoader)new CacheLoader<SootClass, Collection<SootClass>>(){

        public Collection<SootClass> load(SootClass sc) throws Exception {
            Hierarchy h = Scene.v().getActiveHierarchy();
            if (sc.hasTag("SimulatedCodeElementTag")) {
                return Collections.emptySet();
            }
            if (sc.isInterface()) {
                return h.getSuperinterfacesOfIncluding(sc);
            }
            ArrayList<SootClass> res = new ArrayList<SootClass>();
            res.addAll(h.getSuperclassesOfIncluding(sc));
            res.addAll(res.stream().flatMap(c -> c.getInterfaces().stream()).flatMap(i -> {
                try {
                    return ((Collection)BaseSourceSinkManager.this.parentClassesAndInterfaces.get(i)).stream();
                }
                catch (ExecutionException e) {
                    throw new RuntimeException(e);
                }
            }).collect(Collectors.toList()));
            return res;
        }
    });

    public BaseSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, InfoflowConfiguration config) {
        this(sources, sinks, Collections.emptySet(), config);
    }

    public BaseSourceSinkManager(Collection<? extends ISourceSinkDefinition> sources, Collection<? extends ISourceSinkDefinition> sinks, Set<? extends CallbackDefinition> callbackMethods, InfoflowConfiguration config) {
        this.sourceSinkConfig = config.getSourceSinkConfig();
        this.sourceDefs = new HashMultiMap();
        for (ISourceSinkDefinition iSourceSinkDefinition : sources) {
            this.sourceDefs.put((Object)this.getSignature(iSourceSinkDefinition), (Object)iSourceSinkDefinition);
        }
        this.sourceCallbackMethods = new HashMap<SootMethod, ISourceSinkDefinition>();
        this.sinkDefs = new HashMultiMap();
        for (ISourceSinkDefinition iSourceSinkDefinition : sinks) {
            this.sinkDefs.put((Object)this.getSignature(iSourceSinkDefinition), (Object)iSourceSinkDefinition);
        }
        this.callbackMethods = new HashMap<SootMethod, CallbackDefinition>();
        for (CallbackDefinition callbackDefinition : callbackMethods) {
            this.callbackMethods.put(callbackDefinition.getTargetMethod(), callbackDefinition);
        }
        this.logger.info(String.format("Created a SourceSinkManager with %d sources, %d sinks, and %d callback methods.", this.sourceDefs.size(), this.sinkDefs.size(), this.callbackMethods.size()));
    }

    private void collectSourceCallbacks() {
        HashMultiMap subsigs = new HashMultiMap();
        for (ISourceSinkDefinition ssd : this.sourceDefs.values()) {
            MethodSourceSinkDefinition mssd;
            if (!(ssd instanceof MethodSourceSinkDefinition) || (mssd = (MethodSourceSinkDefinition)ssd).getCallType() != MethodSourceSinkDefinition.CallType.Callback) continue;
            subsigs.put((Object)mssd.getMethod().getSubSignature(), (Object)mssd);
        }
        FastHierarchy fh = Scene.v().getOrMakeFastHierarchy();
        for (SootClass sc : Scene.v().getApplicationClasses()) {
            for (SootMethod sm : sc.getMethods()) {
                String subsig;
                Set defs;
                if (!sm.isConcrete() || (defs = subsigs.get((Object)(subsig = sm.getSubSignature()))) == null || defs.isEmpty()) continue;
                for (MethodSourceSinkDefinition mssd : defs) {
                    SootClass sourceClass = Scene.v().getSootClassUnsafe(mssd.getMethod().getClassName());
                    if (sourceClass == null || !fh.canStoreClass(sc, sourceClass)) continue;
                    this.sourceCallbackMethods.put(sm, mssd);
                }
            }
        }
    }

    private String getSignature(ISourceSinkDefinition am) {
        if (am instanceof MethodSourceSinkDefinition) {
            MethodSourceSinkDefinition methodSource = (MethodSourceSinkDefinition)am;
            return methodSource.getMethod().getSignature();
        }
        if (am instanceof FieldSourceSinkDefinition) {
            FieldSourceSinkDefinition fieldSource = (FieldSourceSinkDefinition)am;
            return fieldSource.getFieldSignature();
        }
        if (am instanceof StatementSourceSinkDefinition) {
            return GLOBAL_SIG;
        }
        throw new RuntimeException(String.format("Invalid type of source/sink definition: %s", am.getClass().getName()));
    }

    protected Collection<ISourceSinkDefinition> getSinkDefinitions(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        Set def = this.sinkStatements.get((Object)sCallSite);
        if (def.size() > 0) {
            return def;
        }
        if (sCallSite.containsInvokeExpr()) {
            Set def2;
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            if (!SystemClassHandler.v().isTaintVisible(ap, callee)) {
                return Collections.emptySet();
            }
            Set def3 = this.sinkMethods.get((Object)sCallSite.getInvokeExpr().getMethod());
            if (def3.size() > 0) {
                return def3;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)sCallSite.getInvokeExpr().getMethod().getDeclaringClass())) {
                if (!i.declaresMethod(subSig) || (def2 = this.sinkMethods.get((Object)i.getMethod(subSig))).size() <= 0) continue;
                return def2;
            }
            for (SootMethod sm : manager.getICFG().getCalleesOfCallAt(sCallSite)) {
                def2 = this.sinkMethods.get((Object)sm);
                if (def2.size() <= 0) continue;
                return def2;
            }
        } else if (sCallSite instanceof AssignStmt) {
            FieldRef fieldRef;
            Set def4;
            AssignStmt assignStmt = (AssignStmt)sCallSite;
            if (assignStmt.getLeftOp() instanceof FieldRef && (def4 = this.sinkFields.get((Object)(fieldRef = (FieldRef)assignStmt.getLeftOp()).getField())).size() > 0) {
                return def4;
            }
        } else if (sCallSite instanceof ReturnStmt) {
            return this.sinkReturnMethods.get((Object)((SootMethod)manager.getICFG().getMethodOf(sCallSite)));
        }
        return Collections.emptySet();
    }

    protected Collection<ISourceSinkDefinition> getInverseSourceDefinition(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        ISourceSinkDefinition uiDef;
        Set defs = this.sourceStatements.get((Object)sCallSite);
        if (defs.size() > 0) {
            return defs;
        }
        if (sCallSite.containsInvokeExpr()) {
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            if (!SystemClassHandler.v().isTaintVisible(ap, callee)) {
                return Collections.emptySet();
            }
            Collection<ISourceSinkDefinition> defs2 = this.getSourceDefinition(callee);
            if (defs2.size() > 0) {
                return defs2;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)callee.getDeclaringClass())) {
                SootMethod m = i.getMethodUnsafe(subSig);
                if (m == null || (defs2 = this.getSourceDefinition(m)).size() <= 0) continue;
                return defs2;
            }
            for (SootMethod sm : manager.getICFG().getCalleesOfCallAt(sCallSite)) {
                defs2 = this.getSourceDefinition(sm);
                if (defs2.size() <= 0) continue;
                return defs2;
            }
        }
        if ((uiDef = this.getUISourceDefinition(sCallSite, manager.getICFG())) != null) {
            return Collections.singleton(uiDef);
        }
        ISourceSinkDefinition callbackDef = this.checkCallbackParamSource(sCallSite, manager.getICFG());
        if (callbackDef != null) {
            return Collections.singleton(callbackDef);
        }
        Collection<ISourceSinkDefinition> fieldDefs = this.checkFieldSource(sCallSite, manager.getICFG());
        if (fieldDefs != null) {
            return fieldDefs;
        }
        return Collections.emptySet();
    }

    @Override
    public SinkInfo getSinkInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        if (this.excludedMethods.contains(manager.getICFG().getMethodOf(sCallSite))) {
            return null;
        }
        if (sCallSite.hasTag("SimulatedCodeElementTag")) {
            return null;
        }
        Collection<ISourceSinkDefinition> def = this.getSinkDefinitions(sCallSite, manager, ap);
        return def.size() > 0 ? new SinkInfo(def) : null;
    }

    @Override
    public SinkInfo getInverseSourceInfo(Stmt sCallSite, InfoflowManager manager, AccessPath ap) {
        if (this.oneSourceAtATime) {
            this.logger.error("This does not support one source at a time for inverse methods.");
            return null;
        }
        Collection<ISourceSinkDefinition> defs = this.getInverseSourceDefinition(sCallSite, manager, ap);
        return defs.size() > 0 ? new SinkInfo(defs) : null;
    }

    @Override
    public SourceInfo getSourceInfo(Stmt sCallSite, InfoflowManager manager) {
        if (this.excludedMethods.contains(manager.getICFG().getMethodOf(sCallSite))) {
            return null;
        }
        if (sCallSite.hasTag("SimulatedCodeElementTag")) {
            return null;
        }
        Collection<ISourceSinkDefinition> defs = this.getSource(sCallSite, manager.getICFG());
        Collection<Pair<AccessPath, ISourceSinkDefinition>> pairs = this.createSourceInfoPairs(sCallSite, manager, defs);
        return pairs.size() > 0 ? new SourceInfo(pairs) : null;
    }

    @Override
    public SourceInfo getInverseSinkInfo(Stmt sCallSite, InfoflowManager manager) {
        if (this.oneSourceAtATime) {
            this.logger.error("This does not support one source at a time for inverse methods.");
            return null;
        }
        if (this.excludedMethods.contains(manager.getICFG().getMethodOf(sCallSite))) {
            return null;
        }
        if (sCallSite.hasTag("SimulatedCodeElementTag")) {
            return null;
        }
        Collection<ISourceSinkDefinition> defs = this.getInverseSinkDefinition(sCallSite, manager.getICFG());
        Collection<Pair<AccessPath, ISourceSinkDefinition>> pairs = this.createInverseSinkInfoPairs(sCallSite, manager, defs);
        return pairs.size() > 0 ? new SourceInfo(pairs) : null;
    }

    protected Collection<Pair<AccessPath, ISourceSinkDefinition>> createSourceInfoPairs(Stmt sCallSite, InfoflowManager manager, Collection<ISourceSinkDefinition> defs) {
        HashSet<Pair<AccessPath, ISourceSinkDefinition>> sourcePairs = new HashSet<Pair<AccessPath, ISourceSinkDefinition>>();
        for (ISourceSinkDefinition def : defs) {
            AccessPath ap;
            if (!sCallSite.containsInvokeExpr()) {
                if (!(sCallSite instanceof DefinitionStmt)) continue;
                DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
                AccessPath ap2 = manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
                sourcePairs.add((Pair<AccessPath, ISourceSinkDefinition>)new Pair((Object)ap2, (Object)def));
                continue;
            }
            InvokeExpr iexpr = sCallSite.getInvokeExpr();
            Type returnType = iexpr.getMethod().getReturnType();
            if (sCallSite instanceof DefinitionStmt && returnType != null && returnType != VoidType.v()) {
                DefinitionStmt defStmt = (DefinitionStmt)sCallSite;
                ap = manager.getAccessPathFactory().createAccessPath(defStmt.getLeftOp(), null, null, true, false, true, AccessPath.ArrayTaintType.ContentsAndLength, false);
                sourcePairs.add((Pair<AccessPath, ISourceSinkDefinition>)new Pair((Object)ap, (Object)def));
                continue;
            }
            if (!(iexpr instanceof InstanceInvokeExpr) || returnType != VoidType.v()) continue;
            InstanceInvokeExpr iinv = (InstanceInvokeExpr)sCallSite.getInvokeExpr();
            ap = manager.getAccessPathFactory().createAccessPath(iinv.getBase(), true);
            sourcePairs.add((Pair<AccessPath, ISourceSinkDefinition>)new Pair((Object)ap, (Object)def));
        }
        return sourcePairs;
    }

    protected Collection<Pair<AccessPath, ISourceSinkDefinition>> createInverseSinkInfoPairs(Stmt sCallSite, InfoflowManager manager, Collection<ISourceSinkDefinition> defs) {
        HashSet<Pair<AccessPath, ISourceSinkDefinition>> pairs = new HashSet<Pair<AccessPath, ISourceSinkDefinition>>();
        for (ISourceSinkDefinition def : defs) {
            HashSet<AccessPath> aps = new HashSet<AccessPath>();
            if (sCallSite.containsInvokeExpr()) {
                InvokeExpr iExpr = sCallSite.getInvokeExpr();
                for (Value arg : iExpr.getArgs()) {
                    if (arg instanceof Constant) continue;
                    aps.add(manager.getAccessPathFactory().createAccessPath(arg, true));
                }
                if (iExpr instanceof InstanceInvokeExpr) {
                    InstanceInvokeExpr iiExpr = (InstanceInvokeExpr)iExpr;
                    aps.add(manager.getAccessPathFactory().createAccessPath(iiExpr.getBase(), true));
                }
            } else if (sCallSite instanceof AssignStmt) {
                AssignStmt assignStmt = (AssignStmt)sCallSite;
                for (InstanceInvokeExpr rightVal : BaseSelector.selectBaseList(assignStmt.getRightOp(), true)) {
                    aps.add(manager.getAccessPathFactory().createAccessPath((Value)rightVal, true));
                }
            } else if (sCallSite instanceof ReturnStmt) {
                ReturnStmt retStmt = (ReturnStmt)sCallSite;
                aps.add(manager.getAccessPathFactory().createAccessPath(retStmt.getOp(), true));
            }
            for (AccessPath ap : aps) {
                pairs.add((Pair<AccessPath, ISourceSinkDefinition>)new Pair((Object)ap, (Object)def));
            }
            if (!pairs.isEmpty() || manager.getConfig().getImplicitFlowMode() == InfoflowConfiguration.ImplicitFlowMode.NoImplicitFlows) continue;
            pairs.add((Pair<AccessPath, ISourceSinkDefinition>)new Pair((Object)AccessPath.getEmptyAccessPath(), (Object)def));
        }
        return pairs;
    }

    protected Collection<ISourceSinkDefinition> getSourceMethod(SootMethod method) {
        if (this.oneSourceAtATime && (this.osaatType != SourceType.MethodCall || this.currentSource != method)) {
            return null;
        }
        return this.sourceMethods.get((Object)method);
    }

    protected Collection<ISourceSinkDefinition> getInverseSourceMethod(SootMethod method) {
        if (this.oneSourceAtATime && (this.osaatType != SourceType.MethodCall || this.currentSource != method)) {
            return null;
        }
        return this.sinkMethods.get((Object)method);
    }

    protected Collection<ISourceSinkDefinition> getSourceDefinition(SootMethod method) {
        return this.getDefsFromMap(this.sourceMethods, method);
    }

    private Collection<ISourceSinkDefinition> getDefsFromMap(MultiMap<SootMethod, ISourceSinkDefinition> map, SootMethod method) {
        if (this.oneSourceAtATime) {
            if (this.osaatType == SourceType.MethodCall && this.currentSource == method) {
                return map.get((Object)method);
            }
            return null;
        }
        return map.get((Object)method);
    }

    protected CallbackDefinition getCallbackDefinition(SootMethod method) {
        if (this.oneSourceAtATime) {
            if (this.osaatType == SourceType.Callback && this.currentSource == method) {
                return this.callbackMethods.get(method);
            }
            return null;
        }
        return this.callbackMethods.get(method);
    }

    protected Collection<ISourceSinkDefinition> getSource(Stmt sCallSite, IInfoflowCFG cfg) {
        ISourceSinkDefinition uiDef;
        assert (cfg != null);
        assert (cfg instanceof BiDiInterproceduralCFG);
        Set defs = this.sourceStatements.get((Object)sCallSite);
        if (defs.size() > 0) {
            return defs;
        }
        if ((!this.oneSourceAtATime || this.osaatType == SourceType.MethodCall) && sCallSite.containsInvokeExpr()) {
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            Collection<ISourceSinkDefinition> defs2 = this.getSourceDefinition(callee);
            if (defs2.size() > 0) {
                return defs2;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)callee.getDeclaringClass())) {
                SootMethod m = i.getMethodUnsafe(subSig);
                if (m == null || (defs2 = this.getSourceDefinition(m)).size() <= 0) continue;
                return defs2;
            }
            for (SootMethod sm : cfg.getCalleesOfCallAt(sCallSite)) {
                defs2 = this.getSourceDefinition(sm);
                if (defs2.size() <= 0) continue;
                return defs2;
            }
        }
        if (!(this.oneSourceAtATime && this.osaatType != SourceType.UISource || (uiDef = this.getUISourceDefinition(sCallSite, cfg)) == null)) {
            return Collections.singleton(uiDef);
        }
        ISourceSinkDefinition callbackDef = this.checkCallbackParamSource(sCallSite, cfg);
        if (callbackDef != null) {
            return Collections.singleton(callbackDef);
        }
        Collection<ISourceSinkDefinition> fieldDefs = this.checkFieldSource(sCallSite, cfg);
        if (fieldDefs.size() > 0) {
            return fieldDefs;
        }
        return Collections.emptySet();
    }

    protected Collection<ISourceSinkDefinition> getInverseSinkDefinition(Stmt sCallSite, IInfoflowCFG cfg) {
        Set defs = this.sinkStatements.get((Object)sCallSite);
        if (defs.size() > 0) {
            return defs;
        }
        if ((!this.oneSourceAtATime || this.osaatType == SourceType.MethodCall) && sCallSite.containsInvokeExpr()) {
            Set defs2;
            SootMethod callee = sCallSite.getInvokeExpr().getMethod();
            Set defs3 = this.sinkMethods.get((Object)callee);
            if (defs3.size() > 0) {
                return defs3;
            }
            String subSig = callee.getSubSignature();
            for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)callee.getDeclaringClass())) {
                if (!i.declaresMethod(subSig) || (defs2 = this.sinkMethods.get((Object)i.getMethod(subSig))).size() <= 0) continue;
                return defs2;
            }
            for (SootMethod sm : cfg.getCalleesOfCallAt(sCallSite)) {
                defs2 = this.sinkMethods.get((Object)sm);
                if (defs2.size() <= 0) continue;
                return defs2;
            }
        } else if (sCallSite instanceof AssignStmt) {
            FieldRef fieldRef;
            Set defs4;
            AssignStmt assignStmt = (AssignStmt)sCallSite;
            if (assignStmt.getLeftOp() instanceof FieldRef && (defs4 = this.sinkFields.get((Object)(fieldRef = (FieldRef)assignStmt.getLeftOp()).getField())).size() > 0) {
                return defs4;
            }
        } else if (sCallSite instanceof ReturnStmt) {
            return this.sinkReturnMethods.get((Object)((SootMethod)cfg.getMethodOf(sCallSite)));
        }
        return Collections.emptySet();
    }

    private Collection<ISourceSinkDefinition> checkFieldSource(Stmt stmt, IInfoflowCFG cfg) {
        AssignStmt assignStmt;
        if (stmt instanceof AssignStmt && (assignStmt = (AssignStmt)stmt).getRightOp() instanceof FieldRef) {
            FieldRef fieldRef = (FieldRef)assignStmt.getRightOp();
            return this.sourceFields.get((Object)fieldRef.getField());
        }
        return Collections.emptySet();
    }

    protected ISourceSinkDefinition checkCallbackParamSource(Stmt sCallSite, IInfoflowCFG cfg) {
        CallbackDefinition def;
        if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.NoParametersAsSources) {
            return null;
        }
        if (this.oneSourceAtATime && this.osaatType != SourceType.Callback) {
            return null;
        }
        if (!(sCallSite instanceof IdentityStmt)) {
            return null;
        }
        IdentityStmt is = (IdentityStmt)sCallSite;
        if (!(is.getRightOp() instanceof ParameterRef)) {
            return null;
        }
        ParameterRef paramRef = (ParameterRef)is.getRightOp();
        SootMethod parentMethod = (SootMethod)cfg.getMethodOf(sCallSite);
        if (parentMethod == null) {
            return null;
        }
        if (!this.sourceSinkConfig.getEnableLifecycleSources() && this.isEntryPointMethod(parentMethod)) {
            return null;
        }
        if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.AllParametersAsSources && (def = this.getCallbackDefinition(parentMethod)) != null) {
            return MethodSourceSinkDefinition.createParameterSource(paramRef.getIndex(), MethodSourceSinkDefinition.CallType.Callback);
        }
        ISourceSinkDefinition sourceSinkDef = this.sourceCallbackMethods.get(parentMethod);
        if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
            Set<AccessPathTuple> apTuples;
            Set<AccessPathTuple>[] methodParamDefs;
            MethodSourceSinkDefinition methodDef = (MethodSourceSinkDefinition)sourceSinkDef;
            if (this.sourceSinkConfig.getCallbackSourceMode() == InfoflowConfiguration.CallbackSourceMode.SourceListOnly && sourceSinkDef != null && (methodParamDefs = methodDef.getParameters()) != null && methodParamDefs.length > paramRef.getIndex() && (apTuples = methodDef.getParameters()[paramRef.getIndex()]) != null && !apTuples.isEmpty()) {
                for (AccessPathTuple curTuple : apTuples) {
                    if (!curTuple.getSourceSinkType().isSource()) continue;
                    return sourceSinkDef;
                }
            }
        }
        return null;
    }

    protected abstract boolean isEntryPointMethod(SootMethod var1);

    protected ISourceSinkDefinition getUISourceDefinition(Stmt sCallSite, IInfoflowCFG cfg) {
        return null;
    }

    private void initializeConditions(SootMethod m, ISourceSinkDefinition def) {
        if (m == null || def.getConditions() == null || def.getConditions().isEmpty()) {
            return;
        }
        this.conditionalSinks.add(m);
        for (SourceSinkCondition cond : def.getConditions()) {
            this.conditionalSinkToExcludedClasses.putAll((Object)m, cond.getExcludedClasses());
            this.secondarySinkMethods.addAll(cond.getReferencedMethods());
            this.secondarySinkClasses.addAll(cond.getReferencedClasses());
        }
    }

    @Override
    public void initialize() {
        StatementSourceSinkDefinition sssd;
        SootField sf;
        ISourceSinkDefinition sourceSinkDef;
        if (this.sourceDefs != null) {
            this.collectSourceCallbacks();
            this.sourceMethods = new HashMultiMap();
            this.sourceFields = new HashMultiMap();
            this.sourceStatements = new HashMultiMap();
            for (Pair entry : this.sourceDefs) {
                sourceSinkDef = (ISourceSinkDefinition)entry.getO2();
                if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
                    SootMethodAndClass method = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod();
                    String returnType = method.getReturnType();
                    if (returnType == null || returnType.isEmpty()) {
                        String subSignatureWithoutReturnType;
                        String className = method.getClassName();
                        SootMethod sootMethod = this.grabMethodWithoutReturn(className, subSignatureWithoutReturnType = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod().getSubSignature());
                        if (sootMethod == null) continue;
                        this.sourceMethods.put((Object)sootMethod, (Object)sourceSinkDef);
                        continue;
                    }
                    SootMethod sm = this.grabMethod((String)entry.getO1());
                    if (sm == null) continue;
                    this.sourceMethods.put((Object)sm, (Object)sourceSinkDef);
                    continue;
                }
                if (sourceSinkDef instanceof FieldSourceSinkDefinition) {
                    sf = Scene.v().grabField((String)entry.getO1());
                    if (sf == null) continue;
                    this.sourceFields.put((Object)sf, (Object)sourceSinkDef);
                    continue;
                }
                if (!(sourceSinkDef instanceof StatementSourceSinkDefinition)) continue;
                sssd = (StatementSourceSinkDefinition)sourceSinkDef;
                this.sourceStatements.put((Object)sssd.getStmt(), (Object)sssd);
            }
            this.sourceDefs = null;
        }
        if (this.sinkDefs != null) {
            this.sinkMethods = new HashMultiMap();
            this.sinkFields = new HashMultiMap();
            this.sinkReturnMethods = new HashMultiMap();
            this.sinkStatements = new HashMultiMap();
            for (Pair entry : this.sinkDefs) {
                sourceSinkDef = (ISourceSinkDefinition)entry.getO2();
                if (sourceSinkDef instanceof MethodSourceSinkDefinition) {
                    boolean isMethodWithoutReturnType;
                    SootMethodAndClass method;
                    MethodSourceSinkDefinition methodSourceSinkDef = (MethodSourceSinkDefinition)sourceSinkDef;
                    if (methodSourceSinkDef.getCallType() == MethodSourceSinkDefinition.CallType.Return) {
                        method = methodSourceSinkDef.getMethod();
                        SootMethod m = Scene.v().grabMethod(method.getSignature());
                        if (m == null) continue;
                        this.sinkReturnMethods.put((Object)m, (Object)methodSourceSinkDef);
                        this.initializeConditions(m, methodSourceSinkDef);
                        continue;
                    }
                    method = methodSourceSinkDef.getMethod();
                    String returnType = method.getReturnType();
                    boolean bl = isMethodWithoutReturnType = returnType == null || returnType.isEmpty();
                    if (isMethodWithoutReturnType) {
                        String subSignatureWithoutReturnType;
                        String className = method.getClassName();
                        SootMethod sootMethod = this.grabMethodWithoutReturn(className, subSignatureWithoutReturnType = ((MethodSourceSinkDefinition)sourceSinkDef).getMethod().getSubSignature());
                        if (sootMethod == null) continue;
                        this.sinkMethods.put((Object)sootMethod, (Object)sourceSinkDef);
                        this.initializeConditions(sootMethod, methodSourceSinkDef);
                        continue;
                    }
                    SootMethod sm = this.grabMethod((String)entry.getO1());
                    if (sm == null) continue;
                    this.sinkMethods.put((Object)sm, (Object)((ISourceSinkDefinition)entry.getO2()));
                    this.initializeConditions(sm, methodSourceSinkDef);
                    continue;
                }
                if (sourceSinkDef instanceof FieldSourceSinkDefinition) {
                    sf = Scene.v().grabField((String)entry.getO1());
                    if (sf == null) continue;
                    this.sinkFields.put((Object)sf, (Object)sourceSinkDef);
                    continue;
                }
                if (!(sourceSinkDef instanceof StatementSourceSinkDefinition)) continue;
                sssd = (StatementSourceSinkDefinition)sourceSinkDef;
                this.sinkStatements.put((Object)sssd.getStmt(), (Object)sssd);
            }
            this.sinkDefs = null;
        }
    }

    private SootMethod matchMethodWithoutReturn(SootClass sootClass, String subSignature) {
        if (sootClass.resolvingLevel() == 0) {
            List sootMethods = sootClass.getMethods();
            for (SootMethod s : sootMethods) {
                String[] tempSignature = s.getSubSignature().split(" ");
                if (tempSignature.length != 2 || !tempSignature[1].equals(subSignature)) continue;
                return s;
            }
        }
        return null;
    }

    private SootMethod grabMethodWithoutReturn(String sootClassName, String subSignature) {
        SootClass sootClass = Scene.v().getSootClassUnsafe(sootClassName);
        if (sootClass == null) {
            return null;
        }
        SootMethod sootMethod = this.matchMethodWithoutReturn(sootClass, subSignature);
        if (sootMethod != null) {
            return sootMethod;
        }
        for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)sootClass)) {
            sootMethod = this.matchMethodWithoutReturn(i, subSignature);
            if (sootMethod == null) continue;
            return sootMethod;
        }
        return null;
    }

    private SootMethod grabMethod(String signature) {
        String sootClassName = Scene.signatureToClass((String)signature);
        SootClass sootClass = Scene.v().getSootClassUnsafe(sootClassName);
        if (sootClass == null) {
            return null;
        }
        String subSignature = Scene.signatureToSubsignature((String)signature);
        SootMethod sootMethod = sootClass.getMethodUnsafe(subSignature);
        if (sootMethod != null) {
            return sootMethod;
        }
        for (SootClass i : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)sootClass)) {
            sootMethod = i.getMethodUnsafe(subSignature);
            if (sootMethod == null) continue;
            return sootMethod;
        }
        return null;
    }

    @Override
    public void setOneSourceAtATimeEnabled(boolean enabled) {
        this.oneSourceAtATime = enabled;
    }

    @Override
    public boolean isOneSourceAtATimeEnabled() {
        return this.oneSourceAtATime;
    }

    @Override
    public void resetCurrentSource() {
        this.osaatIterator = this.sourceMethods.keySet().iterator();
        this.osaatType = SourceType.MethodCall;
    }

    @Override
    public void nextSource() {
        if (this.osaatType == SourceType.MethodCall || this.osaatType == SourceType.Callback) {
            this.currentSource = this.osaatIterator.next();
        }
    }

    @Override
    public boolean hasNextSource() {
        if (this.osaatType == SourceType.MethodCall) {
            if (this.osaatIterator.hasNext()) {
                return true;
            }
            this.osaatType = SourceType.Callback;
            this.osaatIterator = this.callbackMethods.keySet().iterator();
            return this.hasNextSource();
        }
        if (this.osaatType == SourceType.Callback) {
            if (this.osaatIterator.hasNext()) {
                return true;
            }
            this.osaatType = SourceType.UISource;
            return true;
        }
        if (this.osaatType == SourceType.UISource) {
            this.osaatType = SourceType.NoSource;
            return false;
        }
        return false;
    }

    public void excludeMethod(SootMethod toExclude) {
        this.excludedMethods.add(toExclude);
    }

    @Override
    public boolean isSecondarySink(Stmt stmt) {
        if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) {
            return false;
        }
        SootMethod callee = stmt.getInvokeExpr().getMethod();
        SootClass dc = callee.getDeclaringClass();
        if (this.secondarySinkMethods.contains(callee) || this.secondarySinkClasses.contains(dc)) {
            return true;
        }
        for (SootClass superClass : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)dc)) {
            if (this.secondarySinkClasses.contains(superClass)) {
                return true;
            }
            SootMethod superMethod = superClass.getMethodUnsafe(callee.getSubSignature());
            if (!this.secondarySinkMethods.contains(superMethod)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void registerSecondarySink(Stmt stmt) {
        this.secondarySinkMethods.add(stmt.getInvokeExpr().getMethod());
    }

    @Override
    public void registerSecondarySink(SootMethod sm) {
        this.secondarySinkMethods.add(sm);
    }

    private boolean isExcludedInCondition(SootMethod matchedSink, SootClass baseClass) {
        Set excludedClasses = this.conditionalSinkToExcludedClasses.get((Object)matchedSink);
        if (excludedClasses.contains(baseClass)) {
            return true;
        }
        for (SootClass sc : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)matchedSink.getDeclaringClass())) {
            if (!excludedClasses.contains(sc)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isConditionalSink(Stmt stmt, SootClass baseClass) {
        if (!stmt.containsInvokeExpr() || !(stmt.getInvokeExpr() instanceof InstanceInvokeExpr)) {
            return false;
        }
        SootMethod callee = stmt.getInvokeExpr().getMethod();
        if (this.conditionalSinks.contains(callee)) {
            return !this.isExcludedInCondition(callee, baseClass);
        }
        for (SootClass sc : (Collection)this.parentClassesAndInterfaces.getUnchecked((Object)callee.getDeclaringClass())) {
            SootMethod superMethod = sc.getMethodUnsafe(callee.getSubSignature());
            if (!this.conditionalSinks.contains(superMethod)) continue;
            return !this.isExcludedInCondition(superMethod, baseClass);
        }
        return false;
    }

    public static enum SourceType {
        NoSource,
        MethodCall,
        Callback,
        UISource;

    }
}

