/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.taintWrappers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import soot.SootMethod;
import soot.jimple.Stmt;
import soot.jimple.infoflow.InfoflowManager;
import soot.jimple.infoflow.data.Abstraction;
import soot.jimple.infoflow.handlers.PreAnalysisHandler;
import soot.jimple.infoflow.taintWrappers.IReversibleTaintWrapper;
import soot.jimple.infoflow.taintWrappers.ITaintPropagationWrapper;

public class TaintWrapperSet
implements IReversibleTaintWrapper {
    private Set<ITaintPropagationWrapper> wrappers = new HashSet<ITaintPropagationWrapper>();
    private AtomicInteger hits = new AtomicInteger();
    private AtomicInteger misses = new AtomicInteger();

    @Override
    public void initialize(InfoflowManager manager) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            w.initialize(manager);
        }
    }

    @Override
    public Collection<PreAnalysisHandler> getPreAnalysisHandlers() {
        ArrayList<PreAnalysisHandler> lst = new ArrayList<PreAnalysisHandler>();
        for (ITaintPropagationWrapper wrapper : this.wrappers) {
            lst.addAll(wrapper.getPreAnalysisHandlers());
        }
        return lst;
    }

    public void addWrapper(ITaintPropagationWrapper wrapper) {
        this.wrappers.add(wrapper);
    }

    @Override
    public Set<Abstraction> getTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        HashSet<Abstraction> resList = new HashSet<Abstraction>();
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet = w.getTaintsForMethod(stmt, d1, taintedPath);
            if (curAbsSet == null || curAbsSet.isEmpty()) continue;
            resList.addAll(curAbsSet);
        }
        if (resList.isEmpty()) {
            this.misses.incrementAndGet();
        } else {
            this.hits.incrementAndGet();
        }
        return resList;
    }

    @Override
    public boolean isExclusive(Stmt stmt, Abstraction taintedPath) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.isExclusive(stmt, taintedPath)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCallee(SootMethod method) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.supportsCallee(method)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean supportsCallee(Stmt callSite) {
        for (ITaintPropagationWrapper w : this.wrappers) {
            if (!w.supportsCallee(callSite)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getWrapperHits() {
        return this.hits.get();
    }

    @Override
    public int getWrapperMisses() {
        return this.misses.get();
    }

    @Override
    public Set<Abstraction> getAliasesForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        HashSet<Abstraction> resList = new HashSet<Abstraction>();
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet = w.getAliasesForMethod(stmt, d1, taintedPath);
            if (curAbsSet == null || curAbsSet.isEmpty()) continue;
            resList.addAll(curAbsSet);
        }
        return resList;
    }

    @Override
    public Set<Abstraction> getInverseTaintsForMethod(Stmt stmt, Abstraction d1, Abstraction taintedPath) {
        HashSet<Abstraction> resList = new HashSet<Abstraction>();
        for (ITaintPropagationWrapper w : this.wrappers) {
            Set<Abstraction> curAbsSet;
            if (!(w instanceof IReversibleTaintWrapper) || (curAbsSet = ((IReversibleTaintWrapper)w).getInverseTaintsForMethod(stmt, d1, taintedPath)) == null || curAbsSet.isEmpty()) continue;
            resList.addAll(curAbsSet);
        }
        return resList;
    }
}

