/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util;

import com.google.common.collect.Sets;
import com.google.common.html.HtmlEscapers;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import soot.jimple.infoflow.data.Abstraction;
import soot.util.IdentityHashSet;

public final class DebugAbstractionTree {
    private static final Logger logger = LoggerFactory.getLogger(DebugAbstractionTree.class);

    private DebugAbstractionTree() {
    }

    public static String createDotGraph(Abstraction absStart, boolean printNeighbors) {
        return DebugAbstractionTree.createDotGraph(absStart, printNeighbors, false);
    }

    public static String createDotGraph(Abstraction absStart, boolean printNeighbors, boolean verbose) {
        int i;
        IdentityHashMap<Abstraction, Integer> absToId = new IdentityHashMap<Abstraction, Integer>();
        ArrayDeque<Abstraction> workQueue = new ArrayDeque<Abstraction>();
        StringBuilder sbNodes = new StringBuilder();
        StringBuilder sbEdges = new StringBuilder();
        int idCounter = 0;
        workQueue.add(absStart);
        while (!workQueue.isEmpty()) {
            Abstraction p = (Abstraction)workQueue.poll();
            Integer id = (Integer)absToId.get(p);
            if (id != null) continue;
            absToId.put(p, ++idCounter);
            Object absName = String.valueOf(idCounter);
            if (p.getSourceContext() != null) {
                absName = (String)absName + " [source]";
            }
            if (verbose) {
                absName = (String)absName + "<br>";
                absName = (String)absName + DebugAbstractionTree.escape(p.toString());
                if (p.getCurrentStmt() != null) {
                    absName = (String)absName + "<br>@ ";
                    absName = (String)absName + p.getCurrentStmt().toString();
                    int ln = p.getCurrentStmt().getJavaSourceStartLineNumber();
                    if (ln != -1) {
                        absName = (String)absName + " in line ";
                    }
                }
            }
            absName = p.isAbstractionActive() ? absName : "-" + (String)absName;
            logger.info(idCounter + ": " + p);
            StringBuilder neighbors = new StringBuilder();
            for (i = 0; i < p.getNeighborCount(); ++i) {
                neighbors.append(String.format("|<n%d> n%d", i, i));
            }
            if (p.getNeighborCount() > 0 && printNeighbors) {
                workQueue.addAll(p.getNeighbors());
            }
            if (p.getPredecessor() != null) {
                workQueue.add(p.getPredecessor());
            }
            sbNodes.append(String.format("    abs%d[label=\"{%s|{<a> A%s}}\"];\n", idCounter, absName, neighbors.toString()));
        }
        workQueue.add(absStart);
        IdentityHashSet seen = new IdentityHashSet();
        while (!workQueue.isEmpty()) {
            Abstraction p = (Abstraction)workQueue.poll();
            if (!seen.add(p)) continue;
            Integer id = (Integer)absToId.get(p);
            Abstraction pred = p.getPredecessor();
            if (pred != null) {
                int dest = (Integer)absToId.get(pred);
                sbEdges.append(String.format("    abs%s:a -> abs%d;\n", id, dest));
                workQueue.add(pred);
            }
            if (p.getNeighborCount() <= 0 || !printNeighbors) continue;
            i = 0;
            for (Abstraction n : p.getNeighbors()) {
                int dest = (Integer)absToId.get(n);
                sbEdges.append(String.format("    abs%s:n%s -> abs%d;\n", id, i, dest));
                ++i;
            }
            workQueue.addAll(p.getNeighbors());
        }
        return "digraph Debug {\n    node [shape=record];\n" + sbNodes.toString() + sbEdges.toString() + "}";
    }

    private static String escape(String string) {
        return HtmlEscapers.htmlEscaper().escape(string).replace("|", "\\|");
    }

    public static long countNodes(Abstraction abs) {
        Set visited = Sets.newIdentityHashSet();
        ArrayDeque<Abstraction> worklist = new ArrayDeque<Abstraction>();
        worklist.add(abs);
        while (!worklist.isEmpty()) {
            Abstraction curr = (Abstraction)worklist.poll();
            if (!visited.add(curr)) continue;
            if (curr.getPredecessor() != null) {
                worklist.add(curr.getPredecessor());
            }
            if (curr.getNeighborCount() <= 0) continue;
            worklist.addAll(curr.getNeighbors());
        }
        return visited.size();
    }
}

