/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.util.extensiblelist;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;

public class ExtensibleList<T> {
    ExtensibleList<T> previous;
    int size;
    int lastLocked = -1;
    private List<T> actualList = null;
    private int previousLockedAt;
    private int savedHashCode = Integer.MIN_VALUE;
    private int parentHashCode;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ExtensibleList(ExtensibleList<T> original) {
        ExtensibleList<T> extensibleList = original;
        synchronized (extensibleList) {
            this.size = original.size;
            this.previous = original;
            if (original.actualList != null) {
                this.previousLockedAt = original.actualList.size();
                original.lastLocked = Math.min(original.lastLocked, original.actualList.size());
                if (original.lastLocked == -1) {
                    original.lastLocked = original.actualList.size();
                }
            } else if (original.previous != null) {
                this.previousLockedAt = original.previousLockedAt;
                this.previous = original.previous;
            } else {
                this.previousLockedAt = 0;
            }
            this.parentHashCode = original.onlyElementHashCode();
        }
    }

    public int hashCode() {
        return this.onlyElementHashCode() ^ this.size * 15;
    }

    private int onlyElementHashCode() {
        if (this.savedHashCode != Integer.MIN_VALUE) {
            return this.savedHashCode;
        }
        int h = this.parentHashCode;
        if (this.actualList != null) {
            for (T l : this.actualList) {
                h = 31 * h + l.hashCode();
            }
        }
        this.savedHashCode = h;
        return h;
    }

    public ExtensibleList() {
        this.previousLockedAt = -1;
        this.parentHashCode = 0;
    }

    public int size() {
        return this.size;
    }

    public ExtensibleList<T> add(T add) {
        if (this.actualList == null) {
            this.actualList = new ArrayList<T>(4);
        }
        this.actualList.add(add);
        ++this.size;
        this.savedHashCode = Integer.MIN_VALUE;
        return this;
    }

    private void printStats() {
        int i = 0;
        int max = 0;
        int min = 0;
        ExtensibleList<T> list = this;
        while (list != null) {
            ++i;
            if (list.actualList != null) {
                max = Math.max(max, list.actualList.size());
            }
            if (list.actualList != null) {
                min = Math.min(min, list.actualList.size());
            }
            list = list.previous;
        }
        System.out.println(String.format("%d list parts for %d elements, min: %d, max: %d", i, this.size, min, max));
    }

    public ExtensibleList<T> addAll(T ... add) {
        for (int i = 0; i < add.length; ++i) {
            this.add(add[i]);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public Object removeLast() {
        return this.getOrRemoveLast(true);
    }

    public ExtensibleListIterator<T> reverseIterator() {
        ListIterator<T> itStart = this.actualList != null ? this.actualList.listIterator(this.actualList.size()) : null;
        return new ExtensibleListIterator<T>(this, itStart);
    }

    public T getLast() {
        return (T)this.getOrRemoveLast(false);
    }

    /*
     * Exception decompiling
     */
    private Object getOrRemoveLast(boolean remove) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public boolean equals(Object obj) {
        T t2;
        T t1;
        ExtensibleList other = (ExtensibleList)obj;
        if (other.size != this.size) {
            return false;
        }
        if (this.previous == other.previous) {
            if (this.previousLockedAt != other.previousLockedAt) {
                return false;
            }
            if (this.actualList == null || this.actualList.isEmpty()) {
                return other.actualList == null || other.actualList.isEmpty();
            }
            return this.actualList.equals(other.actualList);
        }
        ExtensibleListIterator<T> it1 = this.reverseIterator();
        ExtensibleListIterator<T> it2 = other.reverseIterator();
        do {
            boolean i2;
            boolean i1;
            if ((i1 = it1.hasNext()) != (i2 = it2.hasNext())) {
                return false;
            }
            if (!i1) {
                return true;
            }
            if (!it1.isSamePosition(it2)) continue;
            return true;
        } while ((t1 = it1.next()).equals(t2 = it2.next()));
        return false;
    }

    public T getFirstSlow() {
        ExtensibleList<T> list = this;
        T first = null;
        while (true) {
            if (list.actualList != null) {
                first = list.actualList.get(0);
            }
            if (list.previous == null) break;
            list = list.previous;
        }
        return first;
    }

    public ExtensibleList<T> addFirstSlow(T toAdd) {
        ExtensibleList<T> list = new ExtensibleList<T>();
        list.actualList = new LinkedList<T>();
        ExtensibleListIterator<T> it = this.reverseIterator();
        while (it.hasNext()) {
            list.actualList.add(0, it.next());
        }
        list.actualList.add(0, toAdd);
        list.size = this.size + 1;
        return list;
    }

    public String toString() {
        ArrayList<T> res = new ArrayList<T>();
        ExtensibleListIterator<T> it = this.reverseIterator();
        while (it.hasNext()) {
            res.add(it.next());
        }
        Collections.reverse(res);
        return ((Object)res).toString();
    }

    public List<T> getActualList() {
        return this.actualList;
    }

    private static class ExtensibleListIterator<T>
    implements Iterator<T> {
        ExtensibleList<T> list;
        private ListIterator<T> it;

        public ExtensibleListIterator(ExtensibleList<T> start, ListIterator<T> itStart) {
            this.list = start;
            this.it = itStart;
        }

        @Override
        public boolean hasNext() {
            if (this.list == null) {
                return false;
            }
            if (this.it == null || !this.it.hasPrevious()) {
                while (true) {
                    int l = this.list.previousLockedAt;
                    this.list = this.list.previous;
                    if (this.list == null) {
                        return false;
                    }
                    if (this.list.actualList == null) continue;
                    if (l < 0) {
                        l = this.list.actualList.size();
                    }
                    if (l < 0) {
                        throw new RuntimeException("List has less than zero elements");
                    }
                    this.it = this.list.actualList.listIterator(l);
                    if (this.it.hasPrevious()) break;
                }
                return true;
            }
            return this.it.hasPrevious();
        }

        @Override
        public T next() {
            if (!this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException("No more elements");
            }
            return this.it.previous();
        }

        public boolean isSamePosition(ExtensibleListIterator<T> it2) {
            return this.list.actualList == it2.list && this.it.previousIndex() == it2.it.previousIndex();
        }
    }
}

