/*
 * Decompiled with CFR 0.152.
 */
package soot.jimple.infoflow.values;

import java.util.List;
import soot.Local;
import soot.SootField;
import soot.SootMethod;
import soot.Unit;
import soot.Value;
import soot.jimple.AssignStmt;
import soot.jimple.Constant;
import soot.jimple.DoubleConstant;
import soot.jimple.FieldRef;
import soot.jimple.FloatConstant;
import soot.jimple.IntConstant;
import soot.jimple.LongConstant;
import soot.jimple.Stmt;
import soot.jimple.StringConstant;
import soot.jimple.infoflow.values.IValueProvider;
import soot.tagkit.DoubleConstantValueTag;
import soot.tagkit.FloatConstantValueTag;
import soot.tagkit.IntegerConstantValueTag;
import soot.tagkit.LongConstantValueTag;
import soot.tagkit.StringConstantValueTag;
import soot.toolkits.graph.BriefUnitGraph;
import soot.toolkits.graph.UnitGraph;
import soot.toolkits.scalar.SimpleLocalDefs;

public class SimpleConstantValueProvider
implements IValueProvider {
    public Object getValue(SootMethod sm, Stmt stmt, Value value, Class type) {
        if (value instanceof Constant) {
            return this.getConstantOfType(value, type);
        }
        if (value instanceof Local) {
            BriefUnitGraph ug = new BriefUnitGraph(sm.getActiveBody());
            SimpleLocalDefs du = new SimpleLocalDefs((UnitGraph)ug);
            List defs = du.getDefsOfAt((Local)value, (Unit)stmt);
            for (Unit def : defs) {
                Object constant;
                Value rightOp;
                if (!(def instanceof AssignStmt) || !((rightOp = ((AssignStmt)def).getRightOp()) instanceof FieldRef) || (constant = this.getConstantFromTag(((FieldRef)rightOp).getField(), type)) == null) continue;
                return constant;
            }
        }
        return null;
    }

    private Object getConstantOfType(Value value, Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            if (value instanceof IntConstant) {
                return ((IntConstant)value).value;
            }
        } else if (type == Long.TYPE || type == Long.class) {
            if (value instanceof LongConstant) {
                return ((LongConstant)value).value;
            }
        } else if (type == Float.TYPE || type == Float.class) {
            if (value instanceof FloatConstant) {
                return Float.valueOf(((FloatConstant)value).value);
            }
        } else if (type == Double.TYPE || type == Double.class) {
            if (value instanceof DoubleConstant) {
                return ((DoubleConstant)value).value;
            }
        } else if (type == String.class && value instanceof StringConstant) {
            return ((StringConstant)value).value;
        }
        return null;
    }

    private Object getConstantFromTag(SootField f, Class<?> type) {
        if (type == Integer.TYPE || type == Integer.class) {
            IntegerConstantValueTag t = (IntegerConstantValueTag)f.getTag("IntegerConstantValueTag");
            return t == null ? null : Integer.valueOf(t.getIntValue());
        }
        if (type == Long.TYPE || type == Long.class) {
            LongConstantValueTag t = (LongConstantValueTag)f.getTag("LongConstantValueTag");
            return t == null ? null : Long.valueOf(t.getLongValue());
        }
        if (type == Float.TYPE || type == Float.class) {
            FloatConstantValueTag t = (FloatConstantValueTag)f.getTag("FloatConstantValueTag");
            return t == null ? null : Float.valueOf(t.getFloatValue());
        }
        if (type == Double.TYPE || type == Double.class) {
            DoubleConstantValueTag t = (DoubleConstantValueTag)f.getTag("DoubleConstantValueTag");
            return t == null ? null : Double.valueOf(t.getDoubleValue());
        }
        if (type == String.class) {
            StringConstantValueTag t = (StringConstantValueTag)f.getTag("StringConstantValueTag");
            return t == null ? null : t.getStringValue();
        }
        return null;
    }
}

