/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck;

import de.fxnn.brainfuck.ProgramExecutionException;
import de.fxnn.brainfuck.interpreter.Interpreter;
import de.fxnn.brainfuck.interpreter.InterpreterException;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.program.Program;

public class ProgramExecutor
implements Runnable {
    Program program;
    Interpreter interpreter;

    public ProgramExecutor(Program program, Interpreter interpreter) {
        this.program = program;
        this.interpreter = interpreter;
    }

    @Override
    public void run() {
        try {
            InstructionPointer instructionPointer = this.program.getStartOfProgram();
            while (!instructionPointer.isEndOfProgram()) {
                instructionPointer = this.interpreter.step(instructionPointer);
                if (!Thread.currentThread().isInterrupted()) continue;
                throw new ProgramExecutionException("Program was interrputed: " + this.program);
            }
        }
        catch (InterpreterException ex) {
            throw new ProgramExecutionException("Error [" + ex.getMessage() + "] while interpreting the Brainfuck program [" + this.program + "]", ex);
        }
    }
}

