/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.cli;

import com.google.common.base.Joiner;
import de.fxnn.brainfuck.cli.ProgramStartupException;
import de.fxnn.brainfuck.tape.TapeEofBehaviour;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class BrainfuckOptionsFactory {
    static final boolean HAS_NO_ARG = false;
    public static final String HELP = "help";
    public static final String PROGRAM_CHARSET = "progenc";
    public static final String TAPE_CHARSET = "tapeenc";
    public static final String INPUT_FILE = "infile";
    public static final String OUTPUT_FILE = "outfile";
    public static final String EOF_BEHAVIOUR = "eof";
    public static final Map<String, TapeEofBehaviour> EOF_BEHAVIOUR_ARGUMENTS = BrainfuckOptionsFactory.createEofBehaviourArgumentsMap();
    public static final String PROGRAM_GIVEN_AS_ARGUMENT = "progarg";

    public Options createOptions() {
        Options options = new Options();
        options.addOption("h", HELP, false, "Display usage information.");
        options.addOption("a", PROGRAM_GIVEN_AS_ARGUMENT, false, "Give brainfuck source as commandline argument.");
        OptionBuilder.withLongOpt((String)TAPE_CHARSET);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CHARSET");
        OptionBuilder.withDescription((String)"Use given encoding for tape, input and output");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)PROGRAM_CHARSET);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"CHARSET");
        OptionBuilder.withDescription((String)"Use given encoding for programs");
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)EOF_BEHAVIOUR);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)Joiner.on((String)"|").join(EOF_BEHAVIOUR_ARGUMENTS.keySet()));
        OptionBuilder.withDescription((String)"Controls how to behave after reading an EOF");
        options.addOption(OptionBuilder.create((String)"e"));
        OptionBuilder.withLongOpt((String)INPUT_FILE);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PATH");
        OptionBuilder.withDescription((String)"Read input from file");
        OptionBuilder.withType(File.class);
        options.addOption(OptionBuilder.create((String)"i"));
        OptionBuilder.withLongOpt((String)OUTPUT_FILE);
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PATH");
        OptionBuilder.withDescription((String)"Write output to file");
        OptionBuilder.withType(File.class);
        options.addOption(OptionBuilder.create((String)"o"));
        return options;
    }

    public static TapeEofBehaviour eofBehaviourFromArgument(@Nullable String value, TapeEofBehaviour defaultValue) throws ProgramStartupException {
        if (value == null) {
            return defaultValue;
        }
        if (EOF_BEHAVIOUR_ARGUMENTS.containsKey(value)) {
            return EOF_BEHAVIOUR_ARGUMENTS.get(value);
        }
        throw new ProgramStartupException("Unknown value for the --eof option: " + value);
    }

    private static Map<String, TapeEofBehaviour> createEofBehaviourArgumentsMap() {
        HashMap<String, TapeEofBehaviour> result = new HashMap<String, TapeEofBehaviour>();
        result.put("-1", TapeEofBehaviour.READS_MINUS_ONE);
        result.put("0", TapeEofBehaviour.READS_ZERO);
        result.put("TERM", TapeEofBehaviour.THROWS);
        return result;
    }
}

