/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.interpreter;

import de.fxnn.brainfuck.interpreter.BrainfuckInstruction;
import de.fxnn.brainfuck.interpreter.FullBrainfuckInstructionSet;
import de.fxnn.brainfuck.interpreter.Interpreter;
import de.fxnn.brainfuck.interpreter.InterpreterException;
import de.fxnn.brainfuck.interpreter.LoopHandlingBrainfuckInstructionSet;
import de.fxnn.brainfuck.interpreter.LoopMode;
import de.fxnn.brainfuck.program.InstructionPointer;
import de.fxnn.brainfuck.tape.Tape;
import java.io.DataInput;
import java.io.DataOutput;
import java.util.ArrayDeque;
import java.util.Deque;

public class BrainfuckInterpreter
implements Interpreter {
    final Deque<InstructionPointer> instructionPointerStack = new ArrayDeque<InstructionPointer>();
    final Deque<LoopMode> loopModeStack = new ArrayDeque<LoopMode>();
    final FullBrainfuckInstructionSet fullBrainfuckInstructionSet;
    final LoopHandlingBrainfuckInstructionSet loopHandlingBrainfuckInstructionSet;

    public BrainfuckInterpreter(Tape<?> tape, DataInput input, DataOutput output) {
        this.fullBrainfuckInstructionSet = new FullBrainfuckInstructionSet(this.instructionPointerStack, this.loopModeStack, tape, input, output);
        this.loopHandlingBrainfuckInstructionSet = new LoopHandlingBrainfuckInstructionSet(this.instructionPointerStack, this.loopModeStack, tape);
    }

    @Override
    public InstructionPointer step(InstructionPointer instructionPointer) throws InterpreterException {
        BrainfuckInstruction instruction = BrainfuckInstruction.fromCharacter(instructionPointer.getInstruction());
        if (instruction != null) {
            if (this.isExecuteCurrentLoopOrNoLoopPresent()) {
                return instruction.step(instructionPointer, this.fullBrainfuckInstructionSet);
            }
            return instruction.step(instructionPointer, this.loopHandlingBrainfuckInstructionSet);
        }
        return instructionPointer.forward();
    }

    protected boolean isExecuteCurrentLoopOrNoLoopPresent() {
        return this.loopModeStack.isEmpty() || LoopMode.EXECUTED.equals((Object)this.loopModeStack.getLast());
    }
}

