/*
 * Decompiled with CFR 0.152.
 */
package de.fxnn.brainfuck.program;

import de.fxnn.brainfuck.program.Program;
import de.fxnn.brainfuck.program.TreeProgram;
import java.util.Collections;
import java.util.Iterator;

public class DepthFirstTreeProgramIterator
implements Iterator<Program> {
    private Iterator<Program> programsInCurrentLevel;
    private Iterator<Program> programsInChildLevel;

    public DepthFirstTreeProgramIterator(TreeProgram treeProgram) {
        this.programsInCurrentLevel = treeProgram.getChildPrograms().iterator();
        this.programsInChildLevel = Collections.emptyIterator();
    }

    @Override
    public boolean hasNext() {
        return this.programsInChildLevel.hasNext() || this.programsInCurrentLevel.hasNext();
    }

    @Override
    public Program next() {
        if (this.programsInChildLevel.hasNext()) {
            return this.programsInChildLevel.next();
        }
        Program next = this.programsInCurrentLevel.next();
        if (next instanceof TreeProgram) {
            this.programsInChildLevel = new DepthFirstTreeProgramIterator((TreeProgram)next);
        }
        return next;
    }
}

